/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.ecology.soil;

import java.util.Random;
import net.gegy1000.earth.server.world.ecology.soil.MesaSoilTexture;
import net.gegy1000.earth.server.world.ecology.soil.SoilTexture;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockSand;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.NoiseGeneratorPerlin;

public final class SoilTextures {
    private static final IBlockState GRASS_BLOCK = Blocks.field_150349_c.func_176223_P();
    private static final IBlockState DIRT_BLOCK = Blocks.field_150346_d.func_176223_P();
    private static final IBlockState COARSE_DIRT_BLOCK = Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT);
    private static final IBlockState PODZOL_BLOCK = Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL);
    private static final IBlockState CLAY_BLOCK = Blocks.field_150435_aG.func_176223_P();
    private static final IBlockState SAND_BLOCK = Blocks.field_150354_m.func_176223_P();
    private static final IBlockState RED_SAND_BLOCK = Blocks.field_150354_m.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.RED_SAND);
    private static final IBlockState GRAVEL_BLOCK = Blocks.field_150351_n.func_176223_P();
    private static final IBlockState SNOW_BLOCK = Blocks.field_150433_aE.func_176223_P();
    private static final IBlockState SANDSTONE_BLOCK = Blocks.field_150322_A.func_176223_P();
    private static final IBlockState RED_SANDSTONE_BLOCK = Blocks.field_180395_cM.func_176223_P();
    private static final IBlockState STONE_BLOCK = Blocks.field_150348_b.func_176223_P();
    private static final IBlockState TERRACOTTA_BLOCK = Blocks.field_150405_ch.func_176223_P();
    private static final NoiseGeneratorPerlin NOISE = new NoiseGeneratorPerlin(new Random(54321L), 1);
    public static final SoilTexture GRASS = SoilTextures.grass(GRASS_BLOCK);
    public static final SoilTexture PODZOL = SoilTextures.grass(PODZOL_BLOCK);
    public static final SoilTexture CLAY = SoilTextures.homogenous(CLAY_BLOCK);
    public static final SoilTexture COARSE_DIRT = SoilTextures.grass(COARSE_DIRT_BLOCK);
    public static final SoilTexture DESERT_SAND = SoilTextures.sand(SAND_BLOCK, SANDSTONE_BLOCK);
    public static final SoilTexture DESERT_RED_SAND = SoilTextures.sand(RED_SAND_BLOCK, RED_SANDSTONE_BLOCK);
    public static final SoilTexture SAND = SoilTextures.scatter(DESERT_SAND, GRASS, -0.5);
    public static final SoilTexture RED_SAND = SoilTextures.scatter(DESERT_RED_SAND, GRASS, -0.5);
    public static final SoilTexture ROCK = SoilTextures.homogenous(STONE_BLOCK);
    public static final SoilTexture SANDSTONE = SoilTextures.homogenous(SANDSTONE_BLOCK);
    public static final SoilTexture SNOW = (random, pos, slope, depth) -> {
        if (slope >= 40) {
            return STONE_BLOCK;
        }
        return SNOW_BLOCK;
    };
    public static final SoilTexture MESA = new MesaSoilTexture(new Random(1521L));
    public static final SoilTexture BEACH = SoilTextures.homogenous(SAND_BLOCK);
    public static final SoilTexture RIVER_BED = SoilTextures.binaryPatches(SoilTextures.homogenous(DIRT_BLOCK), SoilTextures.homogenous(CLAY_BLOCK), -0.5);
    public static final SoilTexture OCEAN_FLOOR = SoilTextures.homogenous(GRAVEL_BLOCK);
    public static final SoilTexture GRASS_AND_DIRT = SoilTextures.binaryPatches(GRASS, COARSE_DIRT, -0.2);
    public static final SoilTexture GRASS_AND_SAND = SoilTextures.binaryPatches(GRASS, DESERT_SAND, -0.2);
    public static final SoilTexture GRASS_AND_PODZOL = SoilTextures.binaryPatches(GRASS, PODZOL, -0.2);
    public static final SoilTexture GRASS_AND_CLAY = SoilTextures.binaryPatches(GRASS, CLAY, -0.2);

    private static SoilTexture grass(IBlockState grassBlock) {
        return (random, pos, slope, depth) -> {
            if (slope >= 60) {
                return STONE_BLOCK;
            }
            return depth == 0 ? grassBlock : DIRT_BLOCK;
        };
    }

    private static SoilTexture sand(IBlockState sandBlock, IBlockState sandstoneBlock) {
        return (random, pos, slope, depth) -> {
            if (slope >= 60) {
                return STONE_BLOCK;
            }
            if (slope >= 30) {
                return sandstoneBlock;
            }
            return sandBlock;
        };
    }

    private static SoilTexture homogenous(IBlockState block) {
        return (random, pos, slope, depth) -> block;
    }

    private static SoilTexture binaryPatches(SoilTexture a, SoilTexture b, double bias) {
        return (random, pos, slope, depth) -> {
            int x = pos.func_177958_n();
            int z = pos.func_177952_p();
            double noise = NOISE.func_151601_a((double)x / 24.0, (double)z / 24.0);
            if ((noise += (random.nextDouble() - random.nextDouble()) * 0.4) > bias) {
                return a.sample(random, pos, slope, depth);
            }
            return b.sample(random, pos, slope, depth);
        };
    }

    private static SoilTexture scatter(SoilTexture a, SoilTexture b, double bias) {
        double remappedBias = (bias + 1.0) / 2.0;
        return (random, pos, slope, depth) -> {
            if (random.nextDouble() > remappedBias) {
                return a.sample(random, pos, slope, depth);
            }
            return b.sample(random, pos, slope, depth);
        };
    }
}

