/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.ecology.soil;

import java.util.Arrays;
import java.util.Random;
import net.gegy1000.earth.server.world.ecology.soil.SoilTexture;
import net.minecraft.block.BlockColored;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.NoiseGeneratorPerlin;

public final class MesaSoilTexture
implements SoilTexture {
    private static final int BAND_COUNT = 64;
    private static final double NOISE_FREQUENCY = 0.001953125;
    private static final IBlockState TERRACOTTA = Blocks.field_150405_ch.func_176223_P();
    private static final IBlockState COLORED_TERRACOTTA = Blocks.field_150406_ce.func_176223_P();
    private static final IBlockState ORANGE_TERRACOTTA = COLORED_TERRACOTTA.func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE);
    private final IBlockState[] bands;
    private final NoiseGeneratorPerlin noise;

    public MesaSoilTexture(Random random) {
        this.bands = MesaSoilTexture.generateBands(random);
        this.noise = new NoiseGeneratorPerlin(random, 1);
    }

    private static IBlockState[] generateBands(Random random) {
        Object[] bands = new IBlockState[64];
        Arrays.fill(bands, TERRACOTTA);
        for (int i = 0; i < 64; ++i) {
            if ((i += random.nextInt(5) + 1) >= 64) continue;
            bands[i] = ORANGE_TERRACOTTA;
        }
        MesaSoilTexture.addSingleBands((IBlockState[])bands, random, 1, EnumDyeColor.YELLOW);
        MesaSoilTexture.addSingleBands((IBlockState[])bands, random, 2, EnumDyeColor.BROWN);
        MesaSoilTexture.addSingleBands((IBlockState[])bands, random, 1, EnumDyeColor.RED);
        MesaSoilTexture.addGradientBands((IBlockState[])bands, random, EnumDyeColor.WHITE, EnumDyeColor.SILVER);
        return bands;
    }

    private static void addSingleBands(IBlockState[] bands, Random random, int minDepth, EnumDyeColor color) {
        int count = random.nextInt(4) + 2;
        for (int i = 0; i < count; ++i) {
            int depth = random.nextInt(3) + minDepth;
            int start = random.nextInt(64);
            for (int y = 0; start + y < 64 && y < depth; ++y) {
                bands[start + y] = COLORED_TERRACOTTA.func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)color);
            }
        }
    }

    private static void addGradientBands(IBlockState[] bands, Random random, EnumDyeColor main, EnumDyeColor fade) {
        int count = random.nextInt(3) + 3;
        int y = 0;
        for (int i = 0; i < count && (y += random.nextInt(16) + 4) < 64; ++i) {
            bands[y] = COLORED_TERRACOTTA.func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)main);
            if (y > 1 && random.nextBoolean()) {
                bands[y - 1] = COLORED_TERRACOTTA.func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)fade);
            }
            if (y >= 63 || !random.nextBoolean()) continue;
            bands[y + 1] = COLORED_TERRACOTTA.func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)fade);
        }
    }

    @Override
    public IBlockState sample(Random random, BlockPos pos, int slope, int depth) {
        double noise = this.noise.func_151601_a((double)pos.func_177958_n() * 0.001953125, (double)pos.func_177952_p() * 0.001953125);
        int offset = (int)Math.round(noise * 2.0);
        return this.bands[(pos.func_177956_o() + offset + 64) % 64];
    }
}

