/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.ecology.maxent;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import net.gegy1000.earth.TerrariumEarth;
import net.gegy1000.earth.server.world.ecology.GrowthIndicator;
import net.gegy1000.earth.server.world.ecology.maxent.MaxentCompiler;
import net.gegy1000.earth.server.world.ecology.maxent.MaxentLambdasFile;
import net.gegy1000.earth.server.world.ecology.maxent.MaxentOutput;
import net.gegy1000.earth.server.world.ecology.maxent.MaxentParseException;
import net.gegy1000.earth.server.world.ecology.maxent.feature.MaxentFeature;
import net.gegy1000.earth.server.world.ecology.maxent.feature.OutputFeature;
import net.minecraft.util.ResourceLocation;

public final class MaxentGrowthIndicator {
    private MaxentGrowthIndicator() {
    }

    public static Optional<GrowthIndicator> tryParse(ResourceLocation location) {
        try {
            MaxentLambdasFile lambdasFile = MaxentLambdasFile.parse(location);
            return Optional.of(MaxentGrowthIndicator.from(lambdasFile, MaxentOutput.CLOGLOG));
        }
        catch (IOException | MaxentParseException e) {
            TerrariumEarth.LOGGER.error("Failed to load maxent growth indicator at {}", (Object)location, (Object)e);
            return Optional.empty();
        }
    }

    public static GrowthIndicator from(MaxentLambdasFile lambdasFile, MaxentOutput output) {
        float linearPredictorNormalizer = lambdasFile.getFieldOr("linearPredictorNormalizer", 0.0f);
        float densityNormalizer = lambdasFile.getFieldOr("densityNormalizer", 1.0f);
        float entropy = lambdasFile.getFieldOr("entropy", 0.0f);
        OutputFeature feature = new OutputFeature((List<MaxentFeature>)lambdasFile.getFeatures(), linearPredictorNormalizer, densityNormalizer, entropy, output);
        return MaxentCompiler.compileFeature(feature);
    }
}

