/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.data.source.cache;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.gegy1000.earth.server.world.data.source.cache.TileCache;

public final class FileTileCache<T>
implements TileCache<T> {
    private final Function<T, Path> pathFunction;

    public FileTileCache(Function<T, Path> pathFunction) {
        this.pathFunction = pathFunction;
    }

    private Path getCachePath(T key) {
        if (this.pathFunction != null) {
            return this.pathFunction.apply(key);
        }
        return null;
    }

    @Override
    @Nullable
    public InputStream in(T key) throws IOException {
        Path cachePath = this.getCachePath(key);
        if (cachePath != null && Files.exists(cachePath, new LinkOption[0])) {
            return Files.newInputStream(cachePath, new OpenOption[0]);
        }
        return null;
    }

    @Override
    @Nullable
    public OutputStream out(T key) throws IOException {
        Path cachePath = this.getCachePath(key);
        if (cachePath == null) {
            return null;
        }
        Files.createDirectories(cachePath.getParent(), new FileAttribute[0]);
        return Files.newOutputStream(cachePath, new OpenOption[0]);
    }

    @Override
    public void delete(T key) throws IOException {
        Path cachePath = this.getCachePath(key);
        if (cachePath != null) {
            Files.deleteIfExists(cachePath);
        }
    }
}

