/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.data;

import com.google.common.base.Strings;
import com.google.gson.annotations.SerializedName;
import java.util.Base64;
import javax.annotation.Nullable;

public class EarthApiKeys {
    @SerializedName(value="geocoder_key")
    private String geocoderKey = "";
    @SerializedName(value="autocomplete_key")
    private String autocompleteKey = "";
    @SerializedName(value="streetview_key")
    private String streetviewKey = "";

    @Nullable
    public String getGeocoderKey() {
        return this.decode(this.geocoderKey, 31);
    }

    @Nullable
    public String getAutocompleteKey() {
        return this.decode(this.autocompleteKey, 961);
    }

    @Nullable
    public String getStreetviewKey() {
        return this.decode(this.streetviewKey, 729);
    }

    @Nullable
    private String decode(String encoded, int shift) {
        if (Strings.isNullOrEmpty((String)encoded)) {
            return null;
        }
        byte[] encodedKeyBytes = Base64.getDecoder().decode(encoded);
        byte[] decodedBytes = new byte[encodedKeyBytes.length];
        for (int i = 0; i < encodedKeyBytes.length; ++i) {
            decodedBytes[i] = (byte)(encodedKeyBytes[i] - (i << i) - shift);
        }
        return new String(decodedBytes);
    }
}

