/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.composer.structure.data;

import it.unimi.dsi.fastutil.HashCommon;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;

public final class LossyColumnMap<T> {
    private final long[] keys;
    private final T[] values;
    private final int capacity;
    private final int mask;

    public LossyColumnMap(int capacity) {
        this.capacity = MathHelper.func_151236_b((int)capacity);
        this.mask = this.capacity - 1;
        this.keys = new long[this.capacity];
        this.values = new Object[this.capacity];
        this.clear();
    }

    private static int hash(long key) {
        return HashCommon.long2int((long)HashCommon.mix((long)key));
    }

    public void put(int x, int z, T value) {
        long key = ChunkPos.func_77272_a((int)x, (int)z);
        int idx = LossyColumnMap.hash(key) & this.mask;
        this.values[idx] = value;
        this.keys[idx] = key;
    }

    @Nullable
    public T get(int x, int z) {
        long key = ChunkPos.func_77272_a((int)x, (int)z);
        int idx = LossyColumnMap.hash(key) & this.mask;
        if (this.keys[idx] == key) {
            return this.values[idx];
        }
        return null;
    }

    public void clear() {
        Arrays.fill(this.keys, Long.MIN_VALUE);
        Arrays.fill(this.values, null);
    }
}

