/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.shared;

import com.google.gson.Gson;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import net.gegy1000.earth.TerrariumEarth;
import net.gegy1000.earth.server.shared.SharedDataInitializer;
import net.gegy1000.earth.server.shared.SharedEarthData;
import net.gegy1000.earth.server.util.ProcessTracker;
import net.gegy1000.earth.server.util.TrackedInputStream;
import net.gegy1000.earth.server.world.data.EarthApiKeys;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public final class ApiKeyInitializer
implements SharedDataInitializer {
    private static final String KEYS_URL = "https://terrarium.gegy.dev/geo3/keys.json";
    private static final Gson GSON = new Gson();

    @Override
    public void initialize(SharedEarthData data, ProcessTracker processTracker) {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(KEYS_URL).openConnection();
            connection.setRequestProperty("User-Agent", "terrarium");
            try (TrackedInputStream input = new TrackedInputStream(connection.getInputStream());){
                input.submitTo((ITextComponent)new TextComponentTranslation("initializer.terrarium.api_keys", new Object[0]), processTracker);
                EarthApiKeys keys = ApiKeyInitializer.loadKeys(input);
                data.put(SharedEarthData.API_KEYS, keys);
            }
        }
        catch (IOException e) {
            TerrariumEarth.LOGGER.warn("Failed to get API keys", (Throwable)e);
        }
    }

    private static EarthApiKeys loadKeys(InputStream input) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(new BufferedInputStream(input));){
            EarthApiKeys earthApiKeys = (EarthApiKeys)GSON.fromJson((Reader)reader, EarthApiKeys.class);
            return earthApiKeys;
        }
    }
}

