/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.integration.dyntrees;

import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import java.util.Optional;
import net.gegy1000.earth.server.event.CollectTreeGeneratorsEvent;
import net.gegy1000.earth.server.world.ecology.SoilPredicate;
import net.gegy1000.earth.server.world.ecology.vegetation.TreeGenerators;
import net.gegy1000.earth.server.world.ecology.vegetation.VegetationGenerator;
import net.gegy1000.terrarium.server.util.Lazy;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class DynamicTreesIntegration {
    private static final Lazy<Optional<Species>> ACACIA = DynamicTreesIntegration.species("acacia");
    private static final Lazy<Optional<Species>> BIRCH = DynamicTreesIntegration.species("birch");
    private static final Lazy<Optional<Species>> JUNGLE = DynamicTreesIntegration.species("jungle");
    private static final Lazy<Optional<Species>> OAK = DynamicTreesIntegration.species("oak");
    private static final Lazy<Optional<Species>> SPRUCE = DynamicTreesIntegration.species("spruce");

    private static Lazy<Optional<Species>> species(String name) {
        return Lazy.ofRegistry(Species.REGISTRY, new ResourceLocation("dynamictrees", name));
    }

    public static void setup() {
        MinecraftForge.EVENT_BUS.register(DynamicTreesIntegration.class);
    }

    @SubscribeEvent
    public static void onCollectTreeGenerators(CollectTreeGeneratorsEvent event) {
        TreeGenerators generators = event.getGenerators();
        ACACIA.get().ifPresent(acacia -> {
            generators.acacia = DynamicTreesIntegration.generator(acacia, 3, 5);
        });
        BIRCH.get().ifPresent(birch -> {
            generators.birch = DynamicTreesIntegration.generator(birch, 2, 4);
        });
        JUNGLE.get().ifPresent(jungle -> {
            generators.jungle = DynamicTreesIntegration.generator(jungle, 3, 5);
        });
        OAK.get().ifPresent(oak -> {
            generators.oak = DynamicTreesIntegration.generator(oak, 2, 4);
        });
        SPRUCE.get().ifPresent(spruce -> {
            VegetationGenerator generator;
            generators.spruce = generator = DynamicTreesIntegration.generator(spruce, 3, 5);
            generators.pine = generator;
        });
    }

    private static VegetationGenerator generator(Species species, int minRadius, int maxRadius) {
        return (world, random, pos) -> {
            BlockPos soilPos = pos.func_177977_b();
            if (!SoilPredicate.ANY.canGrowOn(world, soilPos)) {
                return;
            }
            Biome biome = world.func_180494_b(pos);
            int radius = random.nextInt(maxRadius - minRadius + 1) + minRadius;
            ChunkPos columnPos = new ChunkPos(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
            SafeChunkBounds safeBounds = new SafeChunkBounds(world, columnPos);
            species.generate(world, soilPos, biome, random, radius, safeBounds);
        };
    }
}

