/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.integration.bop;

import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.world.generator.tree.GeneratorMangroveTree;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PatchedMangroveTreeFeature
extends GeneratorMangroveTree {
    public PatchedMangroveTreeFeature(float amountPerChunk, IBlockPosQuery placeOn, IBlockPosQuery replace, IBlockState log, IBlockState leaves, IBlockState vine, IBlockState hanging, IBlockState trunkFruit, IBlockState altLeaves, int minHeight, int maxHeight, int minLeavesRadius, int leavesGradient, int vineAttempts, int maxVineLength, IBlockPosQuery rootsReplace, GeneratorUtils.ScatterYMethod scatterYMethod) {
        super(amountPerChunk, placeOn, replace, log, leaves, vine, hanging, trunkFruit, altLeaves, minHeight, maxHeight, minLeavesRadius, leavesGradient, vineAttempts, maxVineLength, rootsReplace, scatterYMethod);
    }

    public boolean checkSpace(World world, BlockPos pos, int rootHeight, int middleHeight, int height) {
        if (this.countViableRoots(world, pos, rootHeight) < 2) {
            return false;
        }
        if (pos.func_177956_o() + height >= world.func_72800_K() - 1) {
            return false;
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int y = rootHeight; y <= height; ++y) {
            int radius = y <= rootHeight + middleHeight ? 1 : 2;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    mutablePos.func_181079_c(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
                    if (this.replace.matches(world, (BlockPos)mutablePos)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private int countViableRoots(World world, BlockPos pos, int rootHeight) {
        int rootsViable = 0;
        for (EnumFacing direction : EnumFacing.Plane.HORIZONTAL) {
            if (!this.checkRootViable(world, pos, rootHeight, direction)) continue;
            ++rootsViable;
        }
        return rootsViable;
    }

    public static class Builder
    extends GeneratorMangroveTree.Builder {
        public PatchedMangroveTreeFeature create() {
            return new PatchedMangroveTreeFeature(this.amountPerChunk, this.placeOn, this.replace, this.log, this.leaves, this.vine, this.hanging, this.trunkFruit, this.altLeaves, this.minHeight, this.maxHeight, this.minLeavesRadius, this.leavesGradient, this.vineAttempts, this.maxVineLength, this.rootsReplace, this.scatterYMethod);
        }
    }
}

