/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.command;

import com.google.common.base.Strings;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.vecmath.Vector2d;
import net.gegy1000.earth.TerrariumEarth;
import net.gegy1000.earth.server.capability.EarthWorld;
import net.gegy1000.earth.server.command.DeferredTranslator;
import net.gegy1000.terrarium.Terrarium;
import net.gegy1000.terrarium.server.world.coordinate.Coordinate;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.EntityNotFoundException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class GeoTeleportCommand
extends CommandBase {
    public String func_71517_b() {
        return "geotp";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender sender) {
        return DeferredTranslator.translateStringOrKey(sender, "commands.earth.geotp.usage");
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        Entity entity = GeoTeleportCommand.getTeleportedEntity(server, sender, args);
        EarthWorld earth = (EarthWorld)entity.field_70170_p.getCapability(TerrariumEarth.worldCap(), null);
        if (earth == null) {
            throw DeferredTranslator.createException((ICommandSender)entity, "commands.earth.wrong_world", new Object[0]);
        }
        String argument = String.join((CharSequence)" ", args).replace(',', ' ');
        String[] locationInput = argument.split("\\s+");
        Thread thread = new Thread(() -> {
            try {
                CommandLocation location = this.parseLocation(sender, locationInput);
                Coordinate coordinate = location.getCoordinate(sender, earth);
                this.teleport(server, entity, earth, coordinate);
            }
            catch (CommandException e) {
                TextComponentTranslation message = new TextComponentTranslation(e.getMessage(), e.func_74844_a());
                message.func_150256_b().func_150238_a(TextFormatting.RED);
                sender.func_145747_a((ITextComponent)message);
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    private static Entity getTeleportedEntity(MinecraftServer server, ICommandSender sender, String[] args) throws EntityNotFoundException {
        EntityPlayerMP player = GeoTeleportCommand.getPlayerSender(sender);
        if (args.length == 3) {
            try {
                return GeoTeleportCommand.func_184885_b((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
            }
            catch (CommandException commandException) {
                // empty catch block
            }
        }
        if (player == null) {
            throw new EntityNotFoundException("Not player or no entity selector given");
        }
        return player;
    }

    private static EntityPlayerMP getPlayerSender(ICommandSender sender) {
        try {
            return GeoTeleportCommand.func_71521_c((ICommandSender)sender);
        }
        catch (CommandException e) {
            return null;
        }
    }

    private CommandLocation parseLocation(ICommandSender sender, String[] input) throws WrongUsageException {
        CommandLocation location = this.parseCoordinateLocation(input);
        if (location == null) {
            String place = String.join((CharSequence)" ", input);
            if (Strings.isNullOrEmpty((String)place)) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            location = new GeocodeLocation(place);
        }
        return location;
    }

    private CommandLocation parseCoordinateLocation(String[] input) {
        if (input.length == 2) {
            double[] coordinates = new double[2];
            for (int i = 0; i < 2; ++i) {
                try {
                    coordinates[i] = Double.parseDouble(input[i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            return new CoordinateLocation(coordinates[0], coordinates[1]);
        }
        return null;
    }

    private void teleport(MinecraftServer server, Entity entity, EarthWorld earthData, Coordinate coordinate) {
        int blockX = MathHelper.func_76128_c((double)coordinate.blockX());
        int blockZ = MathHelper.func_76128_c((double)coordinate.blockZ());
        World world = entity.field_70170_p;
        BlockPos surface = earthData.estimateSurface(world, blockX, blockZ);
        server.func_152344_a(() -> {
            int height = this.resolveHeight(world, blockX, blockZ, surface);
            entity.func_184210_p();
            entity.field_70142_S = entity.field_70165_t;
            entity.field_70137_T = entity.field_70163_u;
            entity.field_70136_U = entity.field_70161_v;
            entity.field_70159_w = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70179_y = 0.0;
            entity.field_70122_E = true;
            if (entity instanceof EntityPlayerMP) {
                NetHandlerPlayServer connection = ((EntityPlayerMP)entity).field_71135_a;
                connection.func_147364_a(coordinate.blockX(), (double)height + 0.5, coordinate.blockZ(), 180.0f, 0.0f);
            }
            entity.func_145747_a(DeferredTranslator.translate((ICommandSender)entity, (ITextComponent)new TextComponentTranslation("commands.earth.geotp.success", new Object[]{entity.func_70005_c_(), coordinate.z(), coordinate.x()})));
        });
    }

    private int resolveHeight(World world, int x, int z, @Nullable BlockPos terrainSurface) {
        if (terrainSurface != null && !world.func_190526_b(x, z)) {
            return terrainSurface.func_177956_o();
        }
        return world.func_175672_r(new BlockPos(x, 0, z)).func_177956_o();
    }

    private static class GeocodeLocation
    implements CommandLocation {
        private final String place;

        private GeocodeLocation(String place) {
            this.place = place;
        }

        @Override
        public Coordinate getCoordinate(ICommandSender sender, EarthWorld worldData) throws CommandException {
            try {
                Vector2d coordinate = worldData.getGeocoder().get(this.place);
                if (coordinate == null) {
                    throw DeferredTranslator.createException(sender, "commands.earth.geotp.not_found", this.place);
                }
                return new Coordinate(worldData.getCrs(), coordinate.getY(), coordinate.getX());
            }
            catch (IOException e) {
                Terrarium.LOGGER.error("Failed to get geocode for {}", (Object)this.place, (Object)e);
                throw DeferredTranslator.createException(sender, "commands.earth.geotp.error", this.place, e.getClass().getSimpleName(), e.getMessage());
            }
        }
    }

    private static class CoordinateLocation
    implements CommandLocation {
        private final double latitude;
        private final double longitude;

        private CoordinateLocation(double latitude, double z) {
            this.latitude = latitude;
            this.longitude = z;
        }

        @Override
        public Coordinate getCoordinate(ICommandSender sender, EarthWorld worldData) {
            return new Coordinate(worldData.getCrs(), this.longitude, this.latitude);
        }
    }

    private static interface CommandLocation {
        public Coordinate getCoordinate(ICommandSender var1, EarthWorld var2) throws CommandException;
    }
}

