/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.client.gui.widget.map;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import javax.imageio.ImageIO;
import net.gegy1000.earth.client.gui.widget.map.SlippyMapTile;
import net.gegy1000.earth.client.gui.widget.map.SlippyMapTilePos;
import net.gegy1000.terrarium.Terrarium;
import net.gegy1000.terrarium.server.world.data.source.TerrariumCacheDirs;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;

@SideOnly(value=Side.CLIENT)
public class SlippyMapTileCache {
    private static final Path CACHE_ROOT = TerrariumCacheDirs.GLOBAL_ROOT.resolve("carto");
    private static final int CACHE_SIZE = 256;
    private final ExecutorService loadingService = Executors.newFixedThreadPool(2, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("terrarium-map-load-%d").build());
    private final LoadingCache<SlippyMapTilePos, SlippyMapTile> tileCache = CacheBuilder.newBuilder().maximumSize(256L).removalListener(notification -> {
        SlippyMapTile tile = (SlippyMapTile)notification.getValue();
        if (tile != null) {
            tile.delete();
        }
    }).build((CacheLoader)new CacheLoader<SlippyMapTilePos, SlippyMapTile>(){

        public SlippyMapTile load(SlippyMapTilePos key) {
            SlippyMapTile tile = new SlippyMapTile(key);
            SlippyMapTileCache.this.loadingService.submit(() -> tile.supplyImage(SlippyMapTileCache.this.downloadImage(key)));
            return tile;
        }
    });
    private final Queue<InputStream> loadingStreams = new LinkedBlockingQueue<InputStream>();

    public SlippyMapTile getTile(SlippyMapTilePos pos) {
        try {
            return (SlippyMapTile)this.tileCache.get((Object)pos);
        }
        catch (Exception e) {
            SlippyMapTile tile = new SlippyMapTile(pos);
            tile.supplyImage(this.createErrorImage());
            return tile;
        }
    }

    public void shutdown() {
        for (SlippyMapTile tile : this.tileCache.asMap().values()) {
            tile.delete();
        }
        this.tileCache.invalidateAll();
        this.loadingService.shutdown();
        while (!this.loadingStreams.isEmpty()) {
            try {
                this.loadingStreams.poll().close();
            }
            catch (IOException e) {
                Terrarium.LOGGER.warn("Failed to close loading map stream", (Throwable)e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BufferedImage downloadImage(SlippyMapTilePos pos) {
        try (InputStream input = this.getStream(pos);){
            BufferedImage bufferedImage = ImageIO.read(input);
            return bufferedImage;
        }
        catch (IOException e) {
            Terrarium.LOGGER.error("Failed to load map tile {}", (Object)e.getClass().getName());
            return this.createErrorImage();
        }
    }

    private InputStream getStream(SlippyMapTilePos pos) throws IOException {
        Path cachePath = CACHE_ROOT.resolve(pos.getCacheName());
        if (Files.exists(cachePath, new LinkOption[0])) {
            return new BufferedInputStream(Files.newInputStream(cachePath, new OpenOption[0]));
        }
        URL url = new URL(String.format("http://tile.openstreetmap.org/%s/%s/%s.png", pos.getZoom(), pos.getX(), pos.getY()));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(1000);
        connection.setReadTimeout(5000);
        connection.setRequestProperty("User-Agent", "terrarium");
        InputStream stream = connection.getInputStream();
        this.loadingStreams.add(stream);
        try (BufferedInputStream input = new BufferedInputStream(stream);){
            byte[] data = IOUtils.toByteArray((InputStream)input);
            this.cacheData(cachePath, data);
            this.loadingStreams.remove(stream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
            return byteArrayInputStream;
        }
    }

    private void cacheData(Path cachePath, byte[] data) {
        try {
            Files.createDirectories(CACHE_ROOT, new FileAttribute[0]);
        }
        catch (IOException e) {
            Terrarium.LOGGER.error("Failed to create cache root");
        }
        try (OutputStream output = Files.newOutputStream(cachePath, new OpenOption[0]);){
            output.write(data);
        }
        catch (IOException e) {
            Terrarium.LOGGER.error("Failed to cache map raster tile", (Throwable)e);
        }
    }

    private BufferedImage createErrorImage() {
        BufferedImage result = new BufferedImage(256, 256, 1);
        Graphics2D graphics = result.createGraphics();
        FontMetrics metrics = graphics.getFontMetrics();
        String message = "Failed to download tile";
        int x = (256 - metrics.stringWidth(message)) / 2;
        int y = (256 - metrics.getHeight()) / 2;
        graphics.drawString(message, x, y);
        graphics.dispose();
        return result;
    }
}

