/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.client.gui.preview;

import net.gegy1000.earth.client.gui.preview.WorldPreview;
import net.gegy1000.terrarium.client.gui.GuiRenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class PreviewRenderer {
    private static final Minecraft MC = Minecraft.func_71410_x();
    private final GuiScreen gui;
    private final double x;
    private final double y;
    private final double width;
    private final double height;

    public PreviewRenderer(GuiScreen gui, double x, double y, double width, double height) {
        this.gui = gui;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void render(WorldPreview preview, float zoom, float rotationX, float rotationY) {
        this.renderBackground();
        if (preview != null) {
            ScaledResolution resolution = new ScaledResolution(MC);
            double scaleFactor = resolution.func_78325_e();
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)scaleFactor, (double)scaleFactor, (double)scaleFactor);
            GL11.glEnable((int)3089);
            GuiRenderUtils.scissor(this.x, this.y, this.width, this.height);
            GlStateManager.func_179091_B();
            GlStateManager.func_179090_x();
            GlStateManager.func_179126_j();
            GlStateManager.func_179137_b((double)((this.x + (double)this.gui.field_146294_l) / 2.0 / scaleFactor), (double)((this.y + this.height) / 2.0 / scaleFactor), (double)0.0);
            GlStateManager.func_179152_a((float)zoom, (float)(-zoom), (float)zoom);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderHelper.func_74519_b();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-100.0);
            GlStateManager.func_179114_b((float)rotationX, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)rotationY, (float)0.0f, (float)1.0f, (float)0.0f);
            preview.render();
            GlStateManager.func_179121_F();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179098_w();
            GlStateManager.func_179101_C();
            GL11.glDisable((int)3089);
            GlStateManager.func_179121_F();
        }
        this.renderEdges();
    }

    private void renderBackground() {
        MC.func_110434_K().func_110577_a(Gui.field_110325_k);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        double tileSize = 32.0;
        GlStateManager.func_179131_c((float)0.125f, (float)0.125f, (float)0.125f, (float)1.0f);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(this.x, this.y + this.height, 0.0).func_187315_a(this.x / tileSize, (this.y + this.height) / tileSize).func_181675_d();
        buffer.func_181662_b(this.x + this.width, this.y + this.height, 0.0).func_187315_a((this.x + this.width) / tileSize, (this.y + this.height) / tileSize).func_181675_d();
        buffer.func_181662_b(this.x + this.width, this.y, 0.0).func_187315_a((this.x + this.width) / tileSize, this.y / tileSize).func_181675_d();
        buffer.func_181662_b(this.x, this.y, 0.0).func_187315_a(this.x / tileSize, this.y / tileSize).func_181675_d();
        tessellator.func_78381_a();
    }

    private void renderEdges() {
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.func_179118_c();
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b(this.x, this.y + this.height, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        buffer.func_181662_b(this.x + this.width, this.y + this.height, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        buffer.func_181662_b(this.x + this.width, this.y + this.height - 4.0, 0.0).func_181669_b(0, 0, 0, 0).func_181675_d();
        buffer.func_181662_b(this.x, this.y + this.height - 4.0, 0.0).func_181669_b(0, 0, 0, 0).func_181675_d();
        tessellator.func_78381_a();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b(this.x, this.y + 4.0, 0.0).func_181669_b(0, 0, 0, 0).func_181675_d();
        buffer.func_181662_b(this.x + this.width, this.y + 4.0, 0.0).func_181669_b(0, 0, 0, 0).func_181675_d();
        buffer.func_181662_b(this.x + this.width, this.y, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        buffer.func_181662_b(this.x, this.y, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179141_d();
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }
}

