/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.gengen.api.generator;

import dev.gegy.gengen.api.generator.GenericChunkPopulator;
import dev.gegy.gengen.api.generator.GenericChunkPrimer;
import dev.gegy.gengen.api.generator.GenericStructureGenerator;
import dev.gegy.gengen.core.GenGen;
import dev.gegy.gengen.core.impl.cubic.CubeGeneratorImpl;
import dev.gegy.gengen.core.impl.vanilla.ColumnGeneratorImpl;
import dev.gegy.gengen.core.support.BukkitSupport;
import dev.gegy.gengen.core.support.SpongeSupport;
import io.github.opencubicchunks.cubicchunks.api.worldgen.ICubeGenerator;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public interface GenericChunkGenerator
extends GenericChunkPrimer,
GenericChunkPopulator,
GenericStructureGenerator {
    @Nullable
    public static GenericChunkGenerator unwrap(World world) {
        return GenGen.proxy(world).unwrapChunkGenerator(world);
    }

    @Nullable
    public static GenericChunkGenerator unwrap(IChunkGenerator generator) {
        generator = SpongeSupport.unwrapChunkGenerator(generator);
        if ((generator = BukkitSupport.unwrapChunkGenerator(generator)) instanceof ColumnGeneratorImpl) {
            return ((ColumnGeneratorImpl)generator).getInner();
        }
        return null;
    }

    @Nullable
    public static GenericChunkGenerator unwrap(ICubeGenerator generator) {
        if (generator instanceof CubeGeneratorImpl) {
            return ((CubeGeneratorImpl)generator).getInner();
        }
        return null;
    }

    default public void generateColumn(Chunk column) {
    }

    default public List<Biome.SpawnListEntry> getPossibleCreatures(EnumCreatureType type, BlockPos pos) {
        return Collections.emptyList();
    }
}

