/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.blocks.vectorart;

import io.netty.buffer.ByteBuf;
import mcjty.rftoolscontrol.blocks.vectorart.GfxOpBox;
import mcjty.rftoolscontrol.blocks.vectorart.GfxOpLine;
import mcjty.rftoolscontrol.blocks.vectorart.GfxOpText;
import mcjty.rftoolscontrol.blocks.vectorart.GfxOpType;
import net.minecraft.nbt.NBTTagCompound;

public abstract class GfxOp {
    public abstract void render();

    public abstract GfxOpType getType();

    public static GfxOp readFromNBT(NBTTagCompound tag) {
        GfxOpType type = GfxOpType.values()[tag.func_74771_c("type")];
        GfxOp op = GfxOp.createGfxOp(type);
        op.readFromNBTInternal(tag);
        return op;
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74774_a("type", (byte)this.getType().ordinal());
        this.writeToNBTInternal(tag);
        return tag;
    }

    protected abstract void readFromNBTInternal(NBTTagCompound var1);

    protected abstract void writeToNBTInternal(NBTTagCompound var1);

    public static GfxOp readFromBuf(ByteBuf buf) {
        GfxOpType type = GfxOpType.values()[buf.readByte()];
        GfxOp op = GfxOp.createGfxOp(type);
        op.readFromBufInternal(buf);
        return op;
    }

    private static GfxOp createGfxOp(GfxOpType type) {
        GfxOp op = null;
        switch (type) {
            case OP_BOX: {
                op = new GfxOpBox();
                break;
            }
            case OP_LINE: {
                op = new GfxOpLine();
                break;
            }
            case OP_TEXT: {
                op = new GfxOpText();
            }
        }
        return op;
    }

    public void writeToBuf(ByteBuf buf) {
        buf.writeByte(this.getType().ordinal());
        this.writeToBufInternal(buf);
    }

    protected abstract void readFromBufInternal(ByteBuf var1);

    protected abstract void writeToBufInternal(ByteBuf var1);
}

