/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.systems;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.items.instances.ItemItem;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.jsondefs.JSONItem;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packloading.JSONParser;
import minecrafttransportsimulator.packloading.PackParser;

public class LanguageSystem {
    public static final Map<String, LanguageEntry> coreLanguageEntires = new LinkedHashMap<String, LanguageEntry>();
    private static final Map<String, Map<String, LanguageEntry>> packLanguageEntries = new LinkedHashMap<String, Map<String, LanguageEntry>>();
    private static boolean onClient;
    private static File dumpToFolder;
    public static final LanguageEntry DEATH_BULLET_NULL;
    public static final LanguageEntry DEATH_BULLET_PLAYER;
    public static final LanguageEntry DEATH_PROPELLER_NULL;
    public static final LanguageEntry DEATH_PROPELLER_PLAYER;
    public static final LanguageEntry DEATH_JETINTAKE_NULL;
    public static final LanguageEntry DEATH_JETINTAKE_PLAYER;
    public static final LanguageEntry DEATH_JETEXHAUST_NULL;
    public static final LanguageEntry DEATH_JETEXHAUST_PLAYER;
    public static final LanguageEntry DEATH_WHEEL_NULL;
    public static final LanguageEntry DEATH_WHEEL_PLAYER;
    public static final LanguageEntry DEATH_CRASH_NULL;
    public static final LanguageEntry DEATH_CRASH_PLAYER;
    public static final LanguageEntry GUI_CONFIRM;
    public static final LanguageEntry GUI_MASTERCONFIG;
    public static final LanguageEntry GUI_IMPORT;
    public static final LanguageEntry GUI_SIGNALCONTROLLER_SCAN;
    public static final LanguageEntry GUI_SIGNALCONTROLLER_SCANDISTANCE;
    public static final LanguageEntry GUI_SIGNALCONTROLLER_SCANCENTER;
    public static final LanguageEntry GUI_SIGNALCONTROLLER_SCANFOUND;
    public static final LanguageEntry GUI_SIGNALCONTROLLER_RIGHTHANDDRIVE;
    public static final LanguageEntry GUI_SIGNALCONTROLLER_LEFTHANDDRIVE;
    public static final LanguageEntry GUI_SIGNALCONTROLLER_TIMEMODE;
    public static final LanguageEntry GUI_SIGNALCONTROLLER_TRIGGERMODE;
    public static final LanguageEntry GUI_SIGNALCONTROLLER_PRIMARYAXIS;
    public static final LanguageEntry GUI_SIGNALCONTROLLER_LANEWIDTH;
    public static final LanguageEntry GUI_SIGNALCONTROLLER_GREENMAINTIME;
    public static final LanguageEntry GUI_SIGNALCONTROLLER_GREENCROSSTIME;
    public static final LanguageEntry GUI_SIGNALCONTROLLER_YELLOWMAINTIME;
    public static final LanguageEntry GUI_SIGNALCONTROLLER_YELLOWCROSSTIME;
    public static final LanguageEntry GUI_SIGNALCONTROLLER_ALLREDTIME;
    public static final LanguageEntry GUI_SIGNALCONTROLLER_LANESETTINGS;
    public static final LanguageEntry GUI_SIGNALCONTROLLER_SIGNALSETTINGS;
    public static final LanguageEntry GUI_SIGNALCONTROLLER_LEFTLANES;
    public static final LanguageEntry GUI_SIGNALCONTROLLER_CENTERLANES;
    public static final LanguageEntry GUI_SIGNALCONTROLLER_RIGHTLANES;
    public static final LanguageEntry GUI_SIGNALCONTROLLER_ROADWIDTH;
    public static final LanguageEntry GUI_SIGNALCONTROLLER_CENTERDIST;
    public static final LanguageEntry GUI_SIGNALCONTROLLER_MEDIANDIST;
    public static final LanguageEntry GUI_PART_BENCH_WEIGHT;
    public static final LanguageEntry GUI_PART_BENCH_FUEL;
    public static final LanguageEntry GUI_PART_BENCH_CONTROLLERS;
    public static final LanguageEntry GUI_PART_BENCH_PASSENGERS;
    public static final LanguageEntry GUI_PART_BENCH_CARGO;
    public static final LanguageEntry GUI_PART_BENCH_MIXED;
    public static final LanguageEntry GUI_PART_BENCH_ENGINE;
    public static final LanguageEntry GUI_PART_BENCH_WHEEL;
    public static final LanguageEntry GUI_PART_BENCH_COLOR;
    public static final LanguageEntry GUI_PANEL_TRIM_ROLL;
    public static final LanguageEntry GUI_PANEL_TRIM_PITCH;
    public static final LanguageEntry GUI_PANEL_TRIM_YAW;
    public static final LanguageEntry GUI_PANEL_REVERSE;
    public static final LanguageEntry GUI_PANEL_GEAR;
    public static final LanguageEntry GUI_PANEL_BEACON;
    public static final LanguageEntry GUI_PANEL_AUTOPILOT;
    public static final LanguageEntry GUI_INSTRUMENTS_MAIN;
    public static final LanguageEntry GUI_INSTRUMENTS_PANEL;
    public static final LanguageEntry GUI_INSTRUMENTS_CLEAR;
    public static final LanguageEntry GUI_INSTRUMENTS_IDLE;
    public static final LanguageEntry GUI_INSTRUMENTS_DECIDE;
    public static final LanguageEntry GUI_CONFIG_HEADER_RENDERING;
    public static final LanguageEntry GUI_CONFIG_HEADER_CONFIG;
    public static final LanguageEntry GUI_CONFIG_HEADER_CONTROLS;
    public static final LanguageEntry GUI_CONFIG_CONTROLS_TITLE;
    public static final LanguageEntry GUI_CONFIG_CONTROLS_VOLUME;
    public static final LanguageEntry GUI_CONFIG_CONTROLS_AIRCRAFT_KEYBOARD;
    public static final LanguageEntry GUI_CONFIG_CONTROLS_AIRCRAFT_JOYSTICK;
    public static final LanguageEntry GUI_CONFIG_CONTROLS_CAR_KEYBOARD;
    public static final LanguageEntry GUI_CONFIG_CONTROLS_CAR_JOYSTICK;
    public static final LanguageEntry GUI_CONFIG_JOYSTICK_ERROR;
    public static final LanguageEntry GUI_CONFIG_JOYSTICK_DISABLED;
    public static final LanguageEntry GUI_CONFIG_JOYSTICK_SELECT;
    public static final LanguageEntry GUI_CONFIG_JOYSTICK_NAME;
    public static final LanguageEntry GUI_CONFIG_JOYSTICK_MAPPING;
    public static final LanguageEntry GUI_CONFIG_JOYSTICK_DEADZONE;
    public static final LanguageEntry GUI_CONFIG_JOYSTICK_STATE;
    public static final LanguageEntry GUI_CONFIG_JOYSTICK_ASSIGNMENT;
    public static final LanguageEntry GUI_CONFIG_JOYSTICK_CANCEL;
    public static final LanguageEntry GUI_CONFIG_JOYSTICK_CLEAR;
    public static final LanguageEntry GUI_CONFIG_JOYSTICK_CHOOSEMAP;
    public static final LanguageEntry GUI_CONFIG_JOYSTICK_CALIBRATE1;
    public static final LanguageEntry GUI_CONFIG_JOYSTICK_CALIBRATE2;
    public static final LanguageEntry GUI_CONFIG_JOYSTICK_AXISMODE;
    public static final LanguageEntry GUI_CONFIG_JOYSTICK_NORMAL;
    public static final LanguageEntry GUI_CONFIG_JOYSTICK_INVERT;
    public static final LanguageEntry GUI_PACKMISSING_TITLE;
    public static final LanguageEntry GUI_PACKMISSING_TEXT;
    public static final LanguageEntry INTERACT_KEY_LOCK;
    public static final LanguageEntry INTERACT_KEY_UNLOCK;
    public static final LanguageEntry INTERACT_KEY_BIND;
    public static final LanguageEntry INTERACT_KEY_NOTOWNER;
    public static final LanguageEntry INTERACT_KEY_WRONGKEY;
    public static final LanguageEntry INTERACT_FUELPUMP_NOFUEL;
    public static final LanguageEntry INTERACT_FUELPUMP_FULLITEMS;
    public static final LanguageEntry INTERACT_FUELPUMP_TOOFAR;
    public static final LanguageEntry INTERACT_FUELPUMP_WRONGTYPE;
    public static final LanguageEntry INTERACT_FUELPUMP_NOENGINE;
    public static final LanguageEntry INTERACT_FUELPUMP_WRONGENGINES;
    public static final LanguageEntry INTERACT_FUELPUMP_CONNECT;
    public static final LanguageEntry INTERACT_FUELPUMP_COMPLETE;
    public static final LanguageEntry INTERACT_FUELPUMP_EMPTY;
    public static final LanguageEntry INTERACT_FUELPUMP_DISCONNECT;
    public static final LanguageEntry INTERACT_ROAD_SET;
    public static final LanguageEntry INTERACT_ROAD_ALREADYCONNECTED;
    public static final LanguageEntry INTERACT_ROAD_LANEMISMATCHFIRST;
    public static final LanguageEntry INTERACT_ROAD_LANEMISMATCHSECOND;
    public static final LanguageEntry INTERACT_ROAD_BLOCKED;
    public static final LanguageEntry INTERACT_ROAD_SAME;
    public static final LanguageEntry INTERACT_ROAD_TOOFAR;
    public static final LanguageEntry INTERACT_ROAD_BLOCKINGBLOCKS;
    public static final LanguageEntry INTERACT_JERRYCAN_EMPTY;
    public static final LanguageEntry INTERACT_JERRYCAN_WRONGTYPE;
    public static final LanguageEntry INTERACT_JERRYCAN_WRONGENGINES;
    public static final LanguageEntry INTERACT_JERRYCAN_NOENGINE;
    public static final LanguageEntry INTERACT_JERRYCAN_TOOFULL;
    public static final LanguageEntry INTERACT_JERRYCAN_SUCCESS;
    public static final LanguageEntry INTERACT_VEHICLE_SEATTAKEN;
    public static final LanguageEntry INTERACT_VEHICLE_LOCKED;
    public static final LanguageEntry INTERACT_VEHICLE_OWNED;
    public static final LanguageEntry INTERACT_VEHICLE_NEEDKEY;
    public static final LanguageEntry INTERACT_VEHICLE_NOSPACE;
    public static final LanguageEntry INTERACT_VEHICLE_CANTREMOVEINVENTORY;
    public static final LanguageEntry INTERACT_VEHICLE_JUMPERPACK;
    public static final LanguageEntry INTERACT_JUMPERCABLE_FIRSTLINK;
    public static final LanguageEntry INTERACT_JUMPERCABLE_SECONDLINK;
    public static final LanguageEntry INTERACT_JUMPERCABLE_LINKDROPPED;
    public static final LanguageEntry INTERACT_JUMPERCABLE_POWEREQUAL;
    public static final LanguageEntry INTERACT_JUMPERCABLE_ALREADYLINKED;
    public static final LanguageEntry INTERACT_JUMPERCABLE_TOOFAR;
    public static final LanguageEntry INTERACT_JUMPERCABLE_SAMEVEHICLE;
    public static final LanguageEntry INTERACT_FUELHOSE_FIRSTLINK;
    public static final LanguageEntry INTERACT_FUELHOSE_SECONDLINK;
    public static final LanguageEntry INTERACT_FUELHOSE_LINKDROPPED;
    public static final LanguageEntry INTERACT_FUELHOSE_TANKEMPTY;
    public static final LanguageEntry INTERACT_FUELHOSE_TANKFULL;
    public static final LanguageEntry INTERACT_FUELHOSE_ALREADYLINKED;
    public static final LanguageEntry INTERACT_FUELHOSE_TOOFAR;
    public static final LanguageEntry INTERACT_FUELHOSE_DIFFERENTFLUIDS;
    public static final LanguageEntry INTERACT_REPAIR_PASS;
    public static final LanguageEntry INTERACT_REPAIR_NONEED;
    public static final LanguageEntry INTERACT_REPAIR_TOTALED;
    public static final LanguageEntry INTERACT_REPAIR_TOOSOON;
    public static final LanguageEntry INTERACT_TRAILER_CONNECTED;
    public static final LanguageEntry INTERACT_TRAILER_DISCONNECTED;
    public static final LanguageEntry INTERACT_TRAILER_NOTFOUND;
    public static final LanguageEntry INTERACT_TRAILER_TOOFAR;
    public static final LanguageEntry INTERACT_TRAILER_WRONGHITCH;
    public static final LanguageEntry INTERACT_TRAILER_MISMATCH;
    public static final LanguageEntry INTERACT_TRAILER_ALREADYTOWED;
    public static final LanguageEntry INTERACT_TRAILER_FEEDBACKLOOP;
    public static final LanguageEntry ITEMINFO_SCANNER;
    public static final LanguageEntry ITEMINFO_WRENCH;
    public static final LanguageEntry ITEMINFO_SCREWDRIVER;
    public static final LanguageEntry ITEMINFO_PAINTGUN;
    public static final LanguageEntry ITEMINFO_KEY;
    public static final LanguageEntry ITEMINFO_TICKET;
    public static final LanguageEntry ITEMINFO_FUELHOSE;
    public static final LanguageEntry ITEMINFO_JUMPERCABLES;
    public static final LanguageEntry ITEMINFO_JUMPERPACK;
    public static final LanguageEntry ITEMINFO_REPAIRPACK;
    public static final LanguageEntry ITEMINFO_REPAIRPACK_UNTOTAL;
    public static final LanguageEntry ITEMINFO_Y2KBUTTON;
    public static final LanguageEntry ITEMINFO_ENGINE_AUTOMATIC;
    public static final LanguageEntry ITEMINFO_ENGINE_MANUAL;
    public static final LanguageEntry ITEMINFO_ENGINE_GEARRATIOS;
    public static final LanguageEntry ITEMINFO_ENGINE_JETPOWERFACTOR;
    public static final LanguageEntry ITEMINFO_ENGINE_BYPASSRATIO;
    public static final LanguageEntry ITEMINFO_ENGINE_MAXRPM;
    public static final LanguageEntry ITEMINFO_ENGINE_MAXSAFERPM;
    public static final LanguageEntry ITEMINFO_ENGINE_FUELCONSUMPTION;
    public static final LanguageEntry ITEMINFO_ENGINE_SUPERCHARGERFUELCONSUMPTION;
    public static final LanguageEntry ITEMINFO_ENGINE_SUPERCHARGEREFFICIENCY;
    public static final LanguageEntry ITEMINFO_ENGINE_FUELTYPE;
    public static final LanguageEntry ITEMINFO_ENGINE_FLUIDS;
    public static final LanguageEntry ITEMINFO_ENGINE_MAGIC;
    public static final LanguageEntry ITEMINFO_ENGINE_HOURS;
    public static final LanguageEntry ITEMINFO_GROUND_DEVICE_DIAMETER;
    public static final LanguageEntry ITEMINFO_GROUND_DEVICE_MOTIVEFRICTION;
    public static final LanguageEntry ITEMINFO_GROUND_DEVICE_LATERALFRICTION;
    public static final LanguageEntry ITEMINFO_GROUND_DEVICE_WETFRICTION;
    public static final LanguageEntry ITEMINFO_GROUND_DEVICE_FRICTIONMODIFIERS;
    public static final LanguageEntry ITEMINFO_GROUND_DEVICE_ROTATESONSHAFT_TRUE;
    public static final LanguageEntry ITEMINFO_GROUND_DEVICE_ROTATESONSHAFT_FALSE;
    public static final LanguageEntry ITEMINFO_GROUND_DEVICE_CANFLOAT_TRUE;
    public static final LanguageEntry ITEMINFO_GROUND_DEVICE_CANFLOAT_FALSE;
    public static final LanguageEntry ITEMINFO_PROPELLER_STATICPITCH;
    public static final LanguageEntry ITEMINFO_PROPELLER_DYNAMICPITCH;
    public static final LanguageEntry ITEMINFO_PROPELLER_PITCH;
    public static final LanguageEntry ITEMINFO_PROPELLER_DIAMETER;
    public static final LanguageEntry ITEMINFO_GUN_DIAMETER;
    public static final LanguageEntry ITEMINFO_GUN_CASERANGE;
    public static final LanguageEntry ITEMINFO_GUN_FIREDELAY;
    public static final LanguageEntry ITEMINFO_GUN_MUZZLEVELOCITY;
    public static final LanguageEntry ITEMINFO_GUN_CAPACITY;
    public static final LanguageEntry ITEMINFO_GUN_AUTORELOAD;
    public static final LanguageEntry ITEMINFO_GUN_YAWRANGE;
    public static final LanguageEntry ITEMINFO_GUN_PITCHRANGE;
    public static final LanguageEntry ITEMINFO_BULLET_TYPE_EXPLOSIVE;
    public static final LanguageEntry ITEMINFO_BULLET_TYPE_INCENDIARY;
    public static final LanguageEntry ITEMINFO_BULLET_TYPE_ARMOR_PIERCING;
    public static final LanguageEntry ITEMINFO_BULLET_TYPE_WATER;
    public static final LanguageEntry ITEMINFO_BULLET_PELLETS;
    public static final LanguageEntry ITEMINFO_BULLET_DIAMETER;
    public static final LanguageEntry ITEMINFO_BULLET_CASELENGTH;
    public static final LanguageEntry ITEMINFO_BULLET_PENETRATION;
    public static final LanguageEntry ITEMINFO_BULLET_QUANTITY;
    public static final LanguageEntry ITEMINFO_INTERACTABLE_CAPACITY;
    public static final LanguageEntry ITEMINFO_JERRYCAN_FILL;
    public static final LanguageEntry ITEMINFO_JERRYCAN_DRAIN;
    public static final LanguageEntry ITEMINFO_JERRYCAN_EMPTY;
    public static final LanguageEntry ITEMINFO_JERRYCAN_CONTAINS;
    public static final LanguageEntry INPUT_MOD;
    public static final LanguageEntry INPUT_CAMLOCK;
    public static final LanguageEntry INPUT_YAW;
    public static final LanguageEntry INPUT_YAW_R;
    public static final LanguageEntry INPUT_YAW_L;
    public static final LanguageEntry INPUT_PITCH;
    public static final LanguageEntry INPUT_PITCH_U;
    public static final LanguageEntry INPUT_PITCH_D;
    public static final LanguageEntry INPUT_ROLL;
    public static final LanguageEntry INPUT_ROLL_R;
    public static final LanguageEntry INPUT_ROLL_L;
    public static final LanguageEntry INPUT_THROTTLE;
    public static final LanguageEntry INPUT_THROTTLE_U;
    public static final LanguageEntry INPUT_THROTTLE_D;
    public static final LanguageEntry INPUT_FLAPS_U;
    public static final LanguageEntry INPUT_FLAPS_D;
    public static final LanguageEntry INPUT_BRAKE;
    public static final LanguageEntry INPUT_GEAR;
    public static final LanguageEntry INPUT_PANEL;
    public static final LanguageEntry INPUT_PARK;
    public static final LanguageEntry INPUT_GUN_FIRE;
    public static final LanguageEntry INPUT_GUN_SWITCH;
    public static final LanguageEntry INPUT_RADIO;
    public static final LanguageEntry INPUT_ZOOM_I;
    public static final LanguageEntry INPUT_ZOOM_O;
    public static final LanguageEntry INPUT_CHANGEVIEW;
    public static final LanguageEntry INPUT_LOOK_L;
    public static final LanguageEntry INPUT_LOOK_R;
    public static final LanguageEntry INPUT_LOOK_U;
    public static final LanguageEntry INPUT_LOOK_D;
    public static final LanguageEntry INPUT_LOOK_A;
    public static final LanguageEntry INPUT_TRIM_YAW_R;
    public static final LanguageEntry INPUT_TRIM_YAW_L;
    public static final LanguageEntry INPUT_TRIM_PITCH_U;
    public static final LanguageEntry INPUT_TRIM_PITCH_D;
    public static final LanguageEntry INPUT_TRIM_ROLL_R;
    public static final LanguageEntry INPUT_TRIM_ROLL_L;
    public static final LanguageEntry INPUT_REVERSE;
    public static final LanguageEntry INPUT_JS_INHIBIT;
    public static final LanguageEntry INPUT_TURN;
    public static final LanguageEntry INPUT_TURN_R;
    public static final LanguageEntry INPUT_TURN_L;
    public static final LanguageEntry INPUT_GAS;
    public static final LanguageEntry INPUT_SHIFT_U;
    public static final LanguageEntry INPUT_SHIFT_D;
    public static final LanguageEntry INPUT_SHIFT_N;
    public static final LanguageEntry INPUT_SHIFT_1;
    public static final LanguageEntry INPUT_SHIFT_2;
    public static final LanguageEntry INPUT_SHIFT_3;
    public static final LanguageEntry INPUT_SHIFT_4;
    public static final LanguageEntry INPUT_SHIFT_5;
    public static final LanguageEntry INPUT_SHIFT_6;
    public static final LanguageEntry INPUT_SHIFT_7;
    public static final LanguageEntry INPUT_SHIFT_8;
    public static final LanguageEntry INPUT_SHIFT_9;
    public static final LanguageEntry INPUT_SHIFT_R;
    public static final LanguageEntry INPUT_HORN;
    public static final LanguageEntry INPUT_SLOW;
    public static final LanguageEntry INPUT_LIGHTS;
    public static final LanguageEntry INPUT_TURNSIGNAL_R;
    public static final LanguageEntry INPUT_TURNSIGNAL_L;
    public static final LanguageEntry SYSTEM_SOUNDSLOT;
    public static final LanguageEntry SYSTEM_DEBUG;

    public static void init() {
        for (String packID : PackParser.getAllPackIDs()) {
            Map packMap = packLanguageEntries.computeIfAbsent(packID, k -> new LinkedHashMap());
            for (AItemPack<?> packItem : PackParser.getAllItemsForPack(packID, true)) {
                String itemID = packItem.getRegistrationName();
                String itemName = null;
                if (packItem instanceof AItemSubTyped) {
                    AItemSubTyped subDefItem = (AItemSubTyped)packItem;
                    itemName = subDefItem.subDefinition.name;
                    subDefItem.languageSubDescription = new LanguageEntry(subDefItem.subDefinition.description != null ? subDefItem.subDefinition.description : "");
                    packMap.put(itemID + ".subDescription", subDefItem.languageSubDescription);
                    String masterItemID = itemID.substring(0, itemID.length() - subDefItem.subDefinition.subName.length()) + ".description";
                    LanguageEntry masterDescription = (LanguageEntry)packMap.get(masterItemID);
                    if (masterDescription == null) {
                        masterDescription = new LanguageEntry(((AJSONItem)packItem.definition).general.description != null ? ((AJSONItem)packItem.definition).general.description : "");
                        packMap.put(masterItemID, masterDescription);
                    }
                    packItem.languageDescription = masterDescription;
                } else {
                    packItem.languageDescription = new LanguageEntry(((AJSONItem)packItem.definition).general.description != null ? ((AJSONItem)packItem.definition).general.description : "");
                    packMap.put(itemID + ".description", packItem.languageDescription);
                }
                if (itemName == null) {
                    itemName = ((AJSONItem)packItem.definition).general.name != null ? ((AJSONItem)packItem.definition).general.name : ((AJSONItem)packItem.definition).systemName;
                }
                packItem.languageName = new LanguageEntry(itemName);
                packMap.put(itemID + ".name", packItem.languageName);
                if (!(packItem instanceof ItemItem)) continue;
                ItemItem packItemItem = (ItemItem)packItem;
                if (((JSONItem)packItemItem.definition).booklet == null) continue;
                itemID = itemID + ".booklet";
                if (((JSONItem)packItemItem.definition).booklet.titleText != null) {
                    packItemItem.languageTitle = new ArrayList<LanguageEntry>();
                    for (int i = 0; i < ((JSONItem)packItemItem.definition).booklet.titleText.size(); ++i) {
                        LanguageEntry language = new LanguageEntry(((JSONItem)packItemItem.definition).booklet.titleText.get((int)i).defaultText);
                        packItemItem.languageTitle.add(language);
                        packMap.put(itemID + ".title.textline" + (i + 1), language);
                    }
                }
                packItemItem.languagePageTitle = new ArrayList<LanguageEntry>();
                packItemItem.languagePageText = new ArrayList<List<LanguageEntry>>();
                for (int i = 0; i < ((JSONItem)packItemItem.definition).booklet.pages.size(); ++i) {
                    JSONItem.JSONBooklet.BookletPage page = ((JSONItem)packItemItem.definition).booklet.pages.get(i);
                    if (page.title != null) {
                        LanguageEntry language = new LanguageEntry(page.title);
                        packItemItem.languagePageTitle.add(language);
                        packMap.put(itemID + ".page" + (i + 1) + ".title", language);
                    } else {
                        packItemItem.languagePageTitle.add(null);
                    }
                    if (page.pageText != null) {
                        ArrayList<LanguageEntry> languageList = new ArrayList<LanguageEntry>();
                        for (int j = 0; j < page.pageText.size(); ++j) {
                            LanguageEntry language = new LanguageEntry(page.pageText.get((int)j).defaultText);
                            languageList.add(language);
                            packMap.put(itemID + ".page" + (i + 1) + ".textline" + (j + i), language);
                        }
                        packItemItem.languagePageText.add(languageList);
                        continue;
                    }
                    packItemItem.languagePageText.add(null);
                }
            }
        }
    }

    public static void populateNames() {
        for (String string : PackParser.getAllPackIDs()) {
            Map<String, LanguageEntry> packMap = packLanguageEntries.get(string);
            for (String language : InterfaceManager.clientInterface.getAllLanguages()) {
                String filePath = "/assets/" + string + "/language/" + language;
                InputStream languageStream = InterfaceManager.coreInterface.getPackResource(filePath);
                if (languageStream == null) continue;
                try {
                    JSONLanguageFile languageFile = JSONParser.parseStream(languageStream, JSONLanguageFile.class, null, null);
                    languageFile.entries.forEach((key, value) -> {
                        LanguageEntry languageEntry = (LanguageEntry)packMap.get(key);
                        if (languageEntry != null) {
                            languageEntry.values.put(language, (String)value);
                        }
                        if ((languageEntry = coreLanguageEntires.get(key)) != null) {
                            languageEntry.values.put(language, (String)value);
                        }
                    });
                }
                catch (IOException e) {
                    InterfaceManager.coreInterface.logError("Could not load language file: " + filePath + "  Language for this language/pack will be disabled.  Report this to the pack author!");
                }
            }
        }
        if (dumpToFolder != null) {
            try {
                for (Map.Entry entry : packLanguageEntries.entrySet()) {
                    String packID = (String)entry.getKey();
                    JSONLanguageFile jsonFileToWrite = new JSONLanguageFile();
                    jsonFileToWrite.entries = new LinkedHashMap<String, String>();
                    ((Map)entry.getValue()).forEach((key, languageEntry) -> jsonFileToWrite.entries.put((String)key, languageEntry.getDefaultValue()));
                    if (packID.equals(InterfaceManager.coreModID)) {
                        coreLanguageEntires.forEach((key, languageEntry) -> jsonFileToWrite.entries.put((String)key, languageEntry.getDefaultValue()));
                    }
                    dumpToFolder.mkdir();
                    File packFolder = new File(dumpToFolder, packID);
                    packFolder.mkdir();
                    JSONParser.exportStream(jsonFileToWrite, Files.newOutputStream(new File(packFolder, InterfaceManager.clientInterface.getLanguageName()).toPath(), new OpenOption[0]));
                }
            }
            catch (Exception e) {
                InterfaceManager.coreInterface.logError("ConfigSystem failed to create template language files.  Report to the mod author!  Or, are you trying to do language stuff on servers?  Cause that's a bad idea...");
            }
        }
    }

    public static void dumpToFolder(File folder) {
        dumpToFolder = folder;
    }

    static {
        DEATH_BULLET_NULL = new LanguageEntry("death.bullet.null", "%s was shot by a spy");
        DEATH_BULLET_PLAYER = new LanguageEntry("death.bullet.player", "%s was shot by %s");
        DEATH_PROPELLER_NULL = new LanguageEntry("death.propeller.null", "%s was shredded by a propeller");
        DEATH_PROPELLER_PLAYER = new LanguageEntry("death.propeller.player", "%s was shredded by %s's propeller");
        DEATH_JETINTAKE_NULL = new LanguageEntry("death.jet_intake.null", "%s was sucked into a jet engine");
        DEATH_JETINTAKE_PLAYER = new LanguageEntry("death.jet_intake.player", "%s was sucked into %s's jet engine");
        DEATH_JETEXHAUST_NULL = new LanguageEntry("death.jet_exhaust.null", "%s was burnt to a crisp by a jet engine");
        DEATH_JETEXHAUST_PLAYER = new LanguageEntry("death.jet_exhaust.player", "%s was burnt to a crisp by %s's jet engine");
        DEATH_WHEEL_NULL = new LanguageEntry("death.wheel.null", "%s was run over");
        DEATH_WHEEL_PLAYER = new LanguageEntry("death.wheel.player", "%s was run over by %s");
        DEATH_CRASH_NULL = new LanguageEntry("death.crash.null", "%s died in a crash");
        DEATH_CRASH_PLAYER = new LanguageEntry("death.crash.player", "%s crashed their vehicle and killed %s");
        GUI_CONFIRM = new LanguageEntry("gui.confirm", "CONFIRM");
        GUI_MASTERCONFIG = new LanguageEntry("gui.masterconfig", "Open configuration screen");
        GUI_IMPORT = new LanguageEntry("gui.import", "Import Packs (Developers Only)");
        GUI_SIGNALCONTROLLER_SCAN = new LanguageEntry("gui.signalcontroller.scan", "Scan For Signals & Components");
        GUI_SIGNALCONTROLLER_SCANDISTANCE = new LanguageEntry("gui.signalcontroller.scandistance", "Radius: ");
        GUI_SIGNALCONTROLLER_SCANCENTER = new LanguageEntry("gui.signalcontroller.scancenter", "Center (X/Z): ");
        GUI_SIGNALCONTROLLER_SCANFOUND = new LanguageEntry("gui.signalcontroller.scanfound", "Found: ");
        GUI_SIGNALCONTROLLER_RIGHTHANDDRIVE = new LanguageEntry("gui.signalcontroller.righthanddrive", "Right-Hand Drive");
        GUI_SIGNALCONTROLLER_LEFTHANDDRIVE = new LanguageEntry("gui.signalcontroller.lefthanddrive", "Left-Hand Drive");
        GUI_SIGNALCONTROLLER_TIMEMODE = new LanguageEntry("gui.signalcontroller.timemode", "Time Delay");
        GUI_SIGNALCONTROLLER_TRIGGERMODE = new LanguageEntry("gui.signalcontroller.triggermode", "Vehicle Trigger");
        GUI_SIGNALCONTROLLER_PRIMARYAXIS = new LanguageEntry("gui.signalcontroller.primaryaxis", "Main Axis: ");
        GUI_SIGNALCONTROLLER_LANEWIDTH = new LanguageEntry("gui.signalcontroller.lanewidth", "Lane Width: ");
        GUI_SIGNALCONTROLLER_GREENMAINTIME = new LanguageEntry("gui.signalcontroller.greenmaintime", "Green Time (Main): ");
        GUI_SIGNALCONTROLLER_GREENCROSSTIME = new LanguageEntry("gui.signalcontroller.greencrosstime", "Green Time (Cross): ");
        GUI_SIGNALCONTROLLER_YELLOWMAINTIME = new LanguageEntry("gui.signalcontroller.yellowmaintime", "Yellow Time (Main): ");
        GUI_SIGNALCONTROLLER_YELLOWCROSSTIME = new LanguageEntry("gui.signalcontroller.yellowcrosstime", "Yellow Time (Cross): ");
        GUI_SIGNALCONTROLLER_ALLREDTIME = new LanguageEntry("gui.signalcontroller.allredtime", "All Red Time: ");
        GUI_SIGNALCONTROLLER_LANESETTINGS = new LanguageEntry("gui.signalcontroller.lanesettings", "LANE SETTINGS");
        GUI_SIGNALCONTROLLER_SIGNALSETTINGS = new LanguageEntry("gui.signalcontroller.lanesettings", "SIGNAL SETTINGS");
        GUI_SIGNALCONTROLLER_LEFTLANES = new LanguageEntry("gui.signalcontroller.leftlanes", "# Left Lanes: ");
        GUI_SIGNALCONTROLLER_CENTERLANES = new LanguageEntry("gui.signalcontroller.centerlanes", "# Center Lanes: ");
        GUI_SIGNALCONTROLLER_RIGHTLANES = new LanguageEntry("gui.signalcontroller.rightlanes", "# Right Lanes: ");
        GUI_SIGNALCONTROLLER_ROADWIDTH = new LanguageEntry("gui.signalcontroller.roadwidth", "Road Width: ");
        GUI_SIGNALCONTROLLER_CENTERDIST = new LanguageEntry("gui.signalcontroller.centerdist", "Dist Center->Road: ");
        GUI_SIGNALCONTROLLER_MEDIANDIST = new LanguageEntry("gui.signalcontroller.mediandist", "Dist Road->Median: ");
        GUI_PART_BENCH_WEIGHT = new LanguageEntry("gui.part_bench.weight", "Weight (kg): ");
        GUI_PART_BENCH_FUEL = new LanguageEntry("gui.part_bench.fuel", "Fuel Cap. (mb): ");
        GUI_PART_BENCH_CONTROLLERS = new LanguageEntry("gui.part_bench.controllers", "Drivers/Pilots: ");
        GUI_PART_BENCH_PASSENGERS = new LanguageEntry("gui.part_bench.passengers", "Passengers: ");
        GUI_PART_BENCH_CARGO = new LanguageEntry("gui.part_bench.cargo", "Cargo: ");
        GUI_PART_BENCH_MIXED = new LanguageEntry("gui.part_bench.mixed", "Mixed: ");
        GUI_PART_BENCH_ENGINE = new LanguageEntry("gui.part_bench.engine", "Engine Size: ");
        GUI_PART_BENCH_WHEEL = new LanguageEntry("gui.part_bench.wheel", "Wheel Size: ");
        GUI_PART_BENCH_COLOR = new LanguageEntry("gui.part_bench.color", "Color: ");
        GUI_PANEL_TRIM_ROLL = new LanguageEntry("gui.panel.trim_roll", "ROLL TRIM");
        GUI_PANEL_TRIM_PITCH = new LanguageEntry("gui.panel.trim_pitch", "PITCH TRIM");
        GUI_PANEL_TRIM_YAW = new LanguageEntry("gui.panel.trim_yaw", "YAW TRIM");
        GUI_PANEL_REVERSE = new LanguageEntry("gui.panel.reverse", "REV");
        GUI_PANEL_GEAR = new LanguageEntry("gui.panel.gear", "GEAR");
        GUI_PANEL_BEACON = new LanguageEntry("gui.panel.beacon", "BEACON");
        GUI_PANEL_AUTOPILOT = new LanguageEntry("gui.panel.autopilot", "AUTO");
        GUI_INSTRUMENTS_MAIN = new LanguageEntry("gui.instruments.main", "Main Instruments");
        GUI_INSTRUMENTS_PANEL = new LanguageEntry("gui.instruments.panel", "Control Panel");
        GUI_INSTRUMENTS_CLEAR = new LanguageEntry("gui.instruments.clear", "CLEAR");
        GUI_INSTRUMENTS_IDLE = new LanguageEntry("gui.instruments.idle", "Select an instrument.");
        GUI_INSTRUMENTS_DECIDE = new LanguageEntry("gui.instruments.decide", "Click an instrument to add.");
        GUI_CONFIG_HEADER_RENDERING = new LanguageEntry("gui.config.header.rendering", "RENDERING");
        GUI_CONFIG_HEADER_CONFIG = new LanguageEntry("gui.config.header.config", "CONFIG");
        GUI_CONFIG_HEADER_CONTROLS = new LanguageEntry("gui.config.header.controls", "CONTROLS");
        GUI_CONFIG_CONTROLS_TITLE = new LanguageEntry("gui.config.controls.title", "Choose a configuration to change: ");
        GUI_CONFIG_CONTROLS_VOLUME = new LanguageEntry("gui.config.controls.volume", "Volume: ");
        GUI_CONFIG_CONTROLS_AIRCRAFT_KEYBOARD = new LanguageEntry("gui.config.controls.aircraft.keyboard", "AIRCRAFT KEYBOARD");
        GUI_CONFIG_CONTROLS_AIRCRAFT_JOYSTICK = new LanguageEntry("gui.config.controls.aircraft.joystick", "AIRCRAFT JOYSTICK");
        GUI_CONFIG_CONTROLS_CAR_KEYBOARD = new LanguageEntry("gui.config.controls.car.keyboard", "CAR/BOAT KEYBOARD");
        GUI_CONFIG_CONTROLS_CAR_JOYSTICK = new LanguageEntry("gui.config.controls.car.joystick", "CAR/BOAT JOYSTICK");
        GUI_CONFIG_JOYSTICK_ERROR = new LanguageEntry("gui.config.joystick.error", "ERROR: MTS could not initialize the control system!  This is likely due to a device mis-representing itself as a joystick to Java.  Mice have been known to have this issue, especially Corsair mice, so try a different mouse.  You may also try un-plugging your mouse, and then opening this GUI to re-poll the joysticks.  This won't make controls work on boot, but can be used if you only have one mouse.");
        GUI_CONFIG_JOYSTICK_DISABLED = new LanguageEntry("gui.config.joystick.disabled", "ERROR: The control system locked up when MTS tried to initialize it.  This is likely a driver issue, and happens for some reason on some machines.  The root cause is not known, but if you find out how to make this erorr go away, let us know!  For now, joysick support will be disabled.");
        GUI_CONFIG_JOYSTICK_SELECT = new LanguageEntry("gui.config.joystick.select", "Choose a joystick: ");
        GUI_CONFIG_JOYSTICK_NAME = new LanguageEntry("gui.config.joystick.name", "Name: ");
        GUI_CONFIG_JOYSTICK_MAPPING = new LanguageEntry("gui.config.joystick.mapping", "Mapping");
        GUI_CONFIG_JOYSTICK_DEADZONE = new LanguageEntry("gui.config.joystick.deadzone", "Dead-zone: ");
        GUI_CONFIG_JOYSTICK_STATE = new LanguageEntry("gui.config.joystick.state", "State: ");
        GUI_CONFIG_JOYSTICK_ASSIGNMENT = new LanguageEntry("gui.config.joystick.assignment", "Assigned to: ");
        GUI_CONFIG_JOYSTICK_CANCEL = new LanguageEntry("gui.config.joystick.cancel", "Cancel");
        GUI_CONFIG_JOYSTICK_CLEAR = new LanguageEntry("gui.config.joystick.clear", "Clear Assignment");
        GUI_CONFIG_JOYSTICK_CHOOSEMAP = new LanguageEntry("gui.config.joystick.choosemap", "Choose what gets mapped to this button.");
        GUI_CONFIG_JOYSTICK_CALIBRATE1 = new LanguageEntry("gui.config.joystick.calibrate1", "Move axis until numbers stop changing.");
        GUI_CONFIG_JOYSTICK_CALIBRATE2 = new LanguageEntry("gui.config.joystick.calibrate2", "Then hit confirm to save settings.");
        GUI_CONFIG_JOYSTICK_AXISMODE = new LanguageEntry("gui.config.joystick.axismode", "Axis mode: ");
        GUI_CONFIG_JOYSTICK_NORMAL = new LanguageEntry("gui.config.joystick.normal", "Normal");
        GUI_CONFIG_JOYSTICK_INVERT = new LanguageEntry("gui.config.joystick.invert", "Inverted");
        GUI_PACKMISSING_TITLE = new LanguageEntry("gui.packmissing.title", "!ERROR!");
        GUI_PACKMISSING_TEXT = new LanguageEntry("gui.packmissing.text", "MTS has detected that it has been started without a content pack.  This will result in NO vehicles being present!  If you do NOT have a content pack yet installed, please see the Curse page for this mod for a link to one.  If you DID download a pack ensure that it is the same place as all your other mods.  If the pack is in that location, and you are still seeing this message, ensure you are running the correct pack version.");
        INTERACT_KEY_LOCK = new LanguageEntry("interact.key.lock", "Vehicle locked!");
        INTERACT_KEY_UNLOCK = new LanguageEntry("interact.key.unlock", "Vehicle unlocked!");
        INTERACT_KEY_BIND = new LanguageEntry("interact.key.bind", "Key bound to vehicle.  Ready for locking/unlocking use.");
        INTERACT_KEY_NOTOWNER = new LanguageEntry("interact.key.notowner", "This key is not for any vehicle, and only the owner of this vehicle may make new keys!");
        INTERACT_KEY_WRONGKEY = new LanguageEntry("interact.key.wrongkey", "This key does not go to this vehicle!");
        INTERACT_FUELPUMP_NOFUEL = new LanguageEntry("interact.fuelpump.nofuel", "The pump is empty.  Either insert fuel into the pump via buckets, or connect it to a fluid or electrical system from the bottom.");
        INTERACT_FUELPUMP_FULLITEMS = new LanguageEntry("interact.fuelpump.fullitems", "This pump is set up to require payment for fuel, but it cannot accept more items.  Contact the owner to empty it!");
        INTERACT_FUELPUMP_TOOFAR = new LanguageEntry("interact.fuelpump.toofar", "The pump is too far away from the vehicle.  The pump should be no more than 16 blocks away.");
        INTERACT_FUELPUMP_WRONGTYPE = new LanguageEntry("interact.fuelpump.wrongtype", "This pump does not contain the same fluid as what is in the vehicle.  %s is in the vehicle.");
        INTERACT_FUELPUMP_NOENGINE = new LanguageEntry("interact.fuelpump.noengine", "There is no engine in this vehicle.  Engines with different fuel types will reset fuel, so put an engine in first to avoid fuel loss!");
        INTERACT_FUELPUMP_WRONGENGINES = new LanguageEntry("interact.fuelpump.wrongengines", "The contents in this pump is not a valid fuel for the engines in the vehicle.  Check the manual for details.");
        INTERACT_FUELPUMP_CONNECT = new LanguageEntry("interact.fuelpump.connect", "Connected and fueling.");
        INTERACT_FUELPUMP_COMPLETE = new LanguageEntry("interact.fuelpump.complete", "Vehicle is full, disconnecting.");
        INTERACT_FUELPUMP_EMPTY = new LanguageEntry("interact.fuelpump.empty", "Pump is empty, disconnecting.");
        INTERACT_FUELPUMP_DISCONNECT = new LanguageEntry("interact.fuelpump.disconnect", "Disconnecting and stopping pumping.");
        INTERACT_ROAD_SET = new LanguageEntry("interact.road.set", "Setting first dynamic road point.");
        INTERACT_ROAD_ALREADYCONNECTED = new LanguageEntry("interact.road.alreadyconnected", "This road segment is already connected to another road.");
        INTERACT_ROAD_LANEMISMATCHFIRST = new LanguageEntry("interact.road.lanemismatchfirst", "The number of lanes at the road segment clicked first does not match the number of lanes for this road.");
        INTERACT_ROAD_LANEMISMATCHSECOND = new LanguageEntry("interact.road.lanemismatchsecond", "The number of lanes at the road segment just clicked does not match the number of lanes for this road.");
        INTERACT_ROAD_BLOCKED = new LanguageEntry("interact.road.blocked", "No space found to place the master block for this road.  Try a less crowded area?");
        INTERACT_ROAD_SAME = new LanguageEntry("interact.road.same", "Both the first point and the second point clicked are the same block.  Reset and try again.");
        INTERACT_ROAD_TOOFAR = new LanguageEntry("interact.road.toofar", "The two points clicked are too far apart.  Either find closer points, or increase the distance in the config file.");
        INTERACT_ROAD_BLOCKINGBLOCKS = new LanguageEntry("interact.road.blockingblocks", "There are blocks blocking the placement of this road.  Break the highlighted red ones, and then click the blue master road block to continue.");
        INTERACT_JERRYCAN_EMPTY = new LanguageEntry("interact.jerrycan.empty", "This jerrycan is empty and cannot fuel this vehicle.");
        INTERACT_JERRYCAN_WRONGTYPE = new LanguageEntry("interact.jerrycan.wrongtype", "This jerrycan does not contain the same liquid as what is in the vehicle.");
        INTERACT_JERRYCAN_WRONGENGINES = new LanguageEntry("interact.jerrycan.wrongengines", "The contents in this jerrycan is not a valid fuel for the engines in the vehicle.  Check the manual for details.");
        INTERACT_JERRYCAN_NOENGINE = new LanguageEntry("interact.jerrycan.noengine", "There is no engine in this vehicle.  Removing engines from vehicles resets their fuel tank, so fueling this vehicle would do nothing!");
        INTERACT_JERRYCAN_TOOFULL = new LanguageEntry("interact.jerrycan.toofull", "This vehicle is already full of fuel.  You cannot add any more.");
        INTERACT_JERRYCAN_SUCCESS = new LanguageEntry("interact.jerrycan.success", "Added 1000mb of fluid to this vehicle.");
        INTERACT_VEHICLE_SEATTAKEN = new LanguageEntry("interact.vehicle.seattaken", "This seat is taken!");
        INTERACT_VEHICLE_LOCKED = new LanguageEntry("interact.vehicle.locked", "This vehicle is locked!");
        INTERACT_VEHICLE_OWNED = new LanguageEntry("interact.vehicle.owned", "You are not the owner of this vehicle and therefore cannot change it or its parts!");
        INTERACT_VEHICLE_NEEDKEY = new LanguageEntry("interact.vehicle.needkey", "You must have the key of this vehicle to start it!");
        INTERACT_VEHICLE_NOSPACE = new LanguageEntry("interact.vehicle.nospace", "There is not enough space to place down this vehicle here.");
        INTERACT_VEHICLE_CANTREMOVEINVENTORY = new LanguageEntry("interact.vehicle.cantremoveinventory", "You cannot remove this part because it is not empty!");
        INTERACT_VEHICLE_JUMPERPACK = new LanguageEntry("interact.vehicle.jumperpack", "Charged vehicle battery to maximum.");
        INTERACT_JUMPERCABLE_FIRSTLINK = new LanguageEntry("interact.jumpercable.firstlink", "Linking first engine to jumper cable.");
        INTERACT_JUMPERCABLE_SECONDLINK = new LanguageEntry("interact.jumpercable.secondlink", "Engines linked.  Transmitting power.");
        INTERACT_JUMPERCABLE_LINKDROPPED = new LanguageEntry("interact.jumpercable.linkdropped", "The two engines have moved too far apart from one another.  Breaking link.");
        INTERACT_JUMPERCABLE_POWEREQUAL = new LanguageEntry("interact.jumpercable.powerequal", "The two engines now have the same battery level.  Breaking link.");
        INTERACT_JUMPERCABLE_ALREADYLINKED = new LanguageEntry("interact.jumpercable.alreadylinked", "This engine is already linked to another engine and cannot be linked.");
        INTERACT_JUMPERCABLE_TOOFAR = new LanguageEntry("interact.jumpercable.toofar", "The two engines are too far away.  They should be no further than 16 blocks apart.");
        INTERACT_JUMPERCABLE_SAMEVEHICLE = new LanguageEntry("interact.jumpercable.samevehicle", "The two engines are on the same vehicle.  That's not going to work well..");
        INTERACT_FUELHOSE_FIRSTLINK = new LanguageEntry("interact.fuelhose.firstlink", "Source tank linked to fuel hose.");
        INTERACT_FUELHOSE_SECONDLINK = new LanguageEntry("interact.fuelhose.secondlink", "Linked to tank/vehicle.  Transfering fluid.");
        INTERACT_FUELHOSE_LINKDROPPED = new LanguageEntry("interact.fuelhose.linkdropped", "The linked tanks have moved too far apart from one another.  Breaking link.");
        INTERACT_FUELHOSE_TANKEMPTY = new LanguageEntry("interact.fuelhose.tankempty", "Source tank is empty, disconnecting.");
        INTERACT_FUELHOSE_TANKFULL = new LanguageEntry("interact.fuelhose.tankfull", "Destination tank is full, disconnecting.");
        INTERACT_FUELHOSE_ALREADYLINKED = new LanguageEntry("interact.fuelhose.alreadylinked", "This tank is already linked to another tank and cannot be linked.");
        INTERACT_FUELHOSE_TOOFAR = new LanguageEntry("interact.fuelhose.toofar", "The two tanks are too far away.  They should be no further than 16 blocks apart.");
        INTERACT_FUELHOSE_DIFFERENTFLUIDS = new LanguageEntry("interact.fuelhose.differentfluids", "The source and destination tanks do not contain the same fluid and cannot be linked.");
        INTERACT_REPAIR_PASS = new LanguageEntry("interact.repair.pass", "Repaired vehicle HP by %s.  HP is now at %s of %s.");
        INTERACT_REPAIR_NONEED = new LanguageEntry("interact.repair.noneed", "This vehicle is already at full health and doesn't need to be repaired.");
        INTERACT_REPAIR_TOTALED = new LanguageEntry("interact.repair.fail", "This vehicle is totaled and cannot be repaired with this repair pack.  Only special repair packs can repair totaled vehicles.");
        INTERACT_REPAIR_TOOSOON = new LanguageEntry("interact.repair.toosoon", "You cannot repair this vehicle now.  Wait 10 seconds between repairs.");
        INTERACT_TRAILER_CONNECTED = new LanguageEntry("interact.trailer.connected", "Trailer connected.");
        INTERACT_TRAILER_DISCONNECTED = new LanguageEntry("interact.trailer.disconnected", "Trailer disconnected.");
        INTERACT_TRAILER_NOTFOUND = new LanguageEntry("interact.trailer.notfound", "No trailers were found anywhere near this vehicle.");
        INTERACT_TRAILER_TOOFAR = new LanguageEntry("interact.trailer.toofar", "The trailer is too far from the vehicle.");
        INTERACT_TRAILER_WRONGHITCH = new LanguageEntry("interact.trailer.wronghitch", "This vehicle does not have the correct hitch for this trailer.");
        INTERACT_TRAILER_MISMATCH = new LanguageEntry("interact.trailer.mismatch", "A hitch was found that is close enough to connect, but was not the correct type.  Also, a matching hitch was found, but it was too far to connect.  Are you trying to use the wrong hitch?");
        INTERACT_TRAILER_ALREADYTOWED = new LanguageEntry("interact.trailer.alreadytowed", "The only nearby vehicle is already being towed.");
        INTERACT_TRAILER_FEEDBACKLOOP = new LanguageEntry("interact.trailer.feedbackloop", "The only nearby vehicles are being towed by this vehicle, towing would result in an infinite towing loop.");
        ITEMINFO_SCANNER = new LanguageEntry("iteminfo.scanner", "Hover over a part box to see what can be placed at that slot.\nSneak while using to cycle slower.");
        ITEMINFO_WRENCH = new LanguageEntry("iteminfo.wrench", "Attack a vehicle part to remove it.\nSneak-attack a vehicle to remove entire vehicle.\nUse on vehicle to change instruments.\nSneak-use on vehicle or blocks to change text.\nUse on pole components to remove them.\nUse on fuel pumps you placed to change prices.");
        ITEMINFO_SCREWDRIVER = new LanguageEntry("iteminfo.screwdriver", "Like a wrench, but used only to remove specific parts that wrenches cannot.  Does not interact with blocks or other things.");
        ITEMINFO_PAINTGUN = new LanguageEntry("iteminfo.paintgun", "Use on a vehicle, a part, decor, or sign to change its color.\nNote: Not all things you can click will have multiple colors.");
        ITEMINFO_KEY = new LanguageEntry("iteminfo.key", "Sneak-use on cars to take ownership, right-click to lock/unlock.");
        ITEMINFO_TICKET = new LanguageEntry("iteminfo.ticket", "Right-click on a vehicle to load nearby entities.\nRight-click on a seat to load just that seat.\nSneak-click on a vehicle to unload all entities.\nNote: Will not unload players.");
        ITEMINFO_FUELHOSE = new LanguageEntry("iteminfo.fuelhose", "Use on a vehicle tank to select.\nUse on second tank or vehicle to link.\nHose will transfer liquids from tank 1 to selected.\nHose will stop when tank 1 is empty, selected is full or if tank 1 and selected are too far away.");
        ITEMINFO_JUMPERCABLES = new LanguageEntry("iteminfo.jumpercables", "Use on an engine to select.\nUse on second engine to link.\nLinked engines will exchange power.\nEngines will un-link when power is even or if they get too far away.");
        ITEMINFO_JUMPERPACK = new LanguageEntry("iteminfo.jumperpack", "Use on a vehicle to charge battery to max level.");
        ITEMINFO_REPAIRPACK = new LanguageEntry("iteminfo.repairpack", "Use on a vehicle to repair it.  This pack heals the vehicle: ");
        ITEMINFO_REPAIRPACK_UNTOTAL = new LanguageEntry("iteminfo.repairpack.untotal", "This repair pack is able to repair totaled vehicles as well.");
        ITEMINFO_Y2KBUTTON = new LanguageEntry("iteminfo.y2kbutton", "Use in a world to turn off all vehicle engines, engage their parking brakes, and turn off their lights.\nOnly usable by admins.");
        ITEMINFO_ENGINE_AUTOMATIC = new LanguageEntry("iteminfo.engine.automatic", "Transmission: Automatic");
        ITEMINFO_ENGINE_MANUAL = new LanguageEntry("iteminfo.engine.manual", "Transmission: Manual");
        ITEMINFO_ENGINE_GEARRATIOS = new LanguageEntry("iteminfo.engine.gearratios", "Gear Ratios: ");
        ITEMINFO_ENGINE_JETPOWERFACTOR = new LanguageEntry("iteminfo.engine.jetpowerfactor", "Jet Power: ");
        ITEMINFO_ENGINE_BYPASSRATIO = new LanguageEntry("iteminfo.engine.bypassratio", "Bypass Ratio: ");
        ITEMINFO_ENGINE_MAXRPM = new LanguageEntry("iteminfo.engine.maxrpm", "Max Possible RPM: ");
        ITEMINFO_ENGINE_MAXSAFERPM = new LanguageEntry("iteminfo.engine.maxsaferpm", "Max safe RPM: ");
        ITEMINFO_ENGINE_FUELCONSUMPTION = new LanguageEntry("iteminfo.engine.fuelconsumption", "Fuel use (mb/t): ");
        ITEMINFO_ENGINE_SUPERCHARGERFUELCONSUMPTION = new LanguageEntry("iteminfo.engine.superchargerfuelconsumption", "Supercharger fuel use (mb/t): ");
        ITEMINFO_ENGINE_SUPERCHARGEREFFICIENCY = new LanguageEntry("iteminfo.engine.superchargerefficiency", "Supercharger efficiency: ");
        ITEMINFO_ENGINE_FUELTYPE = new LanguageEntry("iteminfo.engine.fueltype", "Fuel type: ");
        ITEMINFO_ENGINE_FLUIDS = new LanguageEntry("iteminfo.engine.fluids", "Takes Fluids: ");
        ITEMINFO_ENGINE_MAGIC = new LanguageEntry("iteminfo.engine.fluids", "Uses no fuel!");
        ITEMINFO_ENGINE_HOURS = new LanguageEntry("iteminfo.engine.hours", "Runtime hours: ");
        ITEMINFO_GROUND_DEVICE_DIAMETER = new LanguageEntry("iteminfo.ground_device.diameter", "Diameter: ");
        ITEMINFO_GROUND_DEVICE_MOTIVEFRICTION = new LanguageEntry("iteminfo.ground_device.motivefrictionmotivefriction", "Power friction: ");
        ITEMINFO_GROUND_DEVICE_LATERALFRICTION = new LanguageEntry("iteminfo.ground_device.lateralfriction", "Turning friction: ");
        ITEMINFO_GROUND_DEVICE_WETFRICTION = new LanguageEntry("iteminfo.ground_device.wetfriction", "Wet penalty: ");
        ITEMINFO_GROUND_DEVICE_FRICTIONMODIFIERS = new LanguageEntry("iteminfo.ground_device.frictionmodifiers", "Friction Modifiers: ");
        ITEMINFO_GROUND_DEVICE_ROTATESONSHAFT_TRUE = new LanguageEntry("iteminfo.ground_device.rotatesonshaft_true", "Is a wheel");
        ITEMINFO_GROUND_DEVICE_ROTATESONSHAFT_FALSE = new LanguageEntry("iteminfo.ground_device.rotatesonshaft_false", "Is NOT a wheel");
        ITEMINFO_GROUND_DEVICE_CANFLOAT_TRUE = new LanguageEntry("iteminfo.ground_device.canfloat_true", "Floats");
        ITEMINFO_GROUND_DEVICE_CANFLOAT_FALSE = new LanguageEntry("iteminfo.ground_device.canfloat_false", "Does not float");
        ITEMINFO_PROPELLER_STATICPITCH = new LanguageEntry("iteminfo.propeller.staticPitch", "Static Pitch");
        ITEMINFO_PROPELLER_DYNAMICPITCH = new LanguageEntry("iteminfo.propeller.dynamicPitch", "Dynamic Pitch");
        ITEMINFO_PROPELLER_PITCH = new LanguageEntry("iteminfo.propeller.pitch", "Pitch: ");
        ITEMINFO_PROPELLER_DIAMETER = new LanguageEntry("iteminfo.propeller.diameter", "Diameter: ");
        ITEMINFO_GUN_DIAMETER = new LanguageEntry("iteminfo.gun.diameter", "Barrel Diameter (mm): ");
        ITEMINFO_GUN_CASERANGE = new LanguageEntry("iteminfo.gun.caseRange", "Case Range (mm): ");
        ITEMINFO_GUN_FIREDELAY = new LanguageEntry("iteminfo.gun.fireDelay", "Fire Delay (ticks): ");
        ITEMINFO_GUN_MUZZLEVELOCITY = new LanguageEntry("iteminfo.gun.muzzleVelocity", "Velocity (blk/s): ");
        ITEMINFO_GUN_CAPACITY = new LanguageEntry("iteminfo.gun.capacity", "Bullet Capacity: ");
        ITEMINFO_GUN_AUTORELOAD = new LanguageEntry("iteminfo.gun.autoReload", "Auto-Reloads");
        ITEMINFO_GUN_YAWRANGE = new LanguageEntry("iteminfo.gun.yawRange", "Yaw Range: ");
        ITEMINFO_GUN_PITCHRANGE = new LanguageEntry("iteminfo.gun.pitchRange", "Pitch Range: ");
        ITEMINFO_BULLET_TYPE_EXPLOSIVE = new LanguageEntry("iteminfo.bullet.type.explosive", "Explosive Bullet");
        ITEMINFO_BULLET_TYPE_INCENDIARY = new LanguageEntry("iteminfo.bullet.type.incendiary", "Incendiary Bullet");
        ITEMINFO_BULLET_TYPE_ARMOR_PIERCING = new LanguageEntry("iteminfo.bullet.type.armor_piercing", "Armor Piercing Bullet");
        ITEMINFO_BULLET_TYPE_WATER = new LanguageEntry("iteminfo.bullet.type.water", "Water Bullet");
        ITEMINFO_BULLET_PELLETS = new LanguageEntry("iteminfo.bullet.pellets", "Pellets: ");
        ITEMINFO_BULLET_DIAMETER = new LanguageEntry("iteminfo.bullet.diameter", "Diameter (mm): ");
        ITEMINFO_BULLET_CASELENGTH = new LanguageEntry("iteminfo.bullet.caseLength", "Case Length (mm): ");
        ITEMINFO_BULLET_PENETRATION = new LanguageEntry("iteminfo.bullet.penetration", "Penetration (mm): ");
        ITEMINFO_BULLET_QUANTITY = new LanguageEntry("iteminfo.bullet.quantity", "Quantity: ");
        ITEMINFO_INTERACTABLE_CAPACITY = new LanguageEntry("iteminfo.interactable.capacity", "Capacity: ");
        ITEMINFO_JERRYCAN_FILL = new LanguageEntry("iteminfo.jerrycan.fill", "Fill this can by right-clicking a fuel pump.");
        ITEMINFO_JERRYCAN_DRAIN = new LanguageEntry("iteminfo.jerrycan.drain", "Fill a vehicle by right-clicking with a full can.");
        ITEMINFO_JERRYCAN_EMPTY = new LanguageEntry("iteminfo.jerrycan.empty", "This can is currently empty.");
        ITEMINFO_JERRYCAN_CONTAINS = new LanguageEntry("iteminfo.jerrycan.contains", "This can contains: ");
        INPUT_MOD = new LanguageEntry("input.mod", "Mod");
        INPUT_CAMLOCK = new LanguageEntry("input.camlock", "CamLock");
        INPUT_YAW = new LanguageEntry("input.yaw", "Yaw");
        INPUT_YAW_R = new LanguageEntry("input.yaw_r", "YawRight");
        INPUT_YAW_L = new LanguageEntry("input.yaw_l", "YawLeft");
        INPUT_PITCH = new LanguageEntry("input.pitch", "Pitch");
        INPUT_PITCH_U = new LanguageEntry("input.pitch_u", "PitchUp");
        INPUT_PITCH_D = new LanguageEntry("input.pitch_d", "PitchDown");
        INPUT_ROLL = new LanguageEntry("input.roll", "Roll");
        INPUT_ROLL_R = new LanguageEntry("input.roll_r", "RollRight");
        INPUT_ROLL_L = new LanguageEntry("input.roll_l", "RollLeft");
        INPUT_THROTTLE = new LanguageEntry("input.throttle", "Throttle");
        INPUT_THROTTLE_U = new LanguageEntry("input.throttle_u", "ThrottleUp");
        INPUT_THROTTLE_D = new LanguageEntry("input.throttle_d", "ThrottleDown");
        INPUT_FLAPS_U = new LanguageEntry("input.flaps_u", "FlapsUp");
        INPUT_FLAPS_D = new LanguageEntry("input.flaps_d", "FlapsDown");
        INPUT_BRAKE = new LanguageEntry("input.brake", "Brake");
        INPUT_GEAR = new LanguageEntry("input.gear", "Gear");
        INPUT_PANEL = new LanguageEntry("input.panel", "Panel");
        INPUT_PARK = new LanguageEntry("input.park", "ParkingBrake");
        INPUT_GUN_FIRE = new LanguageEntry("input.gun_fire", "Gun");
        INPUT_GUN_SWITCH = new LanguageEntry("input.gun_switch", "Switch Gun");
        INPUT_RADIO = new LanguageEntry("input.radio", "Radio");
        INPUT_ZOOM_I = new LanguageEntry("input.zoom_i", "ZoomIn");
        INPUT_ZOOM_O = new LanguageEntry("input.zoom_o", "ZoomOut");
        INPUT_CHANGEVIEW = new LanguageEntry("input.changeview", "ChangeView");
        INPUT_LOOK_L = new LanguageEntry("input.look_l", "LookLeft");
        INPUT_LOOK_R = new LanguageEntry("input.look_r", "LookRight");
        INPUT_LOOK_U = new LanguageEntry("input.look_u", "LookUp");
        INPUT_LOOK_D = new LanguageEntry("input.look_d", "LookDown");
        INPUT_LOOK_A = new LanguageEntry("input.look_a", "LookDirectional");
        INPUT_TRIM_YAW_R = new LanguageEntry("input.trim_yaw_r", "TrimYawRight");
        INPUT_TRIM_YAW_L = new LanguageEntry("input.trim_yaw_l", "TrimYawLeft");
        INPUT_TRIM_PITCH_U = new LanguageEntry("input.trim_pitch_u", "TrimPitchUp");
        INPUT_TRIM_PITCH_D = new LanguageEntry("input.trim_pitch_d", "TrimPitchDown");
        INPUT_TRIM_ROLL_R = new LanguageEntry("input.trim_roll_r", "TrimRollRight");
        INPUT_TRIM_ROLL_L = new LanguageEntry("input.trim_roll_l", "TrimRollLeft");
        INPUT_REVERSE = new LanguageEntry("input.reverse", "Reverse");
        INPUT_JS_INHIBIT = new LanguageEntry("input.js_inhibit", "DisableJoystick");
        INPUT_TURN = new LanguageEntry("input.turn", "Turn");
        INPUT_TURN_R = new LanguageEntry("input.turn_r", "TurnRight");
        INPUT_TURN_L = new LanguageEntry("input.turn_l", "TurnLeft");
        INPUT_GAS = new LanguageEntry("input.gas", "Gas");
        INPUT_SHIFT_U = new LanguageEntry("input.shift_u", "ShiftUp");
        INPUT_SHIFT_D = new LanguageEntry("input.shift_d", "ShiftDown");
        INPUT_SHIFT_N = new LanguageEntry("input.shift_n", "ShiftNeutral");
        INPUT_SHIFT_1 = new LanguageEntry("input.shift_1", "Gear1");
        INPUT_SHIFT_2 = new LanguageEntry("input.shift_2", "Gear2");
        INPUT_SHIFT_3 = new LanguageEntry("input.shift_3", "Gear3");
        INPUT_SHIFT_4 = new LanguageEntry("input.shift_4", "Gear4");
        INPUT_SHIFT_5 = new LanguageEntry("input.shift_5", "Gear5");
        INPUT_SHIFT_6 = new LanguageEntry("input.shift_6", "Gear6");
        INPUT_SHIFT_7 = new LanguageEntry("input.shift_6", "Gear7");
        INPUT_SHIFT_8 = new LanguageEntry("input.shift_6", "Gear8");
        INPUT_SHIFT_9 = new LanguageEntry("input.shift_6", "Gear9");
        INPUT_SHIFT_R = new LanguageEntry("input.shift_r", "GearR");
        INPUT_HORN = new LanguageEntry("input.horn", "Horn");
        INPUT_SLOW = new LanguageEntry("input.slow", "Slow");
        INPUT_LIGHTS = new LanguageEntry("input.lights", "Lights");
        INPUT_TURNSIGNAL_R = new LanguageEntry("input.turnsignal_r", "RightSignal");
        INPUT_TURNSIGNAL_L = new LanguageEntry("input.turnsignal_l", "LeftSignal");
        SYSTEM_SOUNDSLOT = new LanguageEntry("sytstem.soundslot", "IMMERSIVE VEHICLES ERROR: Tried to play a sound, but was told no sound slots were available. Some mod is taking up all the slots. If you have Immersive Railroading, set override sound channels to false in that mod's config. If running GregTech, set maxNumSounds to a lower value in that mod's config. If you have Receiver Gun Mod, un-install it (there is no config for this incopatibility).  Dynamic Surrondings and Optifine also may cause issues. Apply fixes, or complain to those mod's authors. Sounds will not play.");
        SYSTEM_DEBUG = new LanguageEntry("sytstem.debug", "%s");
    }

    public static class JSONLanguageFile {
        public Map<String, String> entries;
    }

    public static class LanguageEntry {
        private static final String DEFAULT_LANGUAGE_KEY = "en_us";
        public final Map<String, String> values = new HashMap<String, String>();
        public final String key;

        public LanguageEntry(String defaultValue) {
            this.values.put(DEFAULT_LANGUAGE_KEY, defaultValue);
            this.key = null;
        }

        private LanguageEntry(String key, String defaultValue) {
            this.values.put(DEFAULT_LANGUAGE_KEY, defaultValue);
            this.key = key;
            coreLanguageEntires.put(key, this);
        }

        public String getCurrentValue() {
            if (onClient) {
                String value = this.values.get(InterfaceManager.clientInterface.getLanguageName());
                return value != null ? value : this.getDefaultValue();
            }
            return this.getDefaultValue();
        }

        public String getDefaultValue() {
            return this.values.get(DEFAULT_LANGUAGE_KEY);
        }
    }
}

