/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.sound;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import minecrafttransportsimulator.sound.IStreamDecoder;

public class OGGDecoder
implements IStreamDecoder {
    private static final int OGG_BUFFER_SIZE = 4096;
    private final InputStream dataSourceStream;
    private final ByteBuffer decodedDataBuffer;
    private boolean doneProcessing;
    private final SyncState syncState = new SyncState();
    private final StreamState streamState = new StreamState();
    private final Page page = new Page();
    private final Packet packet = new Packet();
    private final Comment comment = new Comment();
    private final Info info = new Info();
    private final DspState dspState = new DspState();
    private final Block block = new Block(this.dspState);
    private int totalSamplesProcessed;
    private boolean bufferFilledLastDecodeCall;
    private final float[][][] pcmInfo;
    private final int[] pcmIndex;

    public OGGDecoder(InputStream dataSourceStream) {
        this.dataSourceStream = dataSourceStream;
        this.syncState.init();
        this.info.init();
        this.comment.init();
        this.syncState.buffer(4096);
        int packetCount = 0;
        while (packetCount < 3) {
            do {
                int pageStatus;
                if ((pageStatus = this.syncState.pageout(this.page)) == 1) {
                    if (++packetCount == 1) {
                        this.streamState.init(this.page.serialno());
                    }
                    this.streamState.pagein(this.page);
                    this.streamState.packetout(this.packet);
                    this.info.synthesis_headerin(this.comment, this.packet);
                    continue;
                }
                if (pageStatus == 0) {
                    try {
                        int offset = this.syncState.buffer(4096);
                        int bytesRead = dataSourceStream.read(this.syncState.data, offset, 4096);
                        this.syncState.wrote(bytesRead);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                throw new IllegalStateException("ERROR: Corrupt OGG file detected!");
            } while (packetCount < 3);
        }
        this.dspState.synthesis_init(this.info);
        this.pcmInfo = new float[1][][];
        this.pcmIndex = new int[this.info.channels];
        this.decodedDataBuffer = ByteBuffer.allocateDirect(131072).order(ByteOrder.nativeOrder());
    }

    @Override
    public ByteBuffer readBlock() {
        if (this.doneProcessing) {
            return null;
        }
        this.totalSamplesProcessed = 0;
        int totalBytesRead = 0;
        this.decodedDataBuffer.clear();
        if (this.bufferFilledLastDecodeCall) {
            this.decodeSamples();
        }
        while (totalBytesRead < 49152 && !this.bufferFilledLastDecodeCall && !this.doneProcessing) {
            if (this.syncState.pageout(this.page) == 1) {
                this.streamState.pagein(this.page);
            }
            while (!this.bufferFilledLastDecodeCall && this.streamState.packetout(this.packet) == 1) {
                if (this.block.synthesis(this.packet) != 0) continue;
                this.dspState.synthesis_blockin(this.block);
                this.decodeSamples();
            }
            if (this.bufferFilledLastDecodeCall) continue;
            try {
                int offset = this.syncState.buffer(4096);
                int bytesRead = this.dataSourceStream.read(this.syncState.data, offset, 4096);
                if (bytesRead == -1) {
                    this.doneProcessing = true;
                    continue;
                }
                this.syncState.wrote(bytesRead);
                totalBytesRead += bytesRead;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.doneProcessing = true;
            }
        }
        this.decodedDataBuffer.rewind();
        this.decodedDataBuffer.limit(this.totalSamplesProcessed * 2 * this.info.channels);
        return this.info.channels == 2 ? IStreamDecoder.stereoToMono(this.decodedDataBuffer) : this.decodedDataBuffer;
    }

    private void decodeSamples() {
        ShortBuffer sampleBuffer = this.decodedDataBuffer.asShortBuffer();
        int samplesLeftInBuffer = 131072 / (2 * this.info.channels) - this.totalSamplesProcessed;
        int samplesAbleToProcess = this.dspState.synthesis_pcmout(this.pcmInfo, this.pcmIndex);
        if (samplesAbleToProcess > samplesLeftInBuffer) {
            samplesAbleToProcess = samplesLeftInBuffer;
            this.bufferFilledLastDecodeCall = true;
        } else {
            this.bufferFilledLastDecodeCall = false;
        }
        for (int i = 0; i < samplesAbleToProcess; ++i) {
            for (int j = 0; j < this.info.channels; ++j) {
                float[] channelSamples = this.pcmInfo[0][j];
                int value = (int)(channelSamples[this.pcmIndex[j] + i] * 32767.0f);
                if (value > Short.MAX_VALUE) {
                    value = Short.MAX_VALUE;
                }
                if (value < Short.MIN_VALUE) {
                    value = Short.MIN_VALUE;
                }
                sampleBuffer.put((short)value);
            }
        }
        this.dspState.synthesis_read(samplesAbleToProcess);
        this.totalSamplesProcessed += samplesAbleToProcess;
        this.decodedDataBuffer.position(this.decodedDataBuffer.position() + sampleBuffer.position() * 2);
    }

    @Override
    public void stop() {
        try {
            this.dataSourceStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getSampleRate() {
        return this.info.rate;
    }
}

