/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering;

import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.rendering.RenderableObject;

public class TreadRoller {
    public final Point3D centerPoint;
    public final double radius;
    public final double circumference;
    public double startY;
    public double startZ;
    public double startAngle;
    public double endY;
    public double endZ;
    public double endAngle;

    public TreadRoller(RenderableObject object) {
        float minY = 999.0f;
        float maxY = -999.0f;
        float minZ = 999.0f;
        float maxZ = -999.0f;
        for (int i = 0; i < object.vertices.capacity(); i += 8) {
            float y = object.vertices.get(i + 6);
            float z = object.vertices.get(i + 7);
            minY = Math.min(minY, y);
            maxY = Math.max(maxY, y);
            minZ = Math.min(minZ, z);
            maxZ = Math.max(maxZ, z);
        }
        this.centerPoint = new Point3D(0.0, (double)minY + (double)(maxY - minY) / 2.0, (double)minZ + (double)(maxZ - minZ) / 2.0);
        this.radius = (double)(maxZ - minZ) / 2.0;
        this.circumference = Math.PI * 2 * this.radius;
    }

    public void calculateEndpoints(TreadRoller nextRoller) {
        if (this.radius == nextRoller.radius) {
            this.endAngle = Math.toDegrees(Math.atan2(nextRoller.centerPoint.z - this.centerPoint.z, nextRoller.centerPoint.y - this.centerPoint.y)) - 90.0;
        } else {
            double centerDistance = Math.hypot(nextRoller.centerPoint.z - this.centerPoint.z, nextRoller.centerPoint.y - this.centerPoint.y);
            boolean nextRollerLarger = this.radius < nextRoller.radius;
            double r1CenterY = nextRollerLarger ? this.centerPoint.y : nextRoller.centerPoint.y;
            double r1CenterZ = nextRollerLarger ? this.centerPoint.z : nextRoller.centerPoint.z;
            double r2CenterY = !nextRollerLarger ? this.centerPoint.y : nextRoller.centerPoint.y;
            double r2CenterZ = !nextRollerLarger ? this.centerPoint.z : nextRoller.centerPoint.z;
            double r1Radius = nextRollerLarger ? this.radius : nextRoller.radius;
            double r2Radius = !nextRollerLarger ? this.radius : nextRoller.radius;
            double centerVectorAngle = Math.atan2(r2CenterZ - r1CenterZ, r2CenterY - r1CenterY);
            double inscribedVectorAngle = Math.asin((r2Radius - r1Radius) / centerDistance);
            double netAngle = centerVectorAngle + (nextRollerLarger ? -inscribedVectorAngle - 1.5707963267948966 : inscribedVectorAngle + 1.5707963267948966);
            this.endAngle = Math.toDegrees(netAngle);
        }
        this.setEndAngle(this.endAngle);
    }

    public void setStartAngle(double startAngle) {
        this.startAngle = startAngle;
        this.startY = this.centerPoint.y + this.radius * Math.cos(Math.toRadians(startAngle));
        this.startZ = this.centerPoint.z + this.radius * Math.sin(Math.toRadians(startAngle));
    }

    public void setEndAngle(double endAngle) {
        this.endAngle = endAngle;
        this.endY = this.centerPoint.y + this.radius * Math.cos(Math.toRadians(endAngle));
        this.endZ = this.centerPoint.z + this.radius * Math.sin(Math.toRadians(endAngle));
    }
}

