/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityLoader;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.PartInteractable;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntity;

public class PacketTileEntityLoaderConnection
extends APacketEntity<ATileEntityLoader> {
    private final UUID linkedID;
    private final boolean connect;

    public PacketTileEntityLoaderConnection(ATileEntityLoader loader, boolean connect) {
        super(loader);
        this.linkedID = loader.connectedPart != null ? loader.connectedPart.uniqueUUID : null;
        this.connect = connect;
    }

    public PacketTileEntityLoaderConnection(ByteBuf buf) {
        super(buf);
        this.linkedID = buf.readBoolean() ? PacketTileEntityLoaderConnection.readUUIDFromBuffer(buf) : null;
        this.connect = buf.readBoolean();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        if (this.linkedID != null) {
            buf.writeBoolean(true);
            PacketTileEntityLoaderConnection.writeUUIDToBuffer(this.linkedID, buf);
        } else {
            buf.writeBoolean(false);
        }
        buf.writeBoolean(this.connect);
    }

    @Override
    protected boolean handle(AWrapperWorld world, ATileEntityLoader loader) {
        AEntityF_Multipart entity = (AEntityF_Multipart)world.getEntity(this.linkedID);
        if (this.connect) {
            if (entity != null) {
                loader.connectToPart((PartInteractable)entity);
            }
        } else {
            loader.connectToPart(null);
        }
        return true;
    }
}

