/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.entities.instances.PartGun;
import minecrafttransportsimulator.items.instances.ItemBullet;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntity;

public class PacketPartGun
extends APacketEntity<PartGun> {
    private final boolean controlPulse;
    private final boolean triggerState;
    private final boolean aimState;
    private final ItemBullet bulletItem;

    public PacketPartGun(PartGun gun, boolean triggerState, boolean aimState) {
        super(gun);
        this.controlPulse = true;
        this.triggerState = triggerState;
        this.aimState = aimState;
        this.bulletItem = null;
    }

    public PacketPartGun(PartGun gun, ItemBullet bullet) {
        super(gun);
        this.controlPulse = false;
        this.triggerState = false;
        this.aimState = false;
        this.bulletItem = bullet;
    }

    public PacketPartGun(ByteBuf buf) {
        super(buf);
        this.controlPulse = buf.readBoolean();
        this.aimState = buf.readBoolean();
        if (this.controlPulse) {
            this.triggerState = buf.readBoolean();
            this.bulletItem = null;
        } else {
            this.triggerState = false;
            this.bulletItem = (ItemBullet)PacketPartGun.readItemFromBuffer(buf);
        }
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeBoolean(this.controlPulse);
        buf.writeBoolean(this.aimState);
        if (this.controlPulse) {
            buf.writeBoolean(this.triggerState);
        } else {
            PacketPartGun.writeItemToBuffer(this.bulletItem, buf);
        }
    }

    @Override
    public boolean handle(AWrapperWorld world, PartGun gun) {
        if (this.controlPulse) {
            gun.playerHoldingTrigger = this.triggerState;
            gun.isHandHeldGunAimed = this.aimState;
            return true;
        }
        gun.clientNextBullet = this.bulletItem;
        return false;
    }
}

