/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.PartEngine;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntity;

public class PacketPartEngine
extends APacketEntity<PartEngine> {
    private final Signal packetType;
    private final double hours;
    private final UUID linkedID;
    private final int linkedIndex;

    public PacketPartEngine(PartEngine engine, Signal packetType) {
        super(engine);
        this.packetType = packetType;
        this.hours = 0.0;
        this.linkedID = null;
        this.linkedIndex = 0;
    }

    public PacketPartEngine(PartEngine engine, double hours) {
        super(engine);
        this.packetType = Signal.DAMAGE;
        this.hours = hours;
        this.linkedID = null;
        this.linkedIndex = 0;
    }

    public PacketPartEngine(PartEngine engine, PartEngine linkedEngine) {
        super(engine);
        this.packetType = Signal.LINK;
        this.hours = 0.0;
        this.linkedID = linkedEngine.entityOn.uniqueUUID;
        this.linkedIndex = linkedEngine.placementSlot;
    }

    public PacketPartEngine(ByteBuf buf) {
        super(buf);
        this.packetType = Signal.values()[buf.readByte()];
        this.hours = this.packetType.equals((Object)Signal.DAMAGE) ? buf.readDouble() : 0.0;
        if (this.packetType.equals((Object)Signal.LINK)) {
            this.linkedID = PacketPartEngine.readUUIDFromBuffer(buf);
            this.linkedIndex = buf.readInt();
        } else {
            this.linkedID = null;
            this.linkedIndex = 0;
        }
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeByte(this.packetType.ordinal());
        if (this.packetType.equals((Object)Signal.DAMAGE)) {
            buf.writeDouble(this.hours);
        } else if (this.packetType.equals((Object)Signal.LINK)) {
            PacketPartEngine.writeUUIDToBuffer(this.linkedID, buf);
            buf.writeInt(this.linkedIndex);
        }
    }

    @Override
    public boolean handle(AWrapperWorld world, PartEngine engine) {
        switch (this.packetType) {
            case HS_ON: {
                engine.handStartEngine();
                break;
            }
            case AS_ON: {
                engine.autoStartEngine();
                break;
            }
            case BACKFIRE: {
                engine.backfireEngine();
                break;
            }
            case SHIFT_UP: {
                engine.shiftUp();
                break;
            }
            case SHIFT_DOWN: {
                engine.shiftDown();
                break;
            }
            case SHIFT_NEUTRAL: {
                engine.shiftNeutral();
                break;
            }
            case BAD_SHIFT: {
                engine.badShiftEngine();
                break;
            }
            case START: {
                engine.startEngine();
                break;
            }
            case INACTIVE: 
            case FUEL_OUT: 
            case TOO_SLOW: 
            case DEAD_VEHICLE: 
            case INVALID_DIMENSION: 
            case DROWN: {
                engine.stallEngine(this.packetType);
                break;
            }
            case DAMAGE: {
                engine.hours += this.hours;
                break;
            }
            case LINK: {
                AEntityF_Multipart otherEntity = (AEntityF_Multipart)world.getEntity(this.linkedID);
                if (otherEntity == null) break;
                engine.linkedEngine = (PartEngine)otherEntity.partsInSlots.get(this.linkedIndex);
                return false;
            }
        }
        return true;
    }

    public static enum Signal {
        HS_ON,
        AS_ON,
        BACKFIRE,
        SHIFT_UP,
        SHIFT_DOWN,
        SHIFT_NEUTRAL,
        BAD_SHIFT,
        START,
        INACTIVE,
        FUEL_OUT,
        DEAD_VEHICLE,
        INVALID_DIMENSION,
        TOO_SLOW,
        DROWN,
        DAMAGE,
        LINK;

    }
}

