/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntity;

public class PacketPartChange_Remove
extends APacketEntity<AEntityF_Multipart<?>> {
    private final boolean removeFromWorld;
    private final UUID partUUID;

    public PacketPartChange_Remove(APart partRemoved, boolean removeFromWorld) {
        super(partRemoved.entityOn);
        this.removeFromWorld = removeFromWorld;
        this.partUUID = partRemoved.uniqueUUID;
    }

    public PacketPartChange_Remove(ByteBuf buf) {
        super(buf);
        this.removeFromWorld = buf.readBoolean();
        this.partUUID = PacketPartChange_Remove.readUUIDFromBuffer(buf);
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeBoolean(this.removeFromWorld);
        PacketPartChange_Remove.writeUUIDToBuffer(this.partUUID, buf);
    }

    @Override
    public boolean handle(AWrapperWorld world, AEntityF_Multipart<?> entity) {
        APart part = (APart)world.getEntity(this.partUUID);
        if (part != null) {
            part.entityOn.removePart(part, this.removeFromWorld, null);
        }
        return false;
    }
}

