/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.entities.instances.EntityBullet;
import minecrafttransportsimulator.entities.instances.PartGun;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.packets.components.APacketBase;

public class PacketEntityBulletHitGeneric
extends APacketBase {
    private final UUID gunID;
    private final int bulletNumber;
    private final Point3D position;
    private final ABlockBase.Axis hitSide;
    private final EntityBullet.HitType hitType;

    public PacketEntityBulletHitGeneric(PartGun gun, int bulletNumber, Point3D position, ABlockBase.Axis hitSide, EntityBullet.HitType hitType) {
        super(null);
        this.gunID = gun.uniqueUUID;
        this.bulletNumber = bulletNumber;
        this.position = position;
        this.hitSide = hitSide;
        this.hitType = hitType;
    }

    public PacketEntityBulletHitGeneric(ByteBuf buf) {
        super(buf);
        this.gunID = PacketEntityBulletHitGeneric.readUUIDFromBuffer(buf);
        this.bulletNumber = buf.readInt();
        this.position = PacketEntityBulletHitGeneric.readPoint3dFromBuffer(buf);
        this.hitType = EntityBullet.HitType.values()[buf.readByte()];
        this.hitSide = ABlockBase.Axis.values()[buf.readByte()];
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        PacketEntityBulletHitGeneric.writeUUIDToBuffer(this.gunID, buf);
        buf.writeInt(this.bulletNumber);
        PacketEntityBulletHitGeneric.writePoint3dToBuffer(this.position, buf);
        buf.writeByte(this.hitType.ordinal());
        buf.writeByte(this.hitSide.ordinal());
    }

    @Override
    public void handle(AWrapperWorld world) {
        EntityBullet.performGenericHitLogic(world.getBulletGun(this.gunID), this.bulletNumber, this.position, this.hitSide, this.hitType);
    }
}

