/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.items.components;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.jsondefs.JSONCraftingBench;
import minecrafttransportsimulator.jsondefs.JSONPack;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.packloading.PackParser;
import minecrafttransportsimulator.systems.LanguageSystem;

public abstract class AItemPack<JSONDefinition extends AJSONItem>
extends AItemBase {
    public final JSONDefinition definition;
    private final String sourcePackID;
    public LanguageSystem.LanguageEntry languageName;
    public LanguageSystem.LanguageEntry languageDescription;

    public AItemPack(JSONDefinition definition, String sourcePackID) {
        this.definition = definition;
        this.sourcePackID = sourcePackID;
    }

    @Override
    public String getRegistrationName() {
        return ((AJSONItem)this.definition).packID + "." + ((AJSONItem)this.definition).systemName;
    }

    @Override
    public String getItemName() {
        return this.languageName.getCurrentValue();
    }

    @Override
    public void addTooltipLines(List<String> tooltipLines, IWrapperNBT data) {
        String text = this.languageDescription.getCurrentValue();
        if (!text.isEmpty()) {
            Collections.addAll(tooltipLines, text.split("\n"));
        }
    }

    @Override
    public int getStackSize() {
        return ((AJSONItem)this.definition).general.stackSize != 0 ? ((AJSONItem)this.definition).general.stackSize : super.getStackSize();
    }

    @Override
    public String getCreativeTabID() {
        String owningPackID = ((AJSONItem)this.definition).packID;
        String generatingPackID = this.sourcePackID != null ? this.sourcePackID : ((AJSONItem)this.definition).packID;
        JSONPack owningConfiguration = PackParser.getPackConfiguration(((AJSONItem)this.definition).packID);
        JSONPack generatingConfiguration = PackParser.getPackConfiguration(generatingPackID);
        if (owningConfiguration.externalSkinsInOwnTab) {
            return generatingPackID;
        }
        if (generatingConfiguration.internalSkinsInOwnTab) {
            return generatingPackID;
        }
        return owningPackID;
    }

    public boolean isBenchValid(JSONCraftingBench craftingDefinition) {
        boolean hasMaterials = false;
        for (List<String> list : ((AJSONItem)this.definition).general.materialLists) {
            if (list.isEmpty()) continue;
            hasMaterials = true;
            break;
        }
        if (!hasMaterials && this instanceof AItemSubTyped) {
            for (List<String> list : ((AItemSubTyped)this).subDefinition.extraMaterialLists) {
                if (list.isEmpty()) continue;
                hasMaterials = true;
                break;
            }
        }
        if (hasMaterials) {
            if (craftingDefinition.items != null) {
                return craftingDefinition.items.contains(((AJSONItem)this.definition).packID + ":" + ((AJSONItem)this.definition).systemName);
            }
            if (craftingDefinition.itemTypes.contains(((AJSONItem)this.definition).classification.toString().toLowerCase(Locale.ROOT))) {
                if (this.definition instanceof JSONPart && craftingDefinition.partTypes != null) {
                    for (String partType : craftingDefinition.partTypes) {
                        if (!((JSONPart)this.definition).generic.type.contains(partType)) continue;
                        return true;
                    }
                } else {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean needsRepair(IWrapperNBT data) {
        return data != null && data.getDouble("damage") > 0.0;
    }

    public void repair(IWrapperNBT data) {
        data.setDouble("damage", 0.0);
    }
}

