/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityPole_Component;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole_TrafficSignal;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntitySignalController;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponentButton;
import minecrafttransportsimulator.guis.components.GUIComponentLabel;
import minecrafttransportsimulator.guis.components.GUIComponentTextBox;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketTileEntitySignalControllerChange;
import minecrafttransportsimulator.rendering.RenderText;
import minecrafttransportsimulator.systems.LanguageSystem;

public class GUISignalController
extends AGUIBase {
    private GUIComponentButton scanButton;
    private GUIComponentButton directionButton;
    private GUIComponentButton cycleButton;
    private GUIComponentButton driveSideButton;
    private boolean onLaneScreen;
    private GUIComponentLabel trafficSignalCount;
    private GUIComponentNumericTextBox scanDistanceText;
    private GUIComponentNumericTextBox scanCenterXText;
    private GUIComponentNumericTextBox scanCenterZText;
    private GUIComponentNumericTextBox laneWidthText;
    private GUIComponentNumericTextBox greenMainTimeText;
    private GUIComponentNumericTextBox greenCrossTimeText;
    private GUIComponentNumericTextBox yellowMainTimeText;
    private GUIComponentNumericTextBox yellowCrossTimeText;
    private GUIComponentNumericTextBox allRedTimeText;
    private final Set<GUIComponentIntersectionProperties> intersectionPropertyComponents = new HashSet<GUIComponentIntersectionProperties>();
    private final List<GUIComponentLabel> upperPropertyLabels = new ArrayList<GUIComponentLabel>();
    private final List<GUIComponentLabel> lowerPropertyLabels = new ArrayList<GUIComponentLabel>();
    private final TileEntitySignalController controller;

    public GUISignalController(TileEntitySignalController controller) {
        this.controller = controller;
    }

    @Override
    public void setupComponents() {
        super.setupComponents();
        int topOffset = this.guiTop + 15;
        int leftTextOffset = this.guiLeft + 20;
        int leftObjectOffset = this.guiLeft + 100;
        int middleObjectOffset = this.guiLeft + 140;
        int rowSpacing = 2;
        this.scanButton = new GUIComponentButton(leftTextOffset, topOffset, 220, 15, LanguageSystem.GUI_SIGNALCONTROLLER_SCAN.getCurrentValue()){

            @Override
            public void onClicked(boolean leftSide) {
                ((GUISignalController)GUISignalController.this).controller.componentLocations.clear();
                int scanDistance = Integer.parseInt(GUISignalController.this.scanDistanceText.getText());
                double minX = Double.MAX_VALUE;
                double maxX = -1.7976931348623157E308;
                double minZ = Double.MAX_VALUE;
                double maxZ = -1.7976931348623157E308;
                for (double i = ((GUISignalController)GUISignalController.this).controller.position.x - (double)scanDistance; i <= ((GUISignalController)GUISignalController.this).controller.position.x + (double)scanDistance; i += 1.0) {
                    for (double j = ((GUISignalController)GUISignalController.this).controller.position.y - (double)scanDistance; j <= ((GUISignalController)GUISignalController.this).controller.position.y + (double)scanDistance; j += 1.0) {
                        block2: for (double k = ((GUISignalController)GUISignalController.this).controller.position.z - (double)scanDistance; k <= ((GUISignalController)GUISignalController.this).controller.position.z + (double)scanDistance; k += 1.0) {
                            Point3D checkPosition = new Point3D(i, j, k);
                            Object tile = ((GUISignalController)GUISignalController.this).controller.world.getTileEntity(checkPosition);
                            if (!(tile instanceof TileEntityPole)) continue;
                            for (ATileEntityPole_Component component : ((TileEntityPole)tile).components.values()) {
                                if (!(component instanceof TileEntityPole_TrafficSignal)) continue;
                                ((GUISignalController)GUISignalController.this).controller.componentLocations.add(((ATileEntityBase)tile).position);
                                minX = Math.min(minX, ((ATileEntityBase)tile).position.x);
                                maxX = Math.max(maxX, ((ATileEntityBase)tile).position.x);
                                minZ = Math.min(minZ, ((ATileEntityBase)tile).position.z);
                                maxZ = Math.max(maxZ, ((ATileEntityBase)tile).position.z);
                                continue block2;
                            }
                        }
                    }
                }
                ((GUISignalController)GUISignalController.this).controller.intersectionCenterPoint.set(minX + (maxX - minX) / 2.0, ((GUISignalController)GUISignalController.this).controller.position.y, minZ + (maxZ - minZ) / 2.0);
                GUISignalController.this.scanCenterXText.setText(String.valueOf(((GUISignalController)GUISignalController.this).controller.intersectionCenterPoint.x));
                GUISignalController.this.scanCenterZText.setText(String.valueOf(((GUISignalController)GUISignalController.this).controller.intersectionCenterPoint.z));
                double averageDistance = ((maxX - minX) / 2.0 + (maxZ - minZ) / 2.0) / 2.0;
                block4: for (ABlockBase.Axis axis : ((GUISignalController)GUISignalController.this).controller.intersectionProperties.keySet()) {
                    TileEntitySignalController.IntersectionProperties properties = ((GUISignalController)GUISignalController.this).controller.intersectionProperties.get((Object)axis);
                    properties.roadWidth = averageDistance;
                    properties.centerLaneCount = (int)Math.max(1.0, properties.roadWidth / GUISignalController.this.laneWidthText.getDoubleValue());
                    properties.centerDistance = averageDistance;
                    if (((GUISignalController)GUISignalController.this).controller.isRightHandDrive) {
                        properties.centerOffset = -averageDistance;
                    }
                    for (GUIComponentIntersectionProperties component : GUISignalController.this.intersectionPropertyComponents) {
                        if (!component.axis.equals((Object)axis)) continue;
                        component.centerLaneText.setText(String.valueOf(properties.centerLaneCount));
                        component.roadWidthText.setText(String.valueOf(properties.roadWidth));
                        component.centerDistanceText.setText(String.valueOf(properties.centerDistance));
                        component.centerOffsetText.setText(String.valueOf(properties.centerOffset));
                        continue block4;
                    }
                }
                GUISignalController.this.controller.initializeController(null);
                ((GUISignalController)GUISignalController.this).controller.unsavedClientChangesPreset = true;
            }
        };
        this.addComponent(this.scanButton);
        this.scanCenterXText = new GUIComponentNumericTextBox(leftObjectOffset, topOffset += this.scanButton.height + rowSpacing, String.valueOf(this.controller.intersectionCenterPoint.x), 60){

            @Override
            public void setVariable() {
                ((GUISignalController)GUISignalController.this).controller.intersectionCenterPoint.x = this.getDoubleValue();
            }
        };
        this.addComponent(this.scanCenterXText);
        this.scanCenterZText = new GUIComponentNumericTextBox(this.scanCenterXText.constructedX + this.scanCenterXText.width + 5, topOffset, String.valueOf(this.controller.intersectionCenterPoint.z), 60){

            @Override
            public void setVariable() {
                ((GUISignalController)GUISignalController.this).controller.intersectionCenterPoint.z = this.getDoubleValue();
            }
        };
        this.addComponent(this.scanCenterZText);
        this.addComponent(new GUIComponentLabel(leftTextOffset, topOffset, ColorRGB.WHITE, LanguageSystem.GUI_SIGNALCONTROLLER_SCANCENTER.getCurrentValue()).setComponent(this.scanCenterXText));
        this.scanDistanceText = new GUIComponentNumericTextBox(leftObjectOffset, topOffset += this.scanCenterXText.height + rowSpacing, "25");
        this.addComponent(this.scanDistanceText);
        this.addComponent(new GUIComponentLabel(leftTextOffset, topOffset, ColorRGB.WHITE, LanguageSystem.GUI_SIGNALCONTROLLER_SCANDISTANCE.getCurrentValue()).setComponent(this.scanDistanceText));
        this.trafficSignalCount = new GUIComponentLabel(this.scanDistanceText.constructedX + this.scanDistanceText.width + 5, topOffset, ColorRGB.WHITE, LanguageSystem.GUI_SIGNALCONTROLLER_SCANFOUND.getCurrentValue() + this.controller.componentLocations.size());
        this.addComponent(this.trafficSignalCount);
        this.driveSideButton = new GUIComponentButton(leftTextOffset, topOffset += this.scanDistanceText.height + rowSpacing * 3, 115, 15, this.controller.isRightHandDrive ? LanguageSystem.GUI_SIGNALCONTROLLER_RIGHTHANDDRIVE.getCurrentValue() : LanguageSystem.GUI_SIGNALCONTROLLER_LEFTHANDDRIVE.getCurrentValue()){

            @Override
            public void onClicked(boolean leftSide) {
                ((GUISignalController)GUISignalController.this).controller.isRightHandDrive = !((GUISignalController)GUISignalController.this).controller.isRightHandDrive;
                this.text = ((GUISignalController)GUISignalController.this).controller.isRightHandDrive ? LanguageSystem.GUI_SIGNALCONTROLLER_RIGHTHANDDRIVE.getCurrentValue() : LanguageSystem.GUI_SIGNALCONTROLLER_LEFTHANDDRIVE.getCurrentValue();
                ((GUISignalController)GUISignalController.this).controller.unsavedClientChangesPreset = true;
                GUISignalController.this.controller.initializeController(null);
            }
        };
        this.addComponent(this.driveSideButton);
        this.cycleButton = new GUIComponentButton(middleObjectOffset, topOffset, 100, 15, this.controller.timedMode ? LanguageSystem.GUI_SIGNALCONTROLLER_TIMEMODE.getCurrentValue() : LanguageSystem.GUI_SIGNALCONTROLLER_TRIGGERMODE.getCurrentValue()){

            @Override
            public void onClicked(boolean leftSide) {
                ((GUISignalController)GUISignalController.this).controller.timedMode = !((GUISignalController)GUISignalController.this).controller.timedMode;
                this.text = ((GUISignalController)GUISignalController.this).controller.timedMode ? LanguageSystem.GUI_SIGNALCONTROLLER_TIMEMODE.getCurrentValue() : LanguageSystem.GUI_SIGNALCONTROLLER_TRIGGERMODE.getCurrentValue();
                ((GUISignalController)GUISignalController.this).controller.unsavedClientChangesPreset = true;
                GUISignalController.this.controller.initializeController(null);
            }
        };
        this.addComponent(this.cycleButton);
        this.directionButton = new GUIComponentButton(leftTextOffset, topOffset += this.cycleButton.height + rowSpacing, 115, 15, LanguageSystem.GUI_SIGNALCONTROLLER_PRIMARYAXIS.getCurrentValue() + this.controller.mainDirectionAxis.name()){

            @Override
            public void onClicked(boolean leftSide) {
                switch (((GUISignalController)GUISignalController.this).controller.mainDirectionAxis) {
                    case NORTH: {
                        ((GUISignalController)GUISignalController.this).controller.mainDirectionAxis = ABlockBase.Axis.EAST;
                        break;
                    }
                    case EAST: {
                        ((GUISignalController)GUISignalController.this).controller.mainDirectionAxis = ABlockBase.Axis.NORTHEAST;
                        break;
                    }
                    case NORTHEAST: {
                        ((GUISignalController)GUISignalController.this).controller.mainDirectionAxis = ABlockBase.Axis.NORTHWEST;
                        break;
                    }
                    default: {
                        ((GUISignalController)GUISignalController.this).controller.mainDirectionAxis = ABlockBase.Axis.NORTH;
                    }
                }
                this.text = LanguageSystem.GUI_SIGNALCONTROLLER_PRIMARYAXIS.getCurrentValue() + ((GUISignalController)GUISignalController.this).controller.mainDirectionAxis.name();
                ((GUISignalController)GUISignalController.this).controller.unsavedClientChangesPreset = true;
                GUISignalController.this.controller.initializeController(null);
            }
        };
        this.addComponent(this.directionButton);
        this.laneWidthText = new GUIComponentNumericTextBox(middleObjectOffset + 60, topOffset, "4.0", 40);
        this.addComponent(this.laneWidthText);
        this.addComponent(new GUIComponentLabel(middleObjectOffset, topOffset, ColorRGB.WHITE, LanguageSystem.GUI_SIGNALCONTROLLER_LANEWIDTH.getCurrentValue()).setComponent(this.laneWidthText));
        this.greenMainTimeText = new GUIComponentNumericTextBox(middleObjectOffset, topOffset += 15 + rowSpacing * 3, String.valueOf(this.controller.greenMainTime / 20)){

            @Override
            public void setVariable() {
                ((GUISignalController)GUISignalController.this).controller.greenMainTime = this.getIntegerValue() * 20;
            }
        };
        this.addComponent(this.greenMainTimeText);
        this.addComponent(new GUIComponentLabel(leftTextOffset, topOffset, ColorRGB.WHITE, LanguageSystem.GUI_SIGNALCONTROLLER_GREENMAINTIME.getCurrentValue()).setComponent(this.greenMainTimeText));
        this.greenCrossTimeText = new GUIComponentNumericTextBox(middleObjectOffset, topOffset += 10, String.valueOf(this.controller.greenCrossTime / 20)){

            @Override
            public void setVariable() {
                ((GUISignalController)GUISignalController.this).controller.greenCrossTime = this.getIntegerValue() * 20;
            }
        };
        this.addComponent(this.greenCrossTimeText);
        this.addComponent(new GUIComponentLabel(leftTextOffset, topOffset, ColorRGB.WHITE, LanguageSystem.GUI_SIGNALCONTROLLER_GREENCROSSTIME.getCurrentValue()).setComponent(this.greenCrossTimeText));
        this.yellowMainTimeText = new GUIComponentNumericTextBox(middleObjectOffset, topOffset += 10, String.valueOf(this.controller.yellowMainTime / 20)){

            @Override
            public void setVariable() {
                ((GUISignalController)GUISignalController.this).controller.yellowMainTime = this.getIntegerValue() * 20;
            }
        };
        this.addComponent(this.yellowMainTimeText);
        this.addComponent(new GUIComponentLabel(leftTextOffset, topOffset, ColorRGB.WHITE, LanguageSystem.GUI_SIGNALCONTROLLER_YELLOWMAINTIME.getCurrentValue()).setComponent(this.yellowMainTimeText));
        this.yellowCrossTimeText = new GUIComponentNumericTextBox(middleObjectOffset, topOffset += 10, String.valueOf(this.controller.yellowCrossTime / 20)){

            @Override
            public void setVariable() {
                ((GUISignalController)GUISignalController.this).controller.yellowCrossTime = this.getIntegerValue() * 20;
            }
        };
        this.addComponent(this.yellowCrossTimeText);
        this.addComponent(new GUIComponentLabel(leftTextOffset, topOffset, ColorRGB.WHITE, LanguageSystem.GUI_SIGNALCONTROLLER_YELLOWCROSSTIME.getCurrentValue()).setComponent(this.yellowCrossTimeText));
        this.allRedTimeText = new GUIComponentNumericTextBox(middleObjectOffset, topOffset += 10, String.valueOf(this.controller.allRedTime / 20)){

            @Override
            public void setVariable() {
                ((GUISignalController)GUISignalController.this).controller.allRedTime = this.getIntegerValue() * 20;
            }
        };
        this.addComponent(this.allRedTimeText);
        this.addComponent(new GUIComponentLabel(leftTextOffset, topOffset, ColorRGB.WHITE, LanguageSystem.GUI_SIGNALCONTROLLER_ALLREDTIME.getCurrentValue()).setComponent(this.allRedTimeText));
        this.addComponent(new GUIComponentButton(leftTextOffset, topOffset += 10 + rowSpacing * 4, 100, 20, this.onLaneScreen ? LanguageSystem.GUI_SIGNALCONTROLLER_SIGNALSETTINGS.getCurrentValue() : LanguageSystem.GUI_SIGNALCONTROLLER_LANESETTINGS.getCurrentValue()){

            @Override
            public void onClicked(boolean leftSide) {
                GUISignalController.this.onLaneScreen = !GUISignalController.this.onLaneScreen;
                this.text = GUISignalController.this.onLaneScreen ? LanguageSystem.GUI_SIGNALCONTROLLER_SIGNALSETTINGS.getCurrentValue() : LanguageSystem.GUI_SIGNALCONTROLLER_LANESETTINGS.getCurrentValue();
            }
        });
        this.addComponent(new GUIComponentButton(this.guiLeft + this.getWidth() - 100, topOffset, 80, 20, LanguageSystem.GUI_CONFIRM.getCurrentValue()){

            @Override
            public void onClicked(boolean leftSide) {
                InterfaceManager.packetInterface.sendToServer(new PacketTileEntitySignalControllerChange(GUISignalController.this.controller));
                ((GUISignalController)GUISignalController.this).controller.unsavedClientChangesPreset = false;
                GUISignalController.this.close();
            }
        });
        int baseLeftOffset = 80;
        int incrementalLeftOffset = 40;
        leftTextOffset = this.guiLeft + baseLeftOffset;
        topOffset = this.guiTop + 10;
        this.intersectionPropertyComponents.clear();
        this.upperPropertyLabels.clear();
        this.lowerPropertyLabels.clear();
        for (ABlockBase.Axis axis : ABlockBase.Axis.values()) {
            List<GUIComponentLabel> currentList;
            if (!axis.xzPlanar) continue;
            GUIComponentIntersectionProperties propertiesComponent = new GUIComponentIntersectionProperties(this.guiLeft, this.guiTop, leftTextOffset, topOffset, axis);
            this.intersectionPropertyComponents.add(propertiesComponent);
            if ((leftTextOffset += incrementalLeftOffset) >= this.guiLeft + baseLeftOffset + 4 * incrementalLeftOffset) {
                leftTextOffset = this.guiLeft + baseLeftOffset;
                topOffset += 75;
            }
            List<GUIComponentLabel> list = currentList = axis.blockBased ? this.upperPropertyLabels : this.lowerPropertyLabels;
            if (!currentList.isEmpty()) continue;
            currentList.add(new GUIComponentLabel(this.guiLeft + 10, topOffset + 10, ColorRGB.WHITE, LanguageSystem.GUI_SIGNALCONTROLLER_LEFTLANES.getCurrentValue(), RenderText.TextAlignment.LEFT_ALIGNED, 0.75f));
            currentList.add(new GUIComponentLabel(this.guiLeft + 10, topOffset + 20, ColorRGB.WHITE, LanguageSystem.GUI_SIGNALCONTROLLER_CENTERLANES.getCurrentValue(), RenderText.TextAlignment.LEFT_ALIGNED, 0.75f));
            currentList.add(new GUIComponentLabel(this.guiLeft + 10, topOffset + 30, ColorRGB.WHITE, LanguageSystem.GUI_SIGNALCONTROLLER_RIGHTLANES.getCurrentValue(), RenderText.TextAlignment.LEFT_ALIGNED, 0.75f));
            currentList.add(new GUIComponentLabel(this.guiLeft + 10, topOffset + 40, ColorRGB.WHITE, LanguageSystem.GUI_SIGNALCONTROLLER_ROADWIDTH.getCurrentValue(), RenderText.TextAlignment.LEFT_ALIGNED, 0.75f));
            currentList.add(new GUIComponentLabel(this.guiLeft + 10, topOffset + 50, ColorRGB.WHITE, LanguageSystem.GUI_SIGNALCONTROLLER_CENTERDIST.getCurrentValue(), RenderText.TextAlignment.LEFT_ALIGNED, 0.75f));
            currentList.add(new GUIComponentLabel(this.guiLeft + 10, topOffset + 60, ColorRGB.WHITE, LanguageSystem.GUI_SIGNALCONTROLLER_MEDIANDIST.getCurrentValue(), RenderText.TextAlignment.LEFT_ALIGNED, 0.75f));
            for (GUIComponentLabel label : currentList) {
                this.addComponent(label);
            }
        }
    }

    @Override
    public void setStates() {
        super.setStates();
        this.trafficSignalCount.text = LanguageSystem.GUI_SIGNALCONTROLLER_SCANFOUND.getCurrentValue() + this.controller.componentLocations.size();
        this.scanButton.visible = !this.onLaneScreen;
        this.directionButton.visible = !this.onLaneScreen;
        this.cycleButton.visible = !this.onLaneScreen;
        this.driveSideButton.visible = !this.onLaneScreen;
        this.scanCenterXText.visible = !this.onLaneScreen;
        this.scanCenterZText.visible = !this.onLaneScreen;
        this.scanDistanceText.visible = !this.onLaneScreen;
        this.trafficSignalCount.visible = !this.onLaneScreen;
        this.laneWidthText.visible = !this.onLaneScreen;
        this.greenMainTimeText.visible = !this.onLaneScreen;
        this.greenCrossTimeText.visible = !this.onLaneScreen;
        this.yellowMainTimeText.visible = !this.onLaneScreen;
        this.yellowCrossTimeText.visible = !this.onLaneScreen;
        this.allRedTimeText.visible = !this.onLaneScreen;
        boolean upperLabelsVisible = false;
        boolean lowerLabelsVisible = false;
        for (GUIComponentIntersectionProperties propertyComponent : this.intersectionPropertyComponents) {
            boolean showGroup;
            ((GUIComponentIntersectionProperties)propertyComponent).axisLabel.visible = showGroup = this.onLaneScreen && this.controller.intersectionProperties.get((Object)((Object)((GUIComponentIntersectionProperties)propertyComponent).axis)).isActive;
            ((GUIComponentIntersectionProperties)propertyComponent).leftLaneText.visible = showGroup;
            ((GUIComponentIntersectionProperties)propertyComponent).centerLaneText.visible = showGroup;
            ((GUIComponentIntersectionProperties)propertyComponent).rightLaneText.visible = showGroup;
            ((GUIComponentIntersectionProperties)propertyComponent).roadWidthText.visible = showGroup;
            ((GUIComponentIntersectionProperties)propertyComponent).centerDistanceText.visible = showGroup;
            ((GUIComponentIntersectionProperties)propertyComponent).centerOffsetText.visible = showGroup;
            if (!showGroup) continue;
            if (((GUIComponentIntersectionProperties)propertyComponent).axis.blockBased) {
                upperLabelsVisible = true;
                continue;
            }
            lowerLabelsVisible = true;
        }
        for (GUIComponentLabel label : this.upperPropertyLabels) {
            label.visible = upperLabelsVisible;
        }
        for (GUIComponentLabel label : this.lowerPropertyLabels) {
            label.visible = lowerLabelsVisible;
        }
    }

    @Override
    protected boolean canStayOpen() {
        return super.canStayOpen() && this.controller.isValid;
    }

    private class GUIComponentIntersectionProperties {
        private final ABlockBase.Axis axis;
        private final GUIComponentLabel axisLabel;
        private final GUIComponentTextBox leftLaneText;
        private final GUIComponentTextBox centerLaneText;
        private final GUIComponentTextBox rightLaneText;
        private final GUIComponentTextBox roadWidthText;
        private final GUIComponentTextBox centerDistanceText;
        private final GUIComponentTextBox centerOffsetText;

        private GUIComponentIntersectionProperties(int guiLeft, int guiTop, int leftOffset, int topOffset, final ABlockBase.Axis axis) {
            this.axis = axis;
            TileEntitySignalController.IntersectionProperties properties = ((GUISignalController)GUISignalController.this).controller.intersectionProperties.get((Object)axis);
            this.axisLabel = new GUIComponentLabel(leftOffset, topOffset, ColorRGB.WHITE, axis.name(), RenderText.TextAlignment.LEFT_ALIGNED, axis.blockBased ? 1.0f : 0.65f);
            GUISignalController.this.addComponent(this.axisLabel);
            this.leftLaneText = new GUIComponentNumericTextBox(leftOffset, topOffset + 10, String.valueOf(properties.leftLaneCount)){

                @Override
                public void setVariable() {
                    ((GUISignalController)GUISignalController.this).controller.intersectionProperties.get((Object)((Object)axis)).leftLaneCount = this.getIntegerValue();
                }
            };
            GUISignalController.this.addComponent(this.leftLaneText);
            this.centerLaneText = new GUIComponentNumericTextBox(leftOffset, topOffset + 20, String.valueOf(properties.centerLaneCount)){

                @Override
                public void setVariable() {
                    ((GUISignalController)GUISignalController.this).controller.intersectionProperties.get((Object)((Object)axis)).centerLaneCount = this.getIntegerValue();
                }
            };
            GUISignalController.this.addComponent(this.centerLaneText);
            this.rightLaneText = new GUIComponentNumericTextBox(leftOffset, topOffset + 30, String.valueOf(properties.rightLaneCount)){

                @Override
                public void setVariable() {
                    ((GUISignalController)GUISignalController.this).controller.intersectionProperties.get((Object)((Object)axis)).rightLaneCount = this.getIntegerValue();
                }
            };
            GUISignalController.this.addComponent(this.rightLaneText);
            this.roadWidthText = new GUIComponentNumericTextBox(leftOffset, topOffset + 40, String.valueOf(properties.roadWidth), 40){

                @Override
                public void setVariable() {
                    ((GUISignalController)GUISignalController.this).controller.intersectionProperties.get((Object)((Object)axis)).roadWidth = this.getDoubleValue();
                }
            };
            GUISignalController.this.addComponent(this.roadWidthText);
            this.centerDistanceText = new GUIComponentNumericTextBox(leftOffset, topOffset + 50, String.valueOf(properties.centerDistance), 40){

                @Override
                public void setVariable() {
                    ((GUISignalController)GUISignalController.this).controller.intersectionProperties.get((Object)((Object)axis)).centerDistance = this.getDoubleValue();
                }
            };
            GUISignalController.this.addComponent(this.centerDistanceText);
            this.centerOffsetText = new GUIComponentNumericTextBox(leftOffset, topOffset + 60, String.valueOf(properties.centerOffset), 40){

                @Override
                public void setVariable() {
                    ((GUISignalController)GUISignalController.this).controller.intersectionProperties.get((Object)((Object)axis)).centerOffset = this.getDoubleValue();
                }
            };
            GUISignalController.this.addComponent(this.centerOffsetText);
        }
    }

    private class GUIComponentNumericTextBox
    extends GUIComponentTextBox {
        private final boolean floatingPoint;
        private static final int NUMERIC_HEIGHT = 10;

        public GUIComponentNumericTextBox(int x, int y, String text) {
            super(x, y, 40, 10, text, ColorRGB.WHITE, 5);
            this.floatingPoint = false;
        }

        public GUIComponentNumericTextBox(int x, int y, String text, int width) {
            super(x, y, width, 10, text, ColorRGB.WHITE, 7);
            this.floatingPoint = true;
        }

        @Override
        public void handleTextChange() {
            ((GUISignalController)GUISignalController.this).controller.unsavedClientChangesPreset = true;
            this.setVariable();
            GUISignalController.this.controller.initializeController(null);
        }

        @Override
        public boolean isTextValid(String newText) {
            if (newText.isEmpty()) {
                return true;
            }
            if (this.floatingPoint) {
                return newText.matches("-?\\d+(\\.\\d+)?");
            }
            return newText.matches("\\d+");
        }

        protected void setVariable() {
        }

        protected int getIntegerValue() {
            return this.text.isEmpty() ? 0 : Integer.parseInt(this.text);
        }

        protected double getDoubleValue() {
            return this.text.isEmpty() ? 0.0 : Double.parseDouble(this.text);
        }
    }
}

