/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.EntityInteractResult;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.PartInteractable;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponentItem;
import minecrafttransportsimulator.guis.components.GUIComponentLabel;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.components.AItemPart;
import minecrafttransportsimulator.jsondefs.JSONItem;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packloading.PackParser;
import minecrafttransportsimulator.rendering.RenderText;
import minecrafttransportsimulator.sound.SoundInstance;
import minecrafttransportsimulator.systems.CameraSystem;

public class GUIOverlay
extends AGUIBase {
    private GUIComponentLabel mouseoverLabel;
    private GUIComponentItem scannerItem;
    private final List<String> tooltipText = new ArrayList<String>();

    @Override
    public void setupComponents() {
        super.setupComponents();
        this.mouseoverLabel = new GUIComponentLabel(this.screenWidth / 2, this.screenHeight / 2 + 10, ColorRGB.WHITE, "", RenderText.TextAlignment.CENTERED, 1.0f);
        this.addComponent(this.mouseoverLabel);
        this.scannerItem = new GUIComponentItem(0, this.screenHeight / 4, 6.0f){

            @Override
            public boolean isMouseInBounds(int mouseX, int mouseY) {
                return true;
            }

            @Override
            public void renderTooltip(AGUIBase gui, int mouseX, int mouseY) {
                super.renderTooltip(gui, ((GUIOverlay)GUIOverlay.this).scannerItem.constructedX, ((GUIOverlay)GUIOverlay.this).scannerItem.constructedY + 144);
            }

            @Override
            public List<String> getTooltipText() {
                return GUIOverlay.this.tooltipText;
            }
        };
        this.addComponent(this.scannerItem);
    }

    @Override
    public void setStates() {
        super.setStates();
        IWrapperPlayer player = InterfaceManager.clientInterface.getClientPlayer();
        Point3D startPosition = player.getEyePosition();
        Point3D endPosition = player.getLineOfSight(10.0).add(startPosition);
        EntityInteractResult interactResult = player.getWorld().getMultipartEntityIntersect(startPosition, endPosition);
        this.mouseoverLabel.text = "";
        if (interactResult != null && interactResult.entity instanceof PartInteractable) {
            PartInteractable interactable = (PartInteractable)interactResult.entity;
            if (interactable.tank != null) {
                String fluidName = interactable.tank.getFluid();
                this.mouseoverLabel.text = fluidName.isEmpty() ? String.format("%.1f/%.1fb", interactable.tank.getFluidLevel() / 1000.0, Float.valueOf((float)interactable.tank.getMaxLevel() / 1000.0f)) : String.format("%s: %.1f/%.1fb", InterfaceManager.clientInterface.getFluidName(fluidName), interactable.tank.getFluidLevel() / 1000.0, Float.valueOf((float)interactable.tank.getMaxLevel() / 1000.0f));
            }
        }
        this.scannerItem.stack = null;
        this.tooltipText.clear();
        if (player.isHoldingItemType(JSONItem.ItemComponentType.SCANNER) && interactResult != null && interactResult.entity instanceof AEntityF_Multipart) {
            AEntityF_Multipart multipart = (AEntityF_Multipart)interactResult.entity;
            BoundingBox mousedOverBox = null;
            JSONPartDefinition packVehicleDef = null;
            for (Map.Entry<BoundingBox, JSONPartDefinition> boxEntry : multipart.activePartSlotBoxes.entrySet()) {
                BoundingBox boundingBox = boxEntry.getKey();
                if (boundingBox.getIntersection(startPosition, endPosition) == null || mousedOverBox != null && !(boundingBox.globalCenter.distanceTo(startPosition) < mousedOverBox.globalCenter.distanceTo(startPosition))) continue;
                mousedOverBox = boundingBox;
                packVehicleDef = (JSONPartDefinition)boxEntry.getValue();
            }
            if (mousedOverBox != null) {
                ArrayList<AItemPart> validParts = new ArrayList<AItemPart>();
                for (AItemPack aItemPack : PackParser.getAllPackItems()) {
                    AItemPart part;
                    if (!(aItemPack instanceof AItemPart) || !(part = (AItemPart)aItemPack).isPartValidForPackDef(packVehicleDef, multipart.subDefinition, true)) continue;
                    validParts.add(part);
                }
                this.tooltipText.add("Types: " + packVehicleDef.types.toString());
                this.tooltipText.add("Min/Max: " + packVehicleDef.minValue + "/" + packVehicleDef.maxValue);
                if (packVehicleDef.customTypes != null) {
                    this.tooltipText.add("CustomTypes: " + packVehicleDef.customTypes);
                } else {
                    this.tooltipText.add("CustomTypes: None");
                }
                if (!validParts.isEmpty()) {
                    int cycle = player.isSneaking() ? 30 : 15;
                    AItemPart aItemPart = (AItemPart)validParts.get((int)(multipart.ticksExisted / (long)cycle % (long)validParts.size()));
                    this.tooltipText.add(aItemPart.getItemName());
                    this.scannerItem.stack = aItemPart.getNewStack(null);
                    if (multipart.ticksExisted % (long)cycle == 0L) {
                        InterfaceManager.soundInterface.playQuickSound(new SoundInstance((AEntityB_Existing)multipart, InterfaceManager.coreModID + ":scanner_beep"));
                    }
                }
            }
        }
    }

    @Override
    protected boolean renderBackground() {
        return CameraSystem.customCameraOverlay != null;
    }

    @Override
    protected boolean renderBackgroundFullTexture() {
        return true;
    }

    @Override
    protected boolean canStayOpen() {
        return true;
    }

    @Override
    public boolean capturesPlayer() {
        return false;
    }

    @Override
    public int getWidth() {
        return this.screenWidth;
    }

    @Override
    public int getHeight() {
        return this.screenHeight;
    }

    @Override
    public boolean renderFlushBottom() {
        return true;
    }

    @Override
    public boolean renderTranslucent() {
        return true;
    }

    @Override
    protected String getTexture() {
        return CameraSystem.customCameraOverlay;
    }
}

