/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import minecrafttransportsimulator.entities.instances.EntityInventoryContainer;
import minecrafttransportsimulator.guis.components.GUIComponentButton;
import minecrafttransportsimulator.guis.components.GUIComponentCutout;
import minecrafttransportsimulator.guis.components.GUIComponentItem;
import minecrafttransportsimulator.guis.instances.AGUIInventory;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketPlayerItemTransfer;

public class GUIInventoryContainer
extends AGUIInventory {
    private GUIComponentButton priorRowButton;
    private GUIComponentButton nextRowButton;
    private GUIComponentCutout sliderCutout;
    private final int maxRowIncrements;
    private final EntityInventoryContainer inventory;
    private final boolean isPlayerHolding;
    private int rowOffset;

    public GUIInventoryContainer(EntityInventoryContainer inventory, String texture, boolean isPlayerHolding) {
        super(texture);
        this.inventory = inventory;
        this.isPlayerHolding = isPlayerHolding;
        this.maxRowIncrements = inventory.getSize() > 54 ? (inventory.getSize() - 54) / 9 + 1 : 0;
    }

    @Override
    public void setupComponents() {
        super.setupComponents();
        if (this.maxRowIncrements > 0) {
            this.priorRowButton = new GUIComponentButton(this.guiLeft + 174, this.guiTop + 11, 12, 7, 220, 0, 12, 7){

                @Override
                public void onClicked(boolean leftSide) {
                    --GUIInventoryContainer.this.rowOffset;
                }
            };
            this.addComponent(this.priorRowButton);
            this.nextRowButton = new GUIComponentButton(this.guiLeft + 174, this.guiTop + 112, 12, 7, 232, 0, 12, 7){

                @Override
                public void onClicked(boolean leftSide) {
                    ++GUIInventoryContainer.this.rowOffset;
                }
            };
            this.addComponent(this.nextRowButton);
            this.addComponent(new GUIComponentCutout(this.guiLeft + 173, this.guiTop + 20, 14, 90, 242, 45));
            this.sliderCutout = new GUIComponentCutout(this.guiLeft + 174, this.guiTop + 21, 12, 15, 244, 15);
            this.addComponent(this.sliderCutout);
        }
        int slotsToMake = Math.min(this.inventory.getSize(), 54);
        int inventoryRowOffset = (54 - slotsToMake) * 18 / 9 / 2;
        for (int i = 0; i < slotsToMake; i = (int)((byte)(i + 1))) {
            GUIComponentButton itemButton = new GUIComponentButton(this.guiLeft + 8 + 18 * (i % 9), this.guiTop + 12 + inventoryRowOffset + 18 * (i / 9), true){

                @Override
                public void onClicked(boolean leftSide) {
                    InterfaceManager.packetInterface.sendToServer(new PacketPlayerItemTransfer(GUIInventoryContainer.this.inventory, GUIInventoryContainer.this.player, GUIInventoryContainer.this.interactableSlotButtons.indexOf(this) + 9 * GUIInventoryContainer.this.rowOffset, -1, GUIInventoryContainer.this.isPlayerHolding));
                }
            };
            this.addComponent(itemButton);
            this.interactableSlotButtons.add(itemButton);
            GUIComponentItem itemIcon = new GUIComponentItem(itemButton);
            this.addComponent(itemIcon);
            this.interactableSlotIcons.add(itemIcon);
        }
    }

    @Override
    public void setStates() {
        super.setStates();
        if (this.maxRowIncrements > 0) {
            this.priorRowButton.enabled = this.rowOffset > 0;
            this.nextRowButton.enabled = this.rowOffset < this.maxRowIncrements;
            this.sliderCutout.position.y = -this.sliderCutout.constructedY - 73 * this.rowOffset / this.maxRowIncrements;
        }
        for (int i = 0; i < this.interactableSlotButtons.size(); ++i) {
            int index = i + 9 * this.rowOffset;
            if (this.inventory.getSize() > index) {
                IWrapperItemStack stack = this.inventory.getStack(index);
                ((GUIComponentButton)this.interactableSlotButtons.get((int)i)).visible = true;
                ((GUIComponentButton)this.interactableSlotButtons.get((int)i)).enabled = !stack.isEmpty();
                ((GUIComponentItem)this.interactableSlotIcons.get((int)i)).stack = stack;
                continue;
            }
            ((GUIComponentButton)this.interactableSlotButtons.get((int)i)).visible = false;
            ((GUIComponentItem)this.interactableSlotIcons.get((int)i)).stack = null;
        }
    }

    @Override
    protected void handlePlayerItemClick(int slotClicked) {
        InterfaceManager.packetInterface.sendToServer(new PacketPlayerItemTransfer(this.inventory, this.player, -1, slotClicked, this.isPlayerHolding));
    }

    @Override
    protected boolean canStayOpen() {
        return super.canStayOpen() && this.inventory.isValid;
    }
}

