/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import minecrafttransportsimulator.baseclasses.AnimationSwitchbox;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.baseclasses.TransformationMatrix;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.items.components.AItemPart;
import minecrafttransportsimulator.jsondefs.AJSONPartProvider;
import minecrafttransportsimulator.jsondefs.JSONAnimationDefinition;
import minecrafttransportsimulator.jsondefs.JSONItem;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.jsondefs.JSONSubDefinition;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.packloading.PackResourceLoader;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.LanguageSystem;

public abstract class APart
extends AEntityF_Multipart<JSONPart> {
    public JSONPartDefinition placementDefinition;
    public int placementSlot;
    public AEntityF_Multipart<?> entityOn;
    public AEntityF_Multipart<?> masterEntity;
    public EntityVehicleF_Physics vehicleOn;
    public APart partOn;
    public final List<APart> linkedParts = new ArrayList<APart>();
    public boolean isInvisible = false;
    public boolean isActive = true;
    public boolean isPermanent = false;
    public boolean isMoveable;
    public boolean turnsWithSteer;
    public boolean isSpare;
    public boolean isMirrored;
    private boolean playerHoldingWrenchLastTick;
    private boolean playerHoldingWrench;
    private boolean playerHoldingScrewdriverLastTick;
    private boolean playerHoldingScrewdriver;
    public final Point3D localOffset;
    public final RotationMatrix localOrientation;
    public final RotationMatrix zeroReferenceOrientation;
    public final RotationMatrix prevZeroReferenceOrientation;
    public final Point3D externalAnglesRotated = new Point3D();
    private AnimationSwitchbox placementActiveSwitchbox;
    private AnimationSwitchbox internalActiveSwitchbox;
    private AnimationSwitchbox placementMovementSwitchbox;
    private AnimationSwitchbox internalMovementSwitchbox;
    private static boolean checkingLinkedParts;

    public APart(AEntityF_Multipart<?> entityOn, IWrapperPlayer placingPlayer, JSONPartDefinition placementDefinition, AItemPart item, IWrapperNBT data) {
        super(entityOn.world, placingPlayer, item, data);
        this.localOffset = placementDefinition.pos.copy();
        this.localOrientation = new RotationMatrix();
        this.zeroReferenceOrientation = new RotationMatrix();
        this.prevZeroReferenceOrientation = new RotationMatrix();
        this.position.set(this.localOffset).rotate(entityOn.orientation).add(entityOn.position);
        this.prevPosition.set(this.position);
        this.orientation.set(entityOn.orientation);
        if (placementDefinition.rot != null) {
            this.orientation.multiply(placementDefinition.rot);
        }
        this.prevOrientation.set(this.orientation);
        this.scale.set(entityOn.scale);
        if (placementDefinition.partScale != null) {
            this.scale.multiply(placementDefinition.partScale);
        }
        this.prevScale.set(this.scale);
        this.linkToEntity(entityOn, placementDefinition);
    }

    public void linkToEntity(AEntityF_Multipart<?> entityOn, JSONPartDefinition placementDefinition) {
        this.entityOn = entityOn;
        AEntityF_Multipart<?> parentEntity = entityOn;
        while (parentEntity instanceof APart) {
            parentEntity = ((APart)parentEntity).entityOn;
        }
        this.masterEntity = parentEntity;
        this.vehicleOn = parentEntity instanceof EntityVehicleF_Physics ? (EntityVehicleF_Physics)parentEntity : null;
        this.partOn = entityOn instanceof APart ? (APart)entityOn : null;
        this.placementDefinition = placementDefinition;
        this.placementSlot = ((AJSONPartProvider)entityOn.definition).parts.indexOf(placementDefinition);
        this.turnsWithSteer = placementDefinition.turnsWithSteer || this.partOn != null && this.partOn.turnsWithSteer;
        this.isSpare = placementDefinition.isSpare || this.partOn != null && this.partOn.isSpare;
        this.isMirrored = placementDefinition.isMirrored || this.partOn != null && this.partOn.isMirrored;
        this.animationsInitialized = false;
    }

    @Override
    protected void initializeAnimations() {
        super.initializeAnimations();
        this.isMoveable = false;
        this.placementMovementSwitchbox = null;
        if (this.placementDefinition.animations != null || this.placementDefinition.applyAfter != null) {
            ArrayList<JSONAnimationDefinition> animations = new ArrayList<JSONAnimationDefinition>();
            if (this.placementDefinition.animations != null) {
                animations.addAll(this.placementDefinition.animations);
            }
            this.placementMovementSwitchbox = new AnimationSwitchbox(this.entityOn, animations, this.placementDefinition.applyAfter);
            this.isMoveable = true;
        }
        this.internalMovementSwitchbox = null;
        if (((JSONPart)this.definition).generic.movementAnimations != null) {
            this.internalMovementSwitchbox = new AnimationSwitchbox(this, ((JSONPart)this.definition).generic.movementAnimations, null);
            this.isMoveable = true;
        }
        this.placementActiveSwitchbox = null;
        if (this.placementDefinition.activeAnimations != null) {
            this.placementActiveSwitchbox = new AnimationSwitchbox(this.entityOn, this.placementDefinition.activeAnimations, null);
        }
        this.internalActiveSwitchbox = null;
        if (((JSONPart)this.definition).generic.activeAnimations != null) {
            this.internalActiveSwitchbox = new AnimationSwitchbox(this, ((JSONPart)this.definition).generic.activeAnimations, null);
        }
        if (this.placementDefinition.constantValues != null) {
            this.variables.putAll(this.placementDefinition.constantValues);
        }
    }

    @Override
    public void update() {
        super.update();
        boolean bl = this.isInvisible = this.partOn != null ? this.partOn.isInvisible : false;
        if (this.world.isClient()) {
            this.playerHoldingWrenchLastTick = this.playerHoldingWrench;
            this.playerHoldingScrewdriverLastTick = this.playerHoldingScrewdriver;
            this.playerHoldingWrench = InterfaceManager.clientInterface.getClientPlayer().isHoldingItemType(JSONItem.ItemComponentType.WRENCH);
            this.playerHoldingScrewdriver = InterfaceManager.clientInterface.getClientPlayer().isHoldingItemType(JSONItem.ItemComponentType.SCREWDRIVER);
            if (this.playerHoldingWrenchLastTick ^ this.playerHoldingWrench || this.playerHoldingScrewdriverLastTick ^ this.playerHoldingScrewdriver) {
                this.forceCollisionUpdateThisTick = true;
            }
        }
        boolean bl2 = this.isActive = this.partOn != null ? this.partOn.isActive : true;
        if (this.isActive && this.placementActiveSwitchbox != null) {
            this.isActive = this.placementActiveSwitchbox.runSwitchbox(0.0f, false);
        }
        if (this.isActive && this.internalActiveSwitchbox != null) {
            this.isActive = this.internalActiveSwitchbox.runSwitchbox(0.0f, false);
        }
        if (!this.isActive && this.rider != null) {
            this.removeRider();
        }
        this.motion.set(this.entityOn.motion);
        this.position.set(this.entityOn.position);
        this.orientation.set(this.entityOn.orientation);
        this.localOffset.set(this.placementDefinition.pos);
        this.isPermanent = this.placementDefinition.lockingVariables != null ? !this.isVariableListTrue(this.placementDefinition.lockingVariables) : this.placementDefinition.isPermanent;
        this.prevZeroReferenceOrientation.set(this.zeroReferenceOrientation);
        if (this.partOn != null) {
            this.zeroReferenceOrientation.set(this.partOn.zeroReferenceOrientation);
        } else {
            this.zeroReferenceOrientation.set(this.entityOn.orientation);
        }
        if (this.placementDefinition.rot != null) {
            this.zeroReferenceOrientation.multiply(this.placementDefinition.rot);
        }
        this.localOrientation.setToZero();
        if (!this.isInvisible && this.placementMovementSwitchbox != null) {
            this.isInvisible = !this.placementMovementSwitchbox.runSwitchbox(0.0f, false);
            this.localOffset.transform(this.placementMovementSwitchbox.netMatrix);
            this.localOrientation.multiply(this.placementMovementSwitchbox.rotation);
            this.externalAnglesRotated.set(this.placementMovementSwitchbox.rotation.convertToAngles());
        } else {
            this.externalAnglesRotated.set(0.0, 0.0, 0.0);
        }
        if (this.placementDefinition.rot != null) {
            this.localOrientation.multiply(this.placementDefinition.rot);
        }
        this.scale.set(this.entityOn.scale);
        this.localOffset.multiply(this.scale);
        if (this.placementDefinition.partScale != null) {
            this.scale.multiply(this.placementDefinition.partScale);
        }
        if (this.internalMovementSwitchbox != null) {
            this.isInvisible = !this.internalMovementSwitchbox.runSwitchbox(0.0f, false) || this.isInvisible;
            this.localOffset.add(this.internalMovementSwitchbox.translation.multiply(this.scale).rotate(this.localOrientation));
            this.localOrientation.multiply(this.internalMovementSwitchbox.rotation);
        }
        Point3D localPositionDelta = new Point3D().set(this.localOffset).rotate(this.orientation);
        this.position.add(localPositionDelta);
        this.orientation.multiply(this.localOrientation);
        if (this.partOn != null) {
            this.localOffset.reOrigin(this.partOn.localOrientation).add(this.partOn.localOffset);
        }
        this.boundingBox.widthRadius = this.getWidth() / 2.0 * this.scale.x;
        this.boundingBox.heightRadius = this.getHeight() / 2.0 * this.scale.y;
        this.boundingBox.depthRadius = this.getWidth() / 2.0 * this.scale.z;
    }

    @Override
    public boolean shouldAutomaticallyUpdate() {
        return false;
    }

    @Override
    public boolean requiresDeltaUpdates() {
        return super.requiresDeltaUpdates() || this.entityOn.requiresDeltaUpdates() || this.isMoveable;
    }

    @Override
    protected void updateCollisionBoxes() {
        if (!this.isFake()) {
            super.updateCollisionBoxes();
            this.interactionBoxes.add(this.boundingBox);
            this.damageCollisionBoxes.add(this.boundingBox);
        }
    }

    @Override
    protected void updateEncompassingBox() {
        super.updateEncompassingBox();
        if (this.world.isClient() && !this.canBeClicked()) {
            this.allInteractionBoxes.removeAll(this.interactionBoxes);
            return;
        }
        if (this.world.isClient() && (this.playerHoldingWrench || this.playerHoldingScrewdriver)) {
            if (this.playerHoldingWrench && ((JSONPart)this.definition).generic.mustBeRemovedByScrewdriver || this.playerHoldingScrewdriver && !((JSONPart)this.definition).generic.mustBeRemovedByScrewdriver) {
                this.allInteractionBoxes.removeAll(this.interactionBoxes);
                return;
            }
            for (APart childPart : this.parts) {
                if (childPart.isPermanent || childPart.placementDefinition.allowParentRemoval) continue;
                this.allInteractionBoxes.removeAll(this.interactionBoxes);
                return;
            }
        }
    }

    @Override
    public void attack(Damage damage) {
        if (!this.isPermanent && ((JSONPart)this.definition).generic.canBeRemovedByHand && damage.isHand) {
            IWrapperPlayer player = (IWrapperPlayer)damage.entityResponsible;
            if (this.vehicleOn != null && this.vehicleOn.locked) {
                player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_VEHICLE_LOCKED, new Object[0]));
            } else if (player.getInventory().addStack(this.getStack())) {
                this.entityOn.removePart(this, true, null);
            }
        } else {
            super.attack(damage);
            if (((JSONPart)this.definition).generic.forwardsDamageMultiplier != 0.0) {
                this.masterEntity.attack(new Damage(((JSONPart)this.definition).generic.forwardsDamageMultiplier * damage.amount, null, damage.damgeSource, damage.entityResponsible, damage.language));
            }
            if (this.outOfHealth && ((JSONPart)this.definition).generic.destroyable) {
                this.destroy(damage.box);
                if (((Boolean)ConfigSystem.settings.damage.explosions.value).booleanValue()) {
                    this.world.spawnExplosion(this.position, 1.0, true);
                } else {
                    this.world.spawnExplosion(this.position, 0.0, false);
                }
            }
        }
    }

    @Override
    public void setVariable(String variable, double value) {
        if (variable.startsWith("parent_")) {
            this.entityOn.setVariable(variable.substring("parent_".length()), value);
        } else {
            super.setVariable(variable, value);
        }
    }

    @Override
    public void updatePartList() {
        super.updatePartList();
        this.linkedParts.clear();
        this.addLinkedPartsToList(this.linkedParts, APart.class);
    }

    @Override
    public double getMass() {
        return ((JSONPart)this.definition).generic.mass;
    }

    @Override
    public boolean shouldSavePosition() {
        return false;
    }

    @Override
    public boolean canBeClicked() {
        return this.entityOn.isVariableListTrue(this.placementDefinition.interactableVariables) && this.entityOn.canBeClicked();
    }

    public void updateTone(boolean recursive) {
        if (this.placementDefinition.toneIndex != 0 && this.entityOn.subDefinition.partTones != null && this.entityOn.subDefinition.partTones.size() >= this.placementDefinition.toneIndex) {
            String partTone = this.entityOn.subDefinition.partTones.get(this.placementDefinition.toneIndex - 1);
            for (JSONSubDefinition subDefinition : ((JSONPart)this.definition).definitions) {
                if (!subDefinition.subName.equals(partTone)) continue;
                this.updateSubDefinition(partTone);
                return;
            }
        }
        if (recursive && !this.parts.isEmpty()) {
            for (APart part : this.parts) {
                part.updateTone(true);
            }
        }
    }

    public <PartClass extends APart> void addLinkedPartsToList(List<PartClass> partList, Class<PartClass> partClass) {
        if (this.placementDefinition.linkedParts != null) {
            Iterator<Object> iterator = this.placementDefinition.linkedParts.iterator();
            while (iterator.hasNext()) {
                int partIndex = iterator.next();
                APart partAtIndex = this.entityOn.partsInSlots.get(partIndex - 1);
                if (partClass.isInstance(partAtIndex)) {
                    partList.add(partClass.cast(partAtIndex));
                }
                if (partAtIndex == null) continue;
                for (APart part : partAtIndex.allParts) {
                    if (!partClass.isInstance(part)) continue;
                    partList.add(partClass.cast(part));
                }
            }
        }
        if (((JSONPart)this.definition).generic.forceAllLinks) {
            for (APart part : this.masterEntity.allParts) {
                if (part == this || !partClass.isInstance(part) || partList.contains(part)) continue;
                partList.add(partClass.cast(part));
            }
        }
        for (APart part : this.entityOn.parts) {
            if (part == this || part.placementDefinition.linkedParts == null) continue;
            for (int partIndex : part.placementDefinition.linkedParts) {
                if (partIndex - 1 != this.placementSlot) continue;
                if (partClass.isInstance(part) && !partList.contains(part)) {
                    partList.add(partClass.cast(part));
                    continue;
                }
                for (APart part2 : part.allParts) {
                    if (!partClass.isInstance(part2) || partList.contains(part2)) continue;
                    partList.add(partClass.cast(part2));
                }
            }
        }
        for (APart part : this.masterEntity.allParts) {
            if (part == this || !((JSONPart)part.definition).generic.forceAllLinks || !partClass.isInstance(part) || partList.contains(part)) continue;
            partList.add(partClass.cast(part));
        }
        if (this.partOn != null) {
            for (APart part : this.partOn.linkedParts) {
                if (!partClass.isInstance(part) || partList.contains(part)) continue;
                partList.add(partClass.cast(part));
            }
        }
    }

    public boolean isInLiquid() {
        return this.world.isBlockLiquid(this.position);
    }

    public LanguageSystem.LanguageEntry checkForRemoval() {
        return null;
    }

    public boolean isFake() {
        return false;
    }

    public double getWidth() {
        return ((JSONPart)this.definition).generic.width != 0.0f ? (double)((JSONPart)this.definition).generic.width : 0.75;
    }

    public double getHeight() {
        return ((JSONPart)this.definition).generic.height != 0.0f ? (double)((JSONPart)this.definition).generic.height : 0.75;
    }

    @Override
    public float getLightProvided() {
        return this.entityOn.getLightProvided();
    }

    @Override
    public boolean shouldRenderBeams() {
        return this.entityOn.shouldRenderBeams();
    }

    @Override
    public String getTexture() {
        if (((JSONPart)this.definition).generic.useVehicleTexture) {
            if (this.vehicleOn != null) {
                return this.vehicleOn.getTexture();
            }
            if (((JSONPart)this.definition).generic.benchTexture != null) {
                return PackResourceLoader.getPackResource(this.definition, PackResourceLoader.ResourceType.PNG, ((JSONPart)this.definition).generic.benchTexture);
            }
            return null;
        }
        return super.getTexture();
    }

    @Override
    public boolean renderTextLit() {
        return this.entityOn.renderTextLit();
    }

    @Override
    public double getRawVariableValue(String variable, float partialTicks) {
        int partNumber;
        if (variable.startsWith("parent_")) {
            return this.entityOn.getRawVariableValue(variable.substring("parent_".length()), partialTicks);
        }
        if (((JSONPart)this.definition).parts != null && (partNumber = APart.getVariableNumber(variable)) != -1) {
            return this.getSpecificPartAnimation(variable, partNumber, partialTicks);
        }
        switch (variable) {
            case "part_present": {
                return 1.0;
            }
            case "part_ismirrored": {
                return this.isMirrored ? 1.0 : 0.0;
            }
            case "part_isonfront": {
                return this.placementDefinition.pos.z > 0.0 ? 1.0 : 0.0;
            }
            case "part_isspare": {
                return this.isSpare ? 1.0 : 0.0;
            }
            case "part_onvehicle": {
                return this.vehicleOn != null ? 1.0 : 0.0;
            }
        }
        double value = super.getRawVariableValue(variable, partialTicks);
        if (!Double.isNaN(value)) {
            return value;
        }
        if (!this.linkedParts.isEmpty() && !checkingLinkedParts) {
            checkingLinkedParts = true;
            for (APart part : this.linkedParts) {
                value = part.getRawVariableValue(variable, partialTicks);
                if (Double.isNaN(value)) continue;
                checkingLinkedParts = false;
                return value;
            }
            checkingLinkedParts = false;
        }
        return this.entityOn.getRawVariableValue(variable, partialTicks);
    }

    @Override
    public int getWorldLightValue() {
        return this.masterEntity.worldLightValue;
    }

    @Override
    public boolean disableRendering() {
        return super.disableRendering() || this.isFake() || this.isInvisible;
    }

    @Override
    public void renderBoundingBoxes(TransformationMatrix transform) {
        if (this.canBeClicked()) {
            super.renderBoundingBoxes(transform);
        }
    }
}

