/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.instances;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.BezierCurve;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.baseclasses.TransformationMatrix;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.instances.BlockCollision;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.blocks.tileentities.components.RoadClickData;
import minecrafttransportsimulator.blocks.tileentities.components.RoadLane;
import minecrafttransportsimulator.blocks.tileentities.components.RoadLaneConnection;
import minecrafttransportsimulator.items.instances.ItemRoadComponent;
import minecrafttransportsimulator.jsondefs.JSONRoadComponent;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.packets.instances.PacketTileEntityRoadCollisionUpdate;
import minecrafttransportsimulator.packloading.PackParser;
import minecrafttransportsimulator.rendering.AModelParser;
import minecrafttransportsimulator.rendering.RenderableObject;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.LanguageSystem;

public class TileEntityRoad
extends ATileEntityBase<JSONRoadComponent> {
    public BezierCurve dynamicCurve;
    public final List<RoadLane> lanes = new ArrayList<RoadLane>();
    private boolean isActive;
    public final Map<RoadComponent, ItemRoadComponent> components = new HashMap<RoadComponent, ItemRoadComponent>();
    public final Map<RoadComponent, RenderableObject> componentRenderables = new HashMap<RoadComponent, RenderableObject>();
    public final List<RenderableObject> devRenderables = new ArrayList<RenderableObject>();
    public final List<BoundingBox> blockingBoundingBoxes = new ArrayList<BoundingBox>();
    public final List<Point3D> collisionBlockOffsets;
    public final List<Point3D> collidingBlockOffsets;

    public TileEntityRoad(AWrapperWorld world, Point3D position, IWrapperPlayer placingPlayer, ItemRoadComponent item, IWrapperNBT data) {
        super(world, position, placingPlayer, item, data);
        this.boundingBox.heightRadius = (double)((JSONRoadComponent)this.definition).road.collisionHeight / 16.0 / 2.0;
        this.boundingBox.globalCenter.y += this.boundingBox.heightRadius;
        this.components.put(((JSONRoadComponent)this.definition).road.type, (ItemRoadComponent)this.getStack().getItem());
        if (data != null) {
            this.isActive = data.getBoolean("isActive");
            for (RoadComponent componentType : RoadComponent.values()) {
                String packID = data.getString("packID" + componentType.name());
                if (packID.isEmpty()) continue;
                String systemName = data.getString("systemName" + componentType.name());
                ItemRoadComponent newComponent = (ItemRoadComponent)PackParser.getItem(packID, systemName);
                this.components.put(componentType, newComponent);
            }
            Point3D startingOffset = data.getPoint3d("startingOffset");
            Point3D endingOffset = data.getPoint3d("endingOffset");
            if (!endingOffset.isZero()) {
                this.dynamicCurve = new BezierCurve(startingOffset, endingOffset, new RotationMatrix().setToAngles(data.getPoint3d("startingAngles")), new RotationMatrix().setToAngles(data.getPoint3d("endingAngles")));
            }
            this.collisionBlockOffsets = data.getPoint3dsCompact("collisionBlockOffsets");
            this.collidingBlockOffsets = data.getPoint3dsCompact("collidingBlockOffsets");
        } else {
            this.collisionBlockOffsets = new ArrayList<Point3D>();
            this.collidingBlockOffsets = new ArrayList<Point3D>();
        }
        if (this.isActive()) {
            this.generateLanes(data);
        }
    }

    @Override
    public double getPlacementRotation(IWrapperPlayer player) {
        if (!((JSONRoadComponent)this.definition).road.type.equals((Object)RoadComponent.CORE_DYNAMIC)) {
            int clampAngle = this.getRotationIncrement();
            return Math.round(player.getYaw() / (float)clampAngle) * clampAngle % 360;
        }
        return 0.0;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
        if (active) {
            this.generateLanes(null);
        }
    }

    @Override
    public void remove() {
        super.remove();
        for (RenderableObject object : this.componentRenderables.values()) {
            object.destroy(this);
        }
    }

    @Override
    public void destroy(BoundingBox box) {
        super.destroy(box);
        if (this.isActive) {
            this.setActive(false);
            for (RoadLane lane : this.lanes) {
                lane.removeConnections();
            }
            for (Point3D blockOffset : this.collisionBlockOffsets) {
                Point3D blockLocation = this.position.copy().add(blockOffset);
                if (!(this.world.getBlock(blockLocation) instanceof BlockCollision)) continue;
                this.world.destroyBlock(blockLocation, true);
            }
            for (Iterator<Object> iterator : RoadComponent.values()) {
                if (iterator == ((JSONRoadComponent)this.definition).road.type || !this.components.containsKey(iterator)) continue;
                this.world.spawnItemStack(this.components.get(iterator).getNewStack(null), this.position);
            }
        }
    }

    @Override
    public boolean interact(IWrapperPlayer player) {
        if (!this.isActive) {
            this.spawnCollisionBlocks(player);
            return true;
        }
        return false;
    }

    public RoadClickData getClickData(Point3D blockClicked, boolean curveStart) {
        Point3D blockOffsetClicked = blockClicked.copy().add(0.5, 0.0, 0.5).subtract(this.position);
        boolean clickedStart = blockOffsetClicked.isZero() || this.collisionBlockOffsets.indexOf(blockOffsetClicked) < this.collisionBlockOffsets.size() / 2;
        JSONRoadComponent.JSONLaneSector closestSector = null;
        if (!((JSONRoadComponent)this.definition).road.type.equals((Object)RoadComponent.CORE_DYNAMIC)) {
            double closestSectorDistance = Double.MAX_VALUE;
            for (RoadLane lane : this.lanes) {
                double distanceToSectorStart = lane.curves.get((int)0).startPos.distanceTo(blockClicked);
                if (!(distanceToSectorStart < closestSectorDistance)) continue;
                closestSectorDistance = distanceToSectorStart;
                closestSector = ((JSONRoadComponent)this.definition).road.sectors.get(lane.sectorNumber);
            }
        }
        return new RoadClickData(this, closestSector, clickedStart, curveStart);
    }

    public void generateLanes(IWrapperNBT data) {
        int totalLanes = 0;
        if (((JSONRoadComponent)this.definition).road.type.equals((Object)RoadComponent.CORE_DYNAMIC)) {
            for (int i = 0; i < ((JSONRoadComponent)this.definition).road.laneOffsets.length; ++i) {
                this.lanes.add(new RoadLane(this, 0, i, 0, data != null ? data.getData("lane" + totalLanes) : null));
                ++totalLanes;
            }
        } else {
            for (int i = 0; i < ((JSONRoadComponent)this.definition).road.sectors.size(); ++i) {
                for (int j = 0; j < ((JSONRoadComponent)this.definition).road.sectors.get((int)i).lanes.size(); ++j) {
                    this.lanes.add(new RoadLane(this, i, totalLanes, j, data != null ? data.getData("lane" + totalLanes) : null));
                    ++totalLanes;
                }
            }
        }
    }

    protected Map<Point3D, Integer> generateCollisionPoints() {
        this.collisionBlockOffsets.clear();
        this.collidingBlockOffsets.clear();
        HashMap<Point3D, Integer> collisionHeightMap = new HashMap<Point3D, Integer>();
        if (((JSONRoadComponent)this.definition).road.type.equals((Object)RoadComponent.CORE_DYNAMIC)) {
            Point3D testOffset = new Point3D();
            float segmentDelta = (float)((double)((JSONRoadComponent)this.definition).road.roadWidth / (Math.floor(((JSONRoadComponent)this.definition).road.roadWidth) + 1.0));
            float f = 0.0f;
            while (f < this.dynamicCurve.pathLength) {
                for (float offset = 0.0f; offset <= ((JSONRoadComponent)this.definition).road.roadWidth; offset += segmentDelta) {
                    testOffset.set(offset, 0.0, 0.0).rotate(this.dynamicCurve.getRotationAt(f));
                    this.dynamicCurve.offsetPointByPositionAt(testOffset, f);
                    testOffset.subtract(this.position).add(0.0, (float)((JSONRoadComponent)this.definition).road.collisionHeight / 16.0f, 0.0);
                    Point3D testPoint = new Point3D((int)testOffset.x, (int)Math.floor(testOffset.y), (int)testOffset.z);
                    if (testPoint.isZero() || this.collisionBlockOffsets.contains(testPoint) || this.collidingBlockOffsets.contains(testPoint)) continue;
                    testPoint.add(this.position);
                    if (this.world.isAir(testPoint)) {
                        testPoint.subtract(this.position);
                        int collisionBoxIndex = (int)((testOffset.y - testPoint.y) * 16.0);
                        this.collisionBlockOffsets.add(testPoint);
                        collisionHeightMap.put(testPoint, collisionBoxIndex);
                        continue;
                    }
                    if (this.world.getBlock(testPoint) instanceof BlockCollision) continue;
                    testPoint.subtract(this.position);
                    this.collidingBlockOffsets.add(testPoint);
                }
                f = (float)((double)f + 0.1);
            }
        } else {
            for (JSONRoadComponent.JSONRoadCollisionArea collisionArea : ((JSONRoadComponent)this.definition).road.collisionAreas) {
                for (double x = collisionArea.firstCorner.x + 0.01; x < collisionArea.secondCorner.x + 0.5; x += 0.5) {
                    for (double z = collisionArea.firstCorner.z + 0.01; z < collisionArea.secondCorner.z + 0.5; z += 0.5) {
                        Point3D testPoint = new Point3D(x, collisionArea.firstCorner.y, z).rotate(this.orientation);
                        testPoint.x = (int)testPoint.x;
                        testPoint.z = (int)testPoint.z;
                        if (testPoint.isZero() || this.collisionBlockOffsets.contains(testPoint) || this.collidingBlockOffsets.contains(testPoint)) continue;
                        testPoint.add(this.position);
                        if (this.world.isAir(testPoint)) {
                            testPoint.subtract(this.position);
                            this.collisionBlockOffsets.add(testPoint);
                            collisionHeightMap.put(testPoint, collisionArea.collisionHeight == 16 ? 15 : collisionArea.collisionHeight);
                            continue;
                        }
                        if (this.world.getBlock(testPoint) instanceof BlockCollision) continue;
                        testPoint.subtract(this.position);
                        this.collidingBlockOffsets.add(testPoint);
                    }
                }
            }
        }
        return collisionHeightMap;
    }

    public boolean spawnCollisionBlocks(IWrapperPlayer player) {
        Map<Point3D, Integer> collisionHeightMap = this.generateCollisionPoints();
        if (this.collidingBlockOffsets.isEmpty() || player.isCreative() && player.isOP()) {
            for (Point3D offset : this.collisionBlockOffsets) {
                this.world.setBlock(BlockCollision.blockInstances.get(collisionHeightMap.get(offset)), offset.copy().add(this.position), null, ABlockBase.Axis.UP);
            }
            this.collidingBlockOffsets.clear();
            this.setActive(true);
            InterfaceManager.packetInterface.sendToAllClients(new PacketTileEntityRoadCollisionUpdate(this));
            return true;
        }
        this.collisionBlockOffsets.clear();
        player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_ROAD_BLOCKINGBLOCKS, new Object[0]));
        InterfaceManager.packetInterface.sendToAllClients(new PacketTileEntityRoadCollisionUpdate(this));
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void renderModel(TransformationMatrix transform, boolean blendingEnabled, float partialTicks) {
        if (this.isActive() ^ blendingEnabled) {
            for (RoadComponent component : this.components.keySet()) {
                if (!this.componentRenderables.containsKey((Object)component)) {
                    ItemRoadComponent componentItem = this.components.get((Object)component);
                    switch (component) {
                        case CORE_STATIC: {
                            List<RenderableObject> parsedModel = AModelParser.parseModel(((JSONRoadComponent)componentItem.definition).getModelLocation(componentItem.subDefinition));
                            int totalVertices = 0;
                            for (RenderableObject renderableObject : parsedModel) {
                                totalVertices += renderableObject.vertices.capacity();
                            }
                            FloatBuffer totalModel = FloatBuffer.allocate(totalVertices);
                            for (RenderableObject object : parsedModel) {
                                totalModel.put(object.vertices);
                            }
                            totalModel.flip();
                            this.componentRenderables.put(component, new RenderableObject(component.name(), ((JSONRoadComponent)componentItem.definition).getTextureLocation(componentItem.subDefinition), new ColorRGB(), totalModel, true));
                            break;
                        }
                        case CORE_DYNAMIC: {
                            void var10_19;
                            List<RenderableObject> parsedModel = AModelParser.parseModel(((JSONRoadComponent)componentItem.definition).getModelLocation(componentItem.subDefinition));
                            int totalVertices = 0;
                            for (RenderableObject renderableObject : parsedModel) {
                                totalVertices += renderableObject.vertices.capacity();
                            }
                            FloatBuffer parsedVertices = FloatBuffer.allocate(totalVertices);
                            for (RenderableObject object : parsedModel) {
                                parsedVertices.put(object.vertices);
                            }
                            parsedVertices.flip();
                            boolean bl = false;
                            while (var10_19 < parsedVertices.capacity()) {
                                parsedVertices.put((int)(var10_19 + 5), (float)((double)parsedVertices.get((int)(var10_19 + 5)) - ((JSONRoadComponent)this.definition).road.cornerOffset.x));
                                parsedVertices.put((int)(var10_19 + 7), (float)((double)parsedVertices.get((int)(var10_19 + 7)) - ((JSONRoadComponent)this.definition).road.cornerOffset.z));
                                var10_19 += 8;
                            }
                            Point3D point3D = new Point3D();
                            Point3D priorPosition = new Point3D();
                            Point3D testPoint1 = new Point3D();
                            Point3D testPoint2 = new Point3D();
                            Point3D vertexOffsetPriorLine = new Point3D();
                            Point3D vertexOffsetCurrentLine = new Point3D();
                            Point3D segmentVector = new Point3D();
                            Point3D renderedVertex = new Point3D();
                            float indexDelta = (float)((double)this.dynamicCurve.pathLength / Math.floor(this.dynamicCurve.pathLength / ((JSONRoadComponent)this.definition).road.segmentLength));
                            boolean finalSegment = false;
                            float priorIndex = 0.0f;
                            float currentIndex = 0.0f;
                            ArrayList<float[]> segmentVertices = new ArrayList<float[]>();
                            while (!finalSegment) {
                                if (currentIndex != this.dynamicCurve.pathLength && (double)currentIndex + (double)indexDelta * 1.25 > (double)this.dynamicCurve.pathLength) {
                                    currentIndex = this.dynamicCurve.pathLength;
                                    finalSegment = true;
                                } else {
                                    currentIndex += indexDelta;
                                }
                                this.dynamicCurve.setPointToPositionAt(priorPosition, priorIndex);
                                RotationMatrix priorRotation = this.dynamicCurve.getRotationAt(priorIndex);
                                priorPosition.subtract(this.dynamicCurve.startPos);
                                this.dynamicCurve.setPointToPositionAt(point3D, currentIndex);
                                RotationMatrix rotation = this.dynamicCurve.getRotationAt(currentIndex);
                                point3D.subtract(this.dynamicCurve.startPos);
                                testPoint1.set((double)((JSONRoadComponent)this.definition).road.roadWidth + ((JSONRoadComponent)this.definition).road.cornerOffset.x, 0.0, 0.0);
                                testPoint1.rotate(priorRotation).add(priorPosition);
                                testPoint2.set((double)((JSONRoadComponent)this.definition).road.roadWidth + ((JSONRoadComponent)this.definition).road.cornerOffset.x, 0.0, 0.0);
                                testPoint2.rotate(rotation).add(point3D);
                                if (currentIndex != this.dynamicCurve.pathLength && ((point3D.x - priorPosition.x) * (testPoint2.x - testPoint1.x) < 0.0 || (point3D.z - priorPosition.z) * (testPoint2.z - testPoint1.z) < 0.0)) {
                                    if (!(currentIndex + 3.0f * indexDelta > this.dynamicCurve.pathLength)) continue;
                                    currentIndex = this.dynamicCurve.pathLength - indexDelta;
                                    continue;
                                }
                                for (int i = 0; i < parsedVertices.capacity(); i += 8) {
                                    float[] convertedVertexData = new float[8];
                                    parsedVertices.get(convertedVertexData, 0, 5);
                                    float x = parsedVertices.get();
                                    float y = parsedVertices.get();
                                    float z = parsedVertices.get();
                                    vertexOffsetPriorLine.set(x, y, 0.0);
                                    vertexOffsetPriorLine.rotate(priorRotation).add(priorPosition);
                                    vertexOffsetCurrentLine.set(x, y, 0.0);
                                    vertexOffsetCurrentLine.rotate(rotation).add(point3D);
                                    segmentVector.set(vertexOffsetCurrentLine).subtract(vertexOffsetPriorLine).scale(z / ((JSONRoadComponent)this.definition).road.segmentLength);
                                    renderedVertex.set(vertexOffsetPriorLine).add(segmentVector);
                                    convertedVertexData[5] = (float)renderedVertex.x;
                                    convertedVertexData[6] = (float)renderedVertex.y;
                                    convertedVertexData[7] = (float)renderedVertex.z;
                                    segmentVertices.add(convertedVertexData);
                                }
                                parsedVertices.rewind();
                                priorIndex = currentIndex;
                            }
                            FloatBuffer convertedVertices = FloatBuffer.allocate(segmentVertices.size() * 8);
                            for (float[] segmentVertex : segmentVertices) {
                                convertedVertices.put(segmentVertex);
                            }
                            convertedVertices.flip();
                            this.componentRenderables.put(component, new RenderableObject(component.name(), ((JSONRoadComponent)componentItem.definition).getTextureLocation(componentItem.subDefinition), new ColorRGB(), convertedVertices, true));
                            break;
                        }
                    }
                }
                RenderableObject object = this.componentRenderables.get((Object)component);
                if (this.isActive()) {
                    object.setColor(ColorRGB.WHITE);
                    object.setAlpha(1.0f);
                    object.isTranslucent = false;
                } else {
                    object.setColor(ColorRGB.GREEN);
                    object.setAlpha(0.5f);
                    object.isTranslucent = true;
                }
                if (this.dynamicCurve != null) {
                    object.transform.setTranslation(this.dynamicCurve.startPos.copy().subtract(this.position));
                    object.transform.multiply(transform);
                } else {
                    object.transform.set(transform);
                }
                object.worldLightValue = this.worldLightValue;
                object.render(this);
            }
            if (!this.isActive()) {
                if (this.blockingBoundingBoxes.isEmpty()) {
                    this.blockingBoundingBoxes.add(new BoundingBox(new Point3D(0.0, 0.75, 0.0), 0.15, 0.75, 0.15));
                    for (Point3D location : this.collidingBlockOffsets) {
                        this.blockingBoundingBoxes.add(new BoundingBox(location.copy().add(0.0, 0.55, 0.0), 0.55, 0.55, 0.55));
                    }
                }
                boolean firstBox = true;
                for (BoundingBox blockingBox : this.blockingBoundingBoxes) {
                    if (firstBox) {
                        blockingBox.renderHolographic(transform, blockingBox.globalCenter, ColorRGB.BLUE);
                        firstBox = false;
                        continue;
                    }
                    blockingBox.renderHolographic(transform, blockingBox.globalCenter, ColorRGB.RED);
                }
            }
        }
    }

    @Override
    public void renderBoundingBoxes(TransformationMatrix transform) {
        super.renderBoundingBoxes(transform);
        for (Point3D blockOffset : this.collisionBlockOffsets) {
            ABlockBase block = this.world.getBlock(this.position.copy().add(blockOffset));
            if (!(block instanceof BlockCollision)) continue;
            BoundingBox blockBounds = ((BlockCollision)block).blockBounds;
            blockBounds.renderWireframe(this, transform, blockOffset.copy().add(-0.5, 0.0, -0.5), null);
        }
        if (((Boolean)ConfigSystem.settings.general.devMode.value).booleanValue()) {
            if (this.devRenderables.isEmpty()) {
                TileEntityRoad.generateDevElements(this);
            }
            Point3D invertedPosition = this.position.copy().invert();
            for (RenderableObject renderable : this.devRenderables) {
                renderable.transform.setTranslation(invertedPosition).multiply(transform);
                renderable.render(this);
            }
        }
    }

    private static void generateDevElements(TileEntityRoad road) {
        RoadLane otherLane;
        TileEntityRoad otherRoad;
        RotationMatrix rotation;
        RenderableObject curveObject;
        Point3D point1 = new Point3D();
        Point3D point2 = new Point3D();
        if (road.dynamicCurve != null) {
            curveObject = new RenderableObject(ColorRGB.GREEN, (int)(road.dynamicCurve.pathLength * 10.0f));
            float f = 0.0f;
            while (curveObject.vertices.hasRemaining()) {
                road.dynamicCurve.setPointToPositionAt(point1, f);
                rotation = road.dynamicCurve.getRotationAt(f);
                point2.set(0.0, 1.0, 0.0).rotate(rotation).add(point1);
                curveObject.addLine(point1, point2);
                f = (float)((double)f + 0.1);
            }
            curveObject.vertices.flip();
            road.devRenderables.add(curveObject);
            curveObject = new RenderableObject(ColorRGB.CYAN, (int)(road.dynamicCurve.pathLength * 10.0f));
            f = 0.0f;
            while (curveObject.vertices.hasRemaining()) {
                road.dynamicCurve.setPointToPositionAt(point1, f);
                rotation = road.dynamicCurve.getRotationAt(f);
                point1.set(((JSONRoadComponent)road.definition).road.roadWidth, 0.0, 0.0);
                point2.set(point1).add(0.0, 1.0, 0.0).rotate(rotation);
                point1.rotate(rotation);
                road.dynamicCurve.offsetPointByPositionAt(point1, f);
                road.dynamicCurve.offsetPointByPositionAt(point2, f);
                curveObject.addLine(point1, point2);
                f = (float)((double)f + 0.1);
            }
            curveObject.vertices.flip();
            road.devRenderables.add(curveObject);
        }
        for (RoadLane lane : road.lanes) {
            for (BezierCurve bezierCurve : lane.curves) {
                curveObject = new RenderableObject(ColorRGB.RED, 2);
                rotation = bezierCurve.getRotationAt(0.0f);
                bezierCurve.setPointToPositionAt(point1, 0.0f);
                point2.set(0.0, 3.0, 0.0).rotate(rotation).add(point1);
                curveObject.addLine(point1, point2);
                point1.set(point2);
                rotation = bezierCurve.getRotationAt(1.0f);
                point1.set(0.0, 3.0, 0.0).rotate(rotation);
                bezierCurve.offsetPointByPositionAt(point1, 1.0f);
                curveObject.addLine(point1, point2);
                curveObject.vertices.flip();
                road.devRenderables.add(curveObject);
                curveObject = new RenderableObject(ColorRGB.YELLOW, (int)(bezierCurve.pathLength * 10.0f));
                float f = 0.0f;
                while (curveObject.vertices.hasRemaining()) {
                    bezierCurve.setPointToPositionAt(point1, f);
                    rotation = bezierCurve.getRotationAt(f);
                    point2.set(0.0, 1.0, 0.0).rotate(rotation).add(point1);
                    curveObject.addLine(point1, point2);
                    f = (float)((double)f + 0.1);
                }
                curveObject.vertices.flip();
                road.devRenderables.add(curveObject);
            }
        }
        for (RoadLane lane : road.lanes) {
            for (List list : lane.priorConnections) {
                BezierCurve currentCurve = lane.curves.get(lane.priorConnections.indexOf(list));
                for (RoadLaneConnection priorConnection : list) {
                    otherRoad = (TileEntityRoad)road.world.getTileEntity(priorConnection.tileLocation);
                    if (otherRoad == null || (otherLane = otherRoad.lanes.get(priorConnection.laneNumber)) == null) continue;
                    curveObject = new RenderableObject(ColorRGB.PINK, 3);
                    currentCurve.setPointToPositionAt(point1, 0.5f);
                    rotation = currentCurve.getRotationAt(0.5f);
                    point2.set(0.0, 2.0, 0.0).rotate(rotation).add(point1);
                    curveObject.addLine(point1, point2);
                    curveObject.vertices.flip();
                    road.devRenderables.add(curveObject);
                }
            }
        }
        for (RoadLane lane : road.lanes) {
            for (List list : lane.nextConnections) {
                BezierCurve currentCurve = lane.curves.get(lane.nextConnections.indexOf(list));
                for (RoadLaneConnection nextConnection : list) {
                    otherRoad = (TileEntityRoad)road.world.getTileEntity(nextConnection.tileLocation);
                    if (otherRoad == null || (otherLane = otherRoad.lanes.get(nextConnection.laneNumber)) == null) continue;
                    curveObject = new RenderableObject(ColorRGB.ORANGE, 3);
                    currentCurve.setPointToPositionAt(point1, currentCurve.pathLength - 0.5f);
                    rotation = currentCurve.getRotationAt(currentCurve.pathLength - 0.5f);
                    point2.set(0.0, 2.0, 0.0).rotate(rotation).add(point1);
                    curveObject.addLine(point1, point2);
                    curveObject.vertices.flip();
                    road.devRenderables.add(curveObject);
                }
            }
        }
    }

    @Override
    public IWrapperNBT save(IWrapperNBT data) {
        super.save(data);
        data.setBoolean("isActive", this.isActive);
        for (Map.Entry<RoadComponent, ItemRoadComponent> connectedObjectEntry : this.components.entrySet()) {
            data.setString("packID" + connectedObjectEntry.getKey().name(), ((JSONRoadComponent)connectedObjectEntry.getValue().definition).packID);
            data.setString("systemName" + connectedObjectEntry.getKey().name(), ((JSONRoadComponent)connectedObjectEntry.getValue().definition).systemName);
        }
        if (this.dynamicCurve != null) {
            data.setPoint3d("startingOffset", this.dynamicCurve.startPos);
            data.setPoint3d("endingOffset", this.dynamicCurve.endPos);
            data.setPoint3d("startingAngles", this.dynamicCurve.startRotation.angles);
            data.setPoint3d("endingAngles", this.dynamicCurve.endRotation.angles);
        }
        for (int laneNumber = 0; laneNumber < this.lanes.size(); ++laneNumber) {
            data.setData("lane" + laneNumber, this.lanes.get(laneNumber).getData());
        }
        data.setPoint3dsCompact("collisionBlockOffsets", this.collisionBlockOffsets);
        data.setPoint3dsCompact("collidingBlockOffsets", this.collidingBlockOffsets);
        return data;
    }

    public static enum RoadComponent {
        CORE_STATIC,
        CORE_DYNAMIC;

    }
}

