/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.instances;

import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.blocks.tileentities.components.ITileEntityFluidTankProvider;
import minecrafttransportsimulator.blocks.tileentities.instances.ATileEntityFuelPump;
import minecrafttransportsimulator.entities.instances.AEntityVehicleE_Powered;
import minecrafttransportsimulator.entities.instances.EntityFluidTank;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.instances.ItemDecor;
import minecrafttransportsimulator.items.instances.ItemPartInteractable;
import minecrafttransportsimulator.jsondefs.JSONDecor;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONText;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.packets.instances.PacketTileEntityFuelPumpConnection;
import minecrafttransportsimulator.systems.LanguageSystem;

public class TileEntityFuelPump
extends ATileEntityFuelPump
implements ITileEntityFluidTankProvider {
    private final EntityFluidTank tank;

    public TileEntityFuelPump(AWrapperWorld world, Point3D position, IWrapperPlayer placingPlayer, ItemDecor item, IWrapperNBT data) {
        super(world, position, placingPlayer, item, data);
        this.tank = new EntityFluidTank(world, data != null ? data.getData("tank") : null, ((JSONDecor)this.definition).decor.fuelCapacity){

            @Override
            public double fill(String fluid, double maxAmount, boolean doFill) {
                double amountPurchasedRemaining;
                double amountFilled = maxAmount;
                if (!TileEntityFuelPump.this.isCreative && maxAmount > (amountPurchasedRemaining = (double)TileEntityFuelPump.this.fuelPurchased - TileEntityFuelPump.this.fuelDispensedThisPurchase)) {
                    maxAmount = amountPurchasedRemaining;
                }
                amountFilled = super.fill(fluid, maxAmount, doFill);
                if (doFill) {
                    TileEntityFuelPump.this.fuelDispensedThisPurchase += amountFilled;
                }
                return amountFilled;
            }

            @Override
            public double drain(String fluid, double maxAmount, boolean doDrain) {
                double drained = super.drain(fluid, maxAmount, doDrain);
                TileEntityFuelPump.this.fuelDispensedThisConnection += drained;
                return drained;
            }
        };
        world.addEntity(this.tank);
    }

    @Override
    public boolean interact(IWrapperPlayer player) {
        if (player.getHeldStack().interactWith(this.tank, player)) {
            return true;
        }
        IWrapperItemStack stack = player.getHeldStack();
        AItemBase item = stack.getItem();
        if (item instanceof ItemPartInteractable) {
            ItemPartInteractable interactable = (ItemPartInteractable)item;
            if (((JSONPart)interactable.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.JERRYCAN)) {
                if (this.tank.getFluidLevel() >= 1000.0) {
                    IWrapperNBT data = stack.getData();
                    if (data == null) {
                        data = InterfaceManager.coreInterface.getNewNBTWrapper();
                    }
                    if (data.getString("jerrycanFluid").isEmpty()) {
                        data.setString("jerrycanFluid", this.tank.getFluid());
                        stack.setData(data);
                        this.tank.drain(this.tank.getFluid(), 1000.0, true);
                    }
                }
                return true;
            }
        }
        return super.interact(player);
    }

    @Override
    public void remove() {
        super.remove();
        this.tank.remove();
    }

    @Override
    protected boolean hasFuel() {
        return this.tank.getFluidLevel() > 0.0;
    }

    @Override
    protected AEntityVehicleE_Powered.FuelTankResult checkPump(EntityVehicleF_Physics vehicle) {
        return vehicle.checkFuelTankCompatibility(this.tank.getFluid());
    }

    @Override
    public void fuelVehicle(double amount) {
        if (!this.world.isClient()) {
            if (amount > 0.0 && this.tank.getFluidLevel() > 0.0) {
                double amountToFill = this.connectedVehicle.fuelTank.fill(this.tank.getFluid(), amount, false);
                if (amountToFill > 0.0) {
                    String fluid = this.tank.getFluid();
                    double amountToDrain = this.tank.drain(this.tank.getFluid(), amountToFill, true);
                    this.connectedVehicle.fuelTank.fill(fluid, amountToDrain, true);
                }
            } else {
                this.setConnection(null);
                InterfaceManager.packetInterface.sendToAllClients(new PacketTileEntityFuelPumpConnection(this));
                for (IWrapperPlayer player : this.world.getPlayersWithin(new BoundingBox(this.position, 16.0, 16.0, 16.0))) {
                    player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_FUELPUMP_EMPTY, new Object[0]));
                }
            }
        }
    }

    @Override
    public EntityFluidTank getTank() {
        return this.tank;
    }

    @Override
    public double getRawVariableValue(String variable, float partialTicks) {
        switch (variable) {
            case "fuelpump_active": {
                return this.connectedVehicle != null ? 1.0 : 0.0;
            }
            case "fuelpump_stored": {
                return this.tank.getFluidLevel();
            }
            case "fuelpump_dispensed": {
                return this.fuelDispensedThisConnection;
            }
            case "fuelpump_free": {
                return this.isCreative ? 1.0 : 0.0;
            }
            case "fuelpump_purchased": {
                return this.fuelPurchased;
            }
        }
        return super.getRawVariableValue(variable, partialTicks);
    }

    @Override
    public String getRawTextVariableValue(JSONText textDef, float partialTicks) {
        if (textDef.variableName.equals("fuelpump_fluid")) {
            return this.tank.getFluidLevel() > 0.0 ? InterfaceManager.clientInterface.getFluidName(this.tank.getFluid()) : "";
        }
        return super.getRawTextVariableValue(textDef, partialTicks);
    }

    @Override
    public IWrapperNBT save(IWrapperNBT data) {
        super.save(data);
        data.setData("tank", this.tank.save(InterfaceManager.coreInterface.getNewNBTWrapper()));
        return data;
    }
}

