/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1122;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mcinterface1122.WrapperItemStack;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapper;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.instances.ItemDecor;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.jsondefs.JSONDecor;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packloading.PackMaterialComponent;
import minecrafttransportsimulator.packloading.PackParser;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

@JEIPlugin
public class InterfaceJEI
implements IModPlugin {
    private static final List<BenchRecipeCategory> benchCategories = new ArrayList<BenchRecipeCategory>();

    public void registerCategories(IRecipeCategoryRegistration registry) {
        for (AItemPack<?> packItem : PackParser.getAllPackItems()) {
            if (!(packItem instanceof ItemDecor)) continue;
            ItemDecor benchItem = (ItemDecor)packItem;
            if (((JSONDecor)benchItem.definition).decor.crafting == null) continue;
            ArrayList<PackRecipeWrapper> benchRecipes = new ArrayList<PackRecipeWrapper>();
            for (AItemPack<?> packItemToTest : PackParser.getAllPackItems()) {
                int i;
                if (!packItemToTest.isBenchValid(((JSONDecor)benchItem.definition).decor.crafting)) continue;
                for (i = 0; i < ((AJSONItem)packItemToTest.definition).general.materialLists.size(); ++i) {
                    benchRecipes.add(new PackRecipeWrapper(packItemToTest, i, false));
                }
                if (((AJSONItem)packItemToTest.definition).general.repairMaterialLists == null) continue;
                for (i = 0; i < ((AJSONItem)packItemToTest.definition).general.repairMaterialLists.size(); ++i) {
                    benchRecipes.add(new PackRecipeWrapper(packItemToTest, i, true));
                }
            }
            benchCategories.add(new BenchRecipeCategory(benchItem, benchRecipes, registry.getJeiHelpers().getGuiHelper()));
        }
        registry.addRecipeCategories(benchCategories.toArray(new IRecipeCategory[benchCategories.size()]));
    }

    public void register(IModRegistry registry) {
        for (BenchRecipeCategory benchCategory : benchCategories) {
            registry.addRecipes((Collection)benchCategory.benchRecipes, benchCategory.getUid());
        }
    }

    private static class BenchRecipeCategory
    implements IRecipeCategory<PackRecipeWrapper> {
        private final ItemDecor benchItem;
        private final List<IRecipeWrapper> benchRecipes;
        private final IDrawable background;
        private final IDrawable icon;

        private BenchRecipeCategory(ItemDecor benchItem, List<IRecipeWrapper> benchRecipes, IGuiHelper guiHelper) {
            this.benchItem = benchItem;
            this.benchRecipes = benchRecipes;
            this.background = guiHelper.createDrawable(new ResourceLocation(InterfaceManager.coreModID, "textures/guis/jei_crafting.png"), 0, 0, 134, 97);
            this.icon = guiHelper.createDrawableIngredient((Object)((WrapperItemStack)benchItem.getNewStack(null)).stack);
        }

        public String getUid() {
            return InterfaceManager.coreModID + "." + this.benchItem.getRegistrationName();
        }

        public String getTitle() {
            return this.benchItem.getItemName();
        }

        public String getModName() {
            return PackParser.getPackConfiguration((String)((JSONDecor)this.benchItem.definition).packID).packName;
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return this.icon;
        }

        public void setRecipe(IRecipeLayout recipeLayout, PackRecipeWrapper recipeWrapper, IIngredients ingredients) {
            IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
            guiItemStacks.init(0, false, 58, 70);
            guiItemStacks.set(0, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
            List inputs = ingredients.getInputs(VanillaTypes.ITEM);
            int numRows = 3;
            int numCols = 7;
            for (int i = 0; i < inputs.size() && i < 21; ++i) {
                int xOffset = 5 + 17 * (i % 7);
                int yOffset = 5 + 17 * (i / 7);
                guiItemStacks.init(i + 1, true, xOffset, yOffset);
                guiItemStacks.set(i + 1, (List)inputs.get(i));
            }
        }
    }

    private static class PackRecipeWrapper
    implements IRecipeWrapper {
        private final AItemPack<?> packItem;
        private final int recipeIndex;
        private final boolean forRepair;

        private PackRecipeWrapper(AItemPack<?> packItem, int recipeIndex, boolean forRepair) {
            this.packItem = packItem;
            this.recipeIndex = recipeIndex;
            this.forRepair = forRepair;
        }

        public void getIngredients(IIngredients ingredients) {
            ArrayList inputs = new ArrayList();
            for (PackMaterialComponent component : PackMaterialComponent.parseFromJSON(this.packItem, this.recipeIndex, true, true, this.forRepair, true)) {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (IWrapperItemStack stack : component.possibleItems) {
                    stacks.add(((WrapperItemStack)stack).stack);
                }
                inputs.add(stacks);
            }
            ingredients.setInputLists(VanillaTypes.ITEM, inputs);
            ingredients.setOutput(VanillaTypes.ITEM, (Object)((WrapperItemStack)this.packItem.getNewStack(null)).stack);
        }
    }
}

