/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1122;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcinterface1122.BuilderEntityRenderForwarder;
import mcinterface1122.BuilderGUI;
import mcinterface1122.WrapperItemStack;
import mcinterface1122.WrapperPlayer;
import mcinterface1122.WrapperWorld;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.entities.instances.EntityPlayerGun;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.instances.GUIPackMissing;
import minecrafttransportsimulator.mcinterface.IInterfaceClient;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packloading.PackParser;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.ControlSystem;
import minecrafttransportsimulator.systems.LanguageSystem;
import net.minecraft.block.SoundType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class InterfaceClient
implements IInterfaceClient {
    private static boolean actuallyFirstPerson;
    private static boolean actuallyThirdPerson;
    private static boolean changedCameraState;
    private static boolean changeCameraRequest;
    private static int ticksToCullingWarning;
    private static BuilderEntityRenderForwarder activeFollower;
    private static int ticksSincePlayerJoin;
    private static final Point3D mutablePosition;

    @Override
    public boolean isGamePaused() {
        return Minecraft.func_71410_x().func_147113_T();
    }

    @Override
    public String getLanguageName() {
        return Minecraft.func_71410_x().field_71474_y.field_74363_ab;
    }

    @Override
    public List<String> getAllLanguages() {
        ArrayList<String> list = new ArrayList<String>();
        Minecraft.func_71410_x().func_135016_M().func_135040_d().forEach(language -> list.add(language.func_135034_a()));
        return list;
    }

    @Override
    public String getFluidName(String fluidID) {
        Fluid fluid = FluidRegistry.getFluid((String)fluidID);
        return fluid != null ? new FluidStack(fluid, 1).getLocalizedName() : "INVALID";
    }

    @Override
    public Map<String, String> getAllFluidNames() {
        HashMap<String, String> fluidIDsToNames = new HashMap<String, String>();
        for (String fluidID : FluidRegistry.getRegisteredFluids().keySet()) {
            fluidIDsToNames.put(fluidID, new FluidStack(FluidRegistry.getFluid((String)fluidID), 1).getLocalizedName());
        }
        return fluidIDsToNames;
    }

    @Override
    public boolean isChatOpen() {
        return Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146241_e();
    }

    @Override
    public boolean isGUIOpen() {
        return Minecraft.func_71410_x().field_71462_r != null;
    }

    @Override
    public boolean inFirstPerson() {
        return actuallyFirstPerson;
    }

    @Override
    public boolean inThirdPerson() {
        return actuallyThirdPerson;
    }

    @Override
    public boolean changedCameraState() {
        return changedCameraState && !changeCameraRequest;
    }

    @Override
    public void toggleFirstPerson() {
        changeCameraRequest = true;
    }

    @Override
    public int getCameraDefaultZoom() {
        return 4;
    }

    @Override
    public long getPackedDisplaySize() {
        ScaledResolution screenResolution = new ScaledResolution(Minecraft.func_71410_x());
        return (long)screenResolution.func_78326_a() << 32 | (long)screenResolution.func_78328_b() & 0xFFFFFFFFL;
    }

    @Override
    public float getMouseSensitivity() {
        return Minecraft.func_71410_x().field_71474_y.field_74341_c;
    }

    @Override
    public void setMouseSensitivity(float setting) {
        Minecraft.func_71410_x().field_71474_y.field_74341_c = setting;
    }

    @Override
    public float getFOV() {
        return Minecraft.func_71410_x().field_71474_y.field_74334_X;
    }

    @Override
    public void setFOV(float setting) {
        Minecraft.func_71410_x().field_71474_y.field_74334_X = setting;
    }

    @Override
    public void closeGUI() {
        Minecraft.func_71410_x().func_147108_a(null);
    }

    @Override
    public void setActiveGUI(AGUIBase gui) {
        FMLCommonHandler.instance().showGuiScreen((Object)new BuilderGUI(gui));
    }

    @Override
    public WrapperWorld getClientWorld() {
        return WrapperWorld.getWrapperFor((World)Minecraft.func_71410_x().field_71441_e);
    }

    @Override
    public WrapperPlayer getClientPlayer() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        return WrapperPlayer.getWrapperFor((EntityPlayer)player);
    }

    @Override
    public Point3D getCameraPosition() {
        Vec3d position = ActiveRenderInfo.getCameraPosition();
        mutablePosition.set(position.field_72450_a, position.field_72448_b, position.field_72449_c);
        return mutablePosition;
    }

    @Override
    public void playBlockBreakSound(Point3D position) {
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        if (!Minecraft.func_71410_x().field_71441_e.func_175623_d(pos)) {
            SoundType soundType = Minecraft.func_71410_x().field_71441_e.func_180495_p(pos).func_177230_c().getSoundType(Minecraft.func_71410_x().field_71441_e.func_180495_p(pos), Minecraft.func_71410_x().field_71439_g.field_70170_p, pos, null);
            Minecraft.func_71410_x().field_71441_e.func_184133_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, pos, soundType.func_185845_c(), SoundCategory.BLOCKS, soundType.func_185843_a(), soundType.func_185847_b());
        }
    }

    @Override
    public List<String> getTooltipLines(IWrapperItemStack stack) {
        List tooltipText = ((WrapperItemStack)stack).stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        for (int i = 1; i < tooltipText.size(); ++i) {
            tooltipText.set(i, TextFormatting.GRAY + (String)tooltipText.get(i));
        }
        return tooltipText;
    }

    @SubscribeEvent
    public static void onIVClientTick(TickEvent.ClientTickEvent event) {
        WrapperWorld world;
        IWrapperPlayer player = InterfaceManager.clientInterface.getClientPlayer();
        if (!InterfaceManager.clientInterface.isGamePaused() && player != null && (world = WrapperWorld.getWrapperFor((World)Minecraft.func_71410_x().field_71441_e)) != null) {
            if (event.phase.equals((Object)TickEvent.Phase.START)) {
                world.beginProfiling("MTS_ClientVehicleUpdates", true);
                world.tickAll();
                if (!player.isSpectator()) {
                    ControlSystem.controlGlobal(player);
                    if (((WrapperPlayer)player).player.field_70173_aa % 100 == 0 && !InterfaceManager.clientInterface.isGUIOpen() && !PackParser.arePacksPresent()) {
                        new GUIPackMissing();
                    }
                }
                if (((Boolean)ConfigSystem.settings.general.performModCompatFunctions.value).booleanValue() && InterfaceManager.coreInterface.isModPresent("universaltweaks") && ticksToCullingWarning > 0 && --ticksToCullingWarning == 0) {
                    player.displayChatMessage(LanguageSystem.SYSTEM_DEBUG, "IV HAS DETECTED THAT UNIVERSAL TWEAKS MOD IS PRESENT.  THIS MOD CULLS IV VEHICLES UNLESS \"Entity Desync\" IS SET TO FALSE IN THE UNIVERSAL TWEAKS CONFIG.");
                }
                if (activeFollower != null) {
                    EntityPlayer mcPlayer = ((WrapperPlayer)player).player;
                    if (InterfaceClient.activeFollower.field_70170_p != mcPlayer.field_70170_p || InterfaceClient.activeFollower.playerFollowing != mcPlayer || mcPlayer.field_70128_L || InterfaceClient.activeFollower.field_70128_L || InterfaceClient.activeFollower.idleTickCounter == 20) {
                        activeFollower.func_70106_y();
                        activeFollower = null;
                        ticksSincePlayerJoin = 0;
                    } else {
                        ++InterfaceClient.activeFollower.idleTickCounter;
                    }
                } else if (++ticksSincePlayerJoin == 60) {
                    activeFollower = new BuilderEntityRenderForwarder(((WrapperPlayer)player).player);
                    InterfaceClient.activeFollower.loadedFromSavedNBT = true;
                    world.world.func_72838_d((Entity)activeFollower);
                }
            } else {
                world.beginProfiling("MTS_PlayerGunUpdates", true);
                for (EntityPlayerGun gun : world.getEntitiesOfType(EntityPlayerGun.class)) {
                    gun.update();
                    gun.doPostUpdateLogic();
                }
                changedCameraState = false;
                if (actuallyFirstPerson ^ Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
                    changedCameraState = true;
                    actuallyFirstPerson = Minecraft.func_71410_x().field_71474_y.field_74320_O == 0;
                }
                if (actuallyThirdPerson ^ Minecraft.func_71410_x().field_71474_y.field_74320_O == 1) {
                    changedCameraState = true;
                    boolean bl = actuallyThirdPerson = Minecraft.func_71410_x().field_71474_y.field_74320_O == 1;
                }
                if (changeCameraRequest) {
                    if (actuallyFirstPerson) {
                        Minecraft.func_71410_x().field_71474_y.field_74320_O = 1;
                        actuallyFirstPerson = false;
                        actuallyThirdPerson = true;
                    } else {
                        Minecraft.func_71410_x().field_71474_y.field_74320_O = 0;
                        actuallyFirstPerson = true;
                        actuallyThirdPerson = false;
                    }
                    changeCameraRequest = false;
                }
            }
            world.endProfiling();
        }
    }

    static {
        ticksToCullingWarning = 200;
        mutablePosition = new Point3D();
    }
}

