/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.gui.misc;

import com.feed_the_beast.ftblib.FTBLib;
import com.feed_the_beast.ftblib.lib.config.ConfigInt;
import com.feed_the_beast.ftblib.lib.config.ConfigItemStack;
import com.feed_the_beast.ftblib.lib.config.ConfigNBT;
import com.feed_the_beast.ftblib.lib.config.ConfigString;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.gui.BlankPanel;
import com.feed_the_beast.ftblib.lib.gui.Button;
import com.feed_the_beast.ftblib.lib.gui.GuiBase;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.PanelScrollBar;
import com.feed_the_beast.ftblib.lib.gui.SimpleTextButton;
import com.feed_the_beast.ftblib.lib.gui.TextBox;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetLayout;
import com.feed_the_beast.ftblib.lib.gui.WidgetType;
import com.feed_the_beast.ftblib.lib.gui.WrappedIngredient;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiEditConfigValue;
import com.feed_the_beast.ftblib.lib.gui.misc.IConfigValueEditCallback;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.ItemIcon;
import com.feed_the_beast.ftblib.lib.util.InvUtils;
import com.feed_the_beast.ftblib.lib.util.NBTUtils;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class GuiSelectItemStack
extends GuiBase {
    private static boolean allItems = true;
    private final IOpenableGui callbackGui;
    private final Button buttonCancel;
    private final Button buttonAccept;
    private final Panel panelStacks;
    private final PanelScrollBar scrollBar;
    private TextBox searchBox;
    private ItemStack selected;
    private final boolean single;
    private final Consumer<ItemStack> callback;
    private final Panel tabs;
    private ThreadItemList threadItemList;
    private List<Widget> newStackWidgets;
    public long update = Long.MAX_VALUE;

    public GuiSelectItemStack(IOpenableGui g, ItemStack is, boolean s, Consumer<ItemStack> c) {
        this.setSize(211, 150);
        this.callbackGui = g;
        this.selected = is;
        this.single = s;
        this.callback = c;
        int bsize = this.width / 2 - 10;
        this.buttonCancel = new SimpleTextButton(this, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), Icon.EMPTY){

            @Override
            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                this.onClosed();
                GuiSelectItemStack.this.callbackGui.openGui();
            }

            @Override
            public boolean renderTitleInCenter() {
                return true;
            }
        };
        this.buttonCancel.setPosAndSize(8, this.height - 24, bsize, 16);
        this.buttonAccept = new SimpleTextButton(this, I18n.func_135052_a((String)"gui.accept", (Object[])new Object[0]), Icon.EMPTY){

            @Override
            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                GuiSelectItemStack.this.callbackGui.openGui();
                GuiSelectItemStack.this.callback.accept(GuiSelectItemStack.this.selected);
            }

            @Override
            public boolean renderTitleInCenter() {
                return true;
            }
        };
        this.buttonAccept.setPosAndSize(this.width - bsize - 8, this.height - 24, bsize, 16);
        this.panelStacks = new BlankPanel(this){

            @Override
            public void addWidgets() {
                GuiSelectItemStack.this.update = System.currentTimeMillis() + 200L;
            }

            @Override
            public void drawBackground(Theme theme, int x, int y, int w, int h) {
                theme.drawPanelBackground(x, y, w, h);
            }
        };
        this.panelStacks.setPosAndSize(9, 24, 172, 96);
        this.scrollBar = new PanelScrollBar(this, this.panelStacks);
        this.scrollBar.setCanAlwaysScroll(true);
        this.scrollBar.setScrollStep(20);
        this.searchBox = new TextBox(this){

            @Override
            public void onTextChanged() {
                GuiSelectItemStack.this.panelStacks.refreshWidgets();
            }
        };
        this.searchBox.setPosAndSize(8, 7, this.width - 16, 12);
        this.searchBox.ghostText = I18n.func_135052_a((String)"gui.search_box", (Object[])new Object[0]);
        this.searchBox.setFocused(true);
        this.tabs = new Panel(this){

            @Override
            public void addWidgets() {
                this.add(new ButtonSwitchMode(this));
                this.add(new ButtonEditData(this));
                this.add(new ButtonCount(this));
                this.add(new ButtonMeta(this));
                this.add(new ButtonNBT(this));
                this.add(new ButtonCaps(this));
                this.add(new ButtonDisplayName(this));
            }

            @Override
            public void alignWidgets() {
                for (Widget widget : this.widgets) {
                    widget.setSize(20, 20);
                }
                this.setHeight(this.align(WidgetLayout.VERTICAL));
            }
        };
        this.tabs.setPosAndSize(-19, 8, 20, 0);
        this.threadItemList = new ThreadItemList();
        this.threadItemList.start();
    }

    public GuiSelectItemStack(IOpenableGui g, Consumer<ItemStack> c) {
        this(g, ItemStack.field_190927_a, false, c);
    }

    @Override
    public void addWidgets() {
        this.add(this.tabs);
        this.add(this.panelStacks);
        this.add(this.scrollBar);
        this.add(this.searchBox);
        this.add(this.buttonCancel);
        this.add(this.buttonAccept);
    }

    @Override
    public void onClosed() {
        super.onClosed();
        this.stopSearch();
    }

    private void stopSearch() {
        if (this.threadItemList != null) {
            try {
                this.threadItemList.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.threadItemList = null;
    }

    @Override
    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        long now;
        super.drawBackground(theme, x, y, w, h);
        if (this.newStackWidgets != null) {
            this.panelStacks.widgets.clear();
            this.panelStacks.addAll(this.newStackWidgets);
            this.scrollBar.setPosAndSize(this.panelStacks.posX + this.panelStacks.width + 6, this.panelStacks.posY - 1, 16, this.panelStacks.height + 2);
            this.scrollBar.setValue(0);
            this.scrollBar.setMaxValue(1 + MathHelper.func_76123_f((float)((float)this.panelStacks.widgets.size() / 9.0f)) * 19);
            this.newStackWidgets = null;
        }
        if ((now = System.currentTimeMillis()) >= this.update) {
            this.update = Long.MAX_VALUE;
            this.stopSearch();
            this.threadItemList = new ThreadItemList();
            this.threadItemList.start();
        }
    }

    @Override
    public boolean doesGuiPauseGame() {
        GuiScreen screen = this.getPrevScreen();
        return screen != null && screen.func_73868_f();
    }

    private class ThreadItemList
    extends Thread {
        private final String search;

        public ThreadItemList() {
            super("Item Search Thread");
            this.setDaemon(true);
            this.search = GuiSelectItemStack.this.searchBox.getText().toLowerCase();
        }

        @Override
        public void run() {
            ItemStackButton button;
            ArrayList<ItemStackButton> widgets = new ArrayList<ItemStackButton>();
            NonNullList list = NonNullList.func_191196_a();
            if (allItems) {
                for (Item item : Item.field_150901_e) {
                    item.func_150895_a(CreativeTabs.field_78027_g, list);
                }
                list.add((Object)new ItemStack(Blocks.field_150483_bI));
                list.add((Object)new ItemStack(Blocks.field_180401_cv));
                list.add((Object)new ItemStack(Blocks.field_189881_dj));
            } else {
                for (int i = 0; i < Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70302_i_(); ++i) {
                    ItemStack stack = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70301_a(i);
                    if (stack.func_190926_b()) continue;
                    list.add((Object)stack);
                }
            }
            String mod = "";
            if (this.search.startsWith("@")) {
                mod = this.search.substring(1);
            }
            if ((button = new ItemStackButton(GuiSelectItemStack.this.panelStacks, ItemStack.field_190927_a)).shouldAdd(this.search, mod)) {
                widgets.add(new ItemStackButton(GuiSelectItemStack.this.panelStacks, ItemStack.field_190927_a));
            }
            for (ItemStack stack : list) {
                if (stack.func_190926_b() || !(button = new ItemStackButton(GuiSelectItemStack.this.panelStacks, stack)).shouldAdd(this.search, mod)) continue;
                widgets.add(button);
            }
            for (int i = 0; i < widgets.size(); ++i) {
                ((Widget)widgets.get(i)).setPos(1 + i % 9 * 19, 1 + i / 9 * 19);
            }
            GuiSelectItemStack.this.newStackWidgets = widgets;
        }
    }

    private class ButtonDisplayName
    extends ButtonStackConfig {
        public ButtonDisplayName(Panel panel) {
            super(panel, I18n.func_135052_a((String)"ftblib.select_item.display_name", (Object[])new Object[0]), ItemIcon.getItemIcon(Items.field_151155_ap));
        }

        @Override
        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            new GuiEditConfigValue("name", new ConfigString(GuiSelectItemStack.this.selected.func_82837_s() ? GuiSelectItemStack.this.selected.func_82833_r() : ""), this).openGui();
        }

        @Override
        public void onCallback(ConfigValue value, boolean set) {
            if (set) {
                if (!value.isEmpty()) {
                    GuiSelectItemStack.this.selected.func_151001_c(value.getString());
                } else if (GuiSelectItemStack.this.selected.func_77942_o()) {
                    GuiSelectItemStack.this.selected.func_77978_p().func_74775_l("display").func_82580_o("Name");
                    GuiSelectItemStack.this.selected.func_77982_d(NBTUtils.minimize(GuiSelectItemStack.this.selected.func_77978_p()));
                }
            }
            this.openGui();
        }
    }

    private class ButtonCaps
    extends ButtonStackConfig {
        public ButtonCaps(Panel panel) {
            super(panel, I18n.func_135052_a((String)"ftblib.select_item.caps", (Object[])new Object[0]), ItemIcon.getItemIcon(Blocks.field_150467_bQ));
        }

        @Override
        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            NBTTagCompound nbt = GuiSelectItemStack.this.selected.serializeNBT();
            new GuiEditConfigValue("caps", new ConfigNBT((NBTTagCompound)nbt.func_74781_a("ForgeCaps")), this).openGui();
        }

        @Override
        public void onCallback(ConfigValue value, boolean set) {
            if (set) {
                NBTTagCompound caps = ((ConfigNBT)value).getNBT();
                NBTTagCompound nbt = GuiSelectItemStack.this.selected.serializeNBT();
                if (caps == null) {
                    nbt.func_82580_o("ForgeCaps");
                } else {
                    nbt.func_74782_a("ForgeCaps", (NBTBase)caps);
                }
                GuiSelectItemStack.this.selected = new ItemStack(nbt);
            }
            this.openGui();
        }
    }

    private class ButtonNBT
    extends ButtonStackConfig {
        public ButtonNBT(Panel panel) {
            super(panel, I18n.func_135052_a((String)"ftblib.select_item.nbt", (Object[])new Object[0]), ItemIcon.getItemIcon(Items.field_151057_cb));
        }

        @Override
        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            new GuiEditConfigValue("nbt", new ConfigNBT(GuiSelectItemStack.this.selected.func_77978_p()), this).openGui();
        }

        @Override
        public void onCallback(ConfigValue value, boolean set) {
            if (set) {
                GuiSelectItemStack.this.selected.func_77982_d(((ConfigNBT)value).getNBT());
            }
            this.openGui();
        }
    }

    private class ButtonMeta
    extends ButtonStackConfig {
        public ButtonMeta(Panel panel) {
            super(panel, I18n.func_135052_a((String)"ftblib.select_item.meta", (Object[])new Object[0]), ItemIcon.getItemIcon(new ItemStack(Blocks.field_150417_aV, 1, 2)));
        }

        @Override
        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            new GuiEditConfigValue("meta", new ConfigInt(GuiSelectItemStack.this.selected.func_77960_j(), 0, Short.MAX_VALUE), this).openGui();
        }

        @Override
        public void onCallback(ConfigValue value, boolean set) {
            if (set) {
                GuiSelectItemStack.this.selected.func_77964_b(value.getInt());
            }
            this.openGui();
        }
    }

    private class ButtonCount
    extends ButtonStackConfig {
        public ButtonCount(Panel panel) {
            super(panel, I18n.func_135052_a((String)"ftblib.select_item.count", (Object[])new Object[0]), ItemIcon.getItemIcon(Items.field_151121_aF));
        }

        @Override
        public WidgetType getWidgetType() {
            return GuiSelectItemStack.this.single ? WidgetType.DISABLED : super.getWidgetType();
        }

        @Override
        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            new GuiEditConfigValue("count", new ConfigInt(GuiSelectItemStack.this.selected.func_190916_E(), 1, GuiSelectItemStack.this.selected.func_77976_d()), this).openGui();
        }

        @Override
        public void onCallback(ConfigValue value, boolean set) {
            if (set) {
                GuiSelectItemStack.this.selected.func_190920_e(value.getInt());
            }
            this.openGui();
        }
    }

    private class ButtonEditData
    extends Button
    implements IConfigValueEditCallback {
        public ButtonEditData(Panel panel) {
            super(panel, "", GuiIcons.BUG);
        }

        @Override
        public void drawIcon(Theme theme, int x, int y, int w, int h) {
            GuiHelper.drawItem(GuiSelectItemStack.this.selected, x, y, (double)w / 16.0, (double)h / 16.0, true);
        }

        @Override
        public String getTitle() {
            return GuiSelectItemStack.this.selected.func_82833_r();
        }

        @Override
        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            new GuiEditConfigValue("itemstack", new ConfigItemStack(GuiSelectItemStack.this.selected.func_77946_l(), GuiSelectItemStack.this.single), this).openGui();
        }

        @Override
        public void onCallback(ConfigValue value, boolean set) {
            if (set) {
                GuiSelectItemStack.this.selected = ((ConfigItemStack)value).getStack();
            }
            this.openGui();
        }
    }

    private abstract class ButtonStackConfig
    extends Button
    implements IConfigValueEditCallback {
        public ButtonStackConfig(Panel panel, String title, Icon icon) {
            super(panel, title, icon);
        }

        @Override
        public WidgetType getWidgetType() {
            return GuiSelectItemStack.this.selected.func_190926_b() ? WidgetType.DISABLED : super.getWidgetType();
        }
    }

    private class ButtonSwitchMode
    extends Button {
        private final Icon ICON_ALL;
        private final Icon ICON_INV;

        public ButtonSwitchMode(Panel panel) {
            super(panel);
            this.ICON_ALL = ItemIcon.getItemIcon(Items.field_151111_aL);
            this.ICON_INV = ItemIcon.getItemIcon((Block)Blocks.field_150486_ae);
        }

        @Override
        public void drawIcon(Theme theme, int x, int y, int w, int h) {
            (allItems ? this.ICON_ALL : this.ICON_INV).draw(x, y, w, h);
        }

        @Override
        public String getTitle() {
            return I18n.func_135052_a((String)"ftblib.select_item.list_mode", (Object[])new Object[]{TextFormatting.GRAY + (allItems ? I18n.func_135052_a((String)"ftblib.select_item.list_mode.all", (Object[])new Object[0]) : I18n.func_135052_a((String)"ftblib.select_item.list_mode.inv", (Object[])new Object[0]))}) + TextFormatting.DARK_GRAY + " [" + (((GuiSelectItemStack)GuiSelectItemStack.this).panelStacks.widgets.size() - 1) + "]";
        }

        @Override
        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            allItems = !allItems;
            GuiSelectItemStack.this.panelStacks.refreshWidgets();
        }
    }

    private class ItemStackButton
    extends Button {
        private final ItemStack stack;

        private ItemStackButton(Panel panel, ItemStack is) {
            super(panel, "", GuiIcons.BARRIER);
            this.setSize(18, 18);
            this.stack = is;
            this.title = null;
            this.icon = null;
        }

        public boolean shouldAdd(String search, String mod) {
            if (search.isEmpty()) {
                return true;
            }
            if (!mod.isEmpty()) {
                return this.stack.func_77973_b().getRegistryName().func_110624_b().contains(mod);
            }
            return this.stack.func_82833_r().toLowerCase().contains(search);
        }

        @Override
        public String getTitle() {
            if (this.title == null) {
                this.title = this.stack.func_82833_r();
            }
            return this.title;
        }

        @Override
        public void addMouseOverText(List<String> list) {
        }

        @Override
        public WidgetType getWidgetType() {
            return InvUtils.stacksAreEqual(this.stack, GuiSelectItemStack.this.selected) ? WidgetType.MOUSE_OVER : super.getWidgetType();
        }

        @Override
        public void drawBackground(Theme theme, int x, int y, int w, int h) {
            (this.getWidgetType() == WidgetType.MOUSE_OVER ? Color4I.LIGHT_GREEN.withAlpha(70) : Color4I.BLACK.withAlpha(50)).draw(x, y, w, h);
        }

        @Override
        public void drawIcon(Theme theme, int x, int y, int w, int h) {
            if (this.stack.func_77973_b() == FTBLib.CUSTOM_ICON_ITEM && this.stack.func_77942_o() && !this.stack.func_77978_p().func_74779_i("icon").isEmpty()) {
                Icon.getIcon(this.stack.func_77978_p().func_74779_i("icon")).draw(x, y, w, h);
            } else {
                GuiHelper.drawItem(this.stack, x, y, (double)w / 16.0, (double)h / 16.0, true);
            }
        }

        @Override
        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            GuiSelectItemStack.this.selected = this.stack.func_77946_l();
        }

        @Override
        public Object getIngredientUnderMouse() {
            return new WrappedIngredient(this.stack).tooltip();
        }
    }
}

