/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.command;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import org.dave.compactmachines3.command.CommandBaseExt;
import org.dave.compactmachines3.schema.Schema;
import org.dave.compactmachines3.schema.SchemaRegistry;
import org.dave.compactmachines3.tile.TileEntityMachine;

public class CommandSchemaSet
extends CommandBaseExt {
    public String func_71517_b() {
        return "set";
    }

    @Override
    public boolean isAllowed(EntityPlayer player, boolean creative, boolean isOp) {
        return creative || isOp;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length != 1) {
            throw this.getUsageException(sender);
        }
        String schemaName = args[0];
        if (!SchemaRegistry.instance.hasSchema(schemaName)) {
            throw this.getException(sender, "unknown_schema");
        }
        RayTraceResult rayTraceResult = sender.func_174793_f().func_174822_a(16.0, 0.0f);
        if (rayTraceResult.field_72313_a != RayTraceResult.Type.BLOCK) {
            throw this.getException(sender, "look_at_compact_machine");
        }
        BlockPos pos = rayTraceResult.func_178782_a();
        World world = sender.func_130014_f_();
        TileEntity te = world.func_175625_s(pos);
        if (te == null || !(te instanceof TileEntityMachine)) {
            throw this.getException(sender, "look_at_compact_machine");
        }
        TileEntityMachine machine = (TileEntityMachine)te;
        if (machine.coords != -1) {
            throw this.getException(sender, "machine_is_already_in_use");
        }
        Schema schema = SchemaRegistry.instance.getSchema(schemaName);
        if (machine.getSize() != schema.getSize()) {
            throw this.getException(sender, "machine_size_does_not_match");
        }
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.compactmachines3.schema.set.machine_schema_set_to", new Object[]{schemaName}));
        machine.setSchema(schemaName);
        machine.func_70296_d();
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return SchemaRegistry.instance.getSchemaNames().stream().filter(s -> args.length == 0 || s.startsWith(args[0])).collect(Collectors.toList());
    }
}

