/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads;

import net.blay09.mods.cookingforblockheads.CookingForBlockheads;
import net.blay09.mods.cookingforblockheads.CowJarHandler;
import net.blay09.mods.cookingforblockheads.api.CookingForBlockheadsAPI;
import net.blay09.mods.cookingforblockheads.api.event.FoodRegistryInitEvent;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class IMCHandler {
    private static final NonNullList<ItemStack> imcNonFoodRecipes = NonNullList.func_191196_a();

    public static void handleIMCMessage(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            switch (message.key) {
                case "RegisterTool": {
                    if (message.getMessageType() == ItemStack.class) {
                        CookingForBlockheadsAPI.addToolItem(message.getItemStackValue());
                        break;
                    }
                    CookingForBlockheads.logger.error("IMC API Error: RegisterTool expected message of type ItemStack");
                    break;
                }
                case "RegisterWaterItem": {
                    if (message.getMessageType() == ItemStack.class) {
                        CookingForBlockheadsAPI.addWaterItem(message.getItemStackValue());
                        break;
                    }
                    CookingForBlockheads.logger.error("IMC API Error: RegisterWaterItem expected message of type ItemStack");
                    break;
                }
                case "RegisterMilkItem": {
                    if (message.getMessageType() == ItemStack.class) {
                        CookingForBlockheadsAPI.addMilkItem(message.getItemStackValue());
                        break;
                    }
                    CookingForBlockheads.logger.error("IMC API Error: RegisterMilkItem expected message of type ItemStack");
                    break;
                }
                case "RegisterToast": {
                    ItemStack outputItem;
                    ItemStack inputItem;
                    if (message.getMessageType() == NBTTagCompound.class) {
                        inputItem = new ItemStack(message.getNBTValue().func_74775_l("Input"));
                        outputItem = new ItemStack(message.getNBTValue().func_74775_l("Output"));
                        if (!inputItem.func_190926_b() && !outputItem.func_190926_b()) {
                            CookingForBlockheadsAPI.addToastHandler(inputItem, itemStack -> outputItem);
                            break;
                        }
                        CookingForBlockheads.logger.error("IMC API Error: RegisterToast expected message of type NBT with structure {Input : ItemStack, Output : ItemStack}");
                        break;
                    }
                    CookingForBlockheads.logger.error("IMC API Error: RegisterToast expected message of type NBT");
                    break;
                }
                case "RegisterToastError": {
                    CookingForBlockheads.logger.warn("IMC API Warning: RegisterToastError is no longer supported and will be ignored");
                    break;
                }
                case "RegisterOvenFuel": {
                    ItemStack inputItem;
                    if (message.getMessageType() == NBTTagCompound.class) {
                        inputItem = new ItemStack(message.getNBTValue().func_74775_l("Input"));
                        if (!inputItem.func_190926_b() && message.getNBTValue().func_150297_b("FuelValue", 99)) {
                            CookingForBlockheadsAPI.addOvenFuel(inputItem, message.getNBTValue().func_74762_e("FuelValue"));
                            break;
                        }
                        CookingForBlockheads.logger.error("IMC API Error: RegisterOvenFuel expected message of type NBT with structure {Input : ItemStack, FuelValue : numeric}");
                        break;
                    }
                    CookingForBlockheads.logger.error("IMC API Error: RegisterOvenFuel expected message of type NBT");
                    break;
                }
                case "RegisterOvenRecipe": {
                    ItemStack outputItem;
                    ItemStack inputItem;
                    if (message.getMessageType() == NBTTagCompound.class) {
                        inputItem = new ItemStack(message.getNBTValue().func_74775_l("Input"));
                        outputItem = new ItemStack(message.getNBTValue().func_74775_l("Output"));
                        if (!inputItem.func_190926_b() && !outputItem.func_190926_b()) {
                            CookingForBlockheadsAPI.addOvenRecipe(inputItem, outputItem);
                            break;
                        }
                        CookingForBlockheads.logger.error("IMC API Error: RegisterOvenRecipe expected message of type NBT with structure {Input : ItemStack, Output : ItemStack}");
                        break;
                    }
                    CookingForBlockheads.logger.error("IMC API Error: RegisterOvenRecipe expected message of type NBT");
                    break;
                }
                case "RegisterNonFoodRecipe": {
                    if (message.getMessageType() == ItemStack.class) {
                        imcNonFoodRecipes.add((Object)message.getItemStackValue());
                        break;
                    }
                    CookingForBlockheads.logger.error("IMC API Error: RegisterNonFoodRecipe expected message of type ItemStack");
                    break;
                }
                case "RegisterCowClass": {
                    if (message.getMessageType() == String.class) {
                        try {
                            Class<?> clazz = Class.forName(message.getStringValue());
                            CowJarHandler.registerCowClass(clazz);
                        }
                        catch (ClassNotFoundException e) {
                            CookingForBlockheads.logger.error("Could not register cow class " + message.getStringValue() + ": " + e.getMessage());
                            e.printStackTrace();
                        }
                        break;
                    }
                    CookingForBlockheads.logger.error("IMC API Error: RegisterCowClass expected message of type String");
                }
            }
        }
    }

    @SubscribeEvent
    public void onFoodRegistryInit(FoodRegistryInitEvent event) {
        for (ItemStack itemStack : imcNonFoodRecipes) {
            event.registerNonFoodRecipe(itemStack);
        }
    }
}

