/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.handler.thirst;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import toughasnails.api.TANPotions;
import toughasnails.api.config.GameplayOption;
import toughasnails.api.config.SyncedConfig;
import toughasnails.api.item.ItemDrink;
import toughasnails.api.stat.capability.IThirst;
import toughasnails.api.thirst.ThirstHelper;
import toughasnails.api.thirst.WaterType;
import toughasnails.config.json.DrinkData;
import toughasnails.fluids.blocks.BlockPurifiedWaterFluid;
import toughasnails.handler.PacketHandler;
import toughasnails.init.ModConfig;
import toughasnails.network.message.MessageDrinkWaterInWorld;
import toughasnails.thirst.ThirstHandler;

public class DrinkHandler {
    @SubscribeEvent
    public void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        block4: {
            boolean zeroStack;
            ItemStack stack;
            block7: {
                String registryName;
                EntityPlayer player;
                block5: {
                    ThirstHandler thirstHandler;
                    block6: {
                        if (!(event.getEntityLiving() instanceof EntityPlayer)) break block4;
                        player = (EntityPlayer)event.getEntityLiving();
                        stack = event.getItem();
                        thirstHandler = (ThirstHandler)ThirstHelper.getThirstData(player);
                        if (!thirstHandler.isThirsty()) break block4;
                        zeroStack = false;
                        if (stack.func_190916_E() <= 0) {
                            stack.func_190920_e(1);
                            zeroStack = true;
                        }
                        if (!stack.func_77973_b().equals(Items.field_151068_bn)) break block5;
                        if (!PotionUtils.func_185190_b((ItemStack)stack).isEmpty()) break block6;
                        thirstHandler.addStats(WaterType.NORMAL.getThirst(), WaterType.NORMAL.getHydration());
                        if (!(player.field_70170_p.field_73012_v.nextFloat() < WaterType.NORMAL.getPoisonChance()) || !SyncedConfig.getBooleanValue(GameplayOption.ENABLE_THIRST)) break block7;
                        player.func_70690_d(new PotionEffect(TANPotions.thirst, 600));
                        break block7;
                    }
                    thirstHandler.addStats(4, 0.3f);
                    break block7;
                }
                if (!(stack.func_77973_b() instanceof ItemDrink) && ModConfig.drinkData.containsKey(registryName = stack.func_77973_b().getRegistryName().toString())) {
                    for (DrinkData drinkData : ModConfig.drinkData.get(registryName)) {
                        if (!drinkData.getPredicate().apply(stack)) continue;
                        DrinkHandler.applyDrinkFromData(player, drinkData);
                        break;
                    }
                }
            }
            if (zeroStack) {
                stack.func_190920_e(0);
            }
        }
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (this.canWorldDrink((PlayerInteractEvent)event) && event.getEntityPlayer().func_70093_af()) {
            DrinkHandler.tryDrinkWaterInWorld(event.getEntityPlayer(), true);
        }
    }

    @SubscribeEvent
    public void RightClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
        if (this.canWorldDrink((PlayerInteractEvent)event) && event.getEntityPlayer().func_70093_af()) {
            DrinkHandler.tryDrinkWaterInWorld(event.getEntityPlayer(), true);
        }
    }

    private boolean canWorldDrink(PlayerInteractEvent event) {
        return (SyncedConfig.getBooleanValue(GameplayOption.ENABLE_THIRST_WORLD) || SyncedConfig.getBooleanValue(GameplayOption.ENABLE_THIRST_RAIN)) && EnumHand.MAIN_HAND == event.getHand() && event.getEntityPlayer().func_184614_ca().func_190926_b() && ThirstHelper.getThirstData(event.getEntityPlayer()).getThirst() < 20 && Side.CLIENT == event.getSide();
    }

    public static void tryDrinkWaterInWorld(EntityPlayer player, boolean isClient) {
        TargetWater targetWater = DrinkHandler.getRightClickedWater(player);
        if (null != targetWater) {
            if (isClient) {
                PacketHandler.instance.sendToServer((IMessage)new MessageDrinkWaterInWorld());
                player.func_184185_a(SoundEvents.field_187664_bz, 0.5f, 1.0f);
                player.func_184609_a(EnumHand.MAIN_HAND);
            } else {
                DrinkHandler.applyDrinkFromWaterType(player, targetWater.type);
                if (targetWater.type == WaterType.PURIFIED) {
                    player.field_70170_p.func_175698_g(targetWater.pos);
                }
            }
        }
    }

    private static TargetWater getRightClickedWater(EntityPlayer player) {
        if (SyncedConfig.getBooleanValue(GameplayOption.ENABLE_THIRST_RAIN) && player.field_70170_p.func_175727_C(player.func_180425_c()) && -75.0f > player.field_70125_A && player.field_70170_p.func_175678_i(player.func_180425_c())) {
            return new TargetWater(null, WaterType.RAIN);
        }
        if (SyncedConfig.getBooleanValue(GameplayOption.ENABLE_THIRST_WORLD)) {
            Vec3d vecPlayerOrigin = player.func_174824_e(1.0f);
            Vec3d vecPlayerLook = player.func_70676_i(1.0f);
            double playerReachDistance = player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e() * 0.5;
            Vec3d vecPlayerSee = vecPlayerOrigin.func_72441_c(vecPlayerLook.field_72450_a * playerReachDistance, vecPlayerLook.field_72448_b * playerReachDistance, vecPlayerLook.field_72449_c * playerReachDistance);
            RayTraceResult raytraceResult = player.func_130014_f_().func_147447_a(vecPlayerOrigin, vecPlayerSee, true, false, false);
            if (null != raytraceResult && RayTraceResult.Type.BLOCK == raytraceResult.field_72313_a) {
                Block block = player.func_130014_f_().func_180495_p(raytraceResult.func_178782_a()).func_177230_c();
                if (block instanceof BlockPurifiedWaterFluid) {
                    return new TargetWater(raytraceResult.func_178782_a(), WaterType.PURIFIED);
                }
                if (Blocks.field_150355_j == block) {
                    return new TargetWater(raytraceResult.func_178782_a(), WaterType.NORMAL);
                }
            }
        }
        return null;
    }

    private static void applyDrinkFromData(EntityPlayer player, DrinkData data) {
        DrinkHandler.applyDrink(player, data.getThirstRestored(), data.getHydrationRestored(), data.getPoisonChance());
    }

    private static void applyDrinkFromWaterType(EntityPlayer player, WaterType waterType) {
        DrinkHandler.applyDrink(player, waterType.getThirst(), waterType.getHydration(), waterType.getPoisonChance());
    }

    private static void applyDrink(EntityPlayer player, int thirstRestored, float hydrationRestored, float poisonChance) {
        IThirst thirstStats = ThirstHelper.getThirstData(player);
        thirstStats.addStats(thirstRestored, hydrationRestored);
        if (!player.field_70170_p.field_72995_K && player.field_70170_p.field_73012_v.nextFloat() < poisonChance && SyncedConfig.getBooleanValue(GameplayOption.ENABLE_THIRST)) {
            player.func_70690_d(new PotionEffect(TANPotions.thirst, 600));
        }
    }

    private static class TargetWater {
        final BlockPos pos;
        final WaterType type;

        TargetWater(@Nullable BlockPos pos, WaterType type) {
            this.pos = pos;
            this.type = type;
        }
    }
}

