/*
 * Decompiled with CFR 0.152.
 */
package pcl.OpenFM.player;

import java.io.InputStream;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.decoder.SampleBuffer;
import javazoom.jl.player.advanced.PlaybackEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;
import pcl.OpenFM.OpenFM;
import pcl.OpenFM.player.PlayBackEvent;
import pcl.OpenFM.player.PlaybackListener;

public class MP3Player {
    private Bitstream bitstream;
    private Decoder decoder;
    private IntBuffer buffer;
    private IntBuffer source;
    private PlaybackListener listener;
    private float volume = 0.0f;
    private int posX;
    private int posY;
    private int posZ;
    private World world;
    public InputStream ourStream = null;
    private boolean playing = false;

    public MP3Player(InputStream stream) throws JavaLayerException {
        this.ourStream = stream;
        this.bitstream = new Bitstream(stream);
        this.decoder = new Decoder();
    }

    public void setID(World w, int x, int y, int z) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.world = w;
    }

    private boolean alError() {
        if (AL10.alGetError() != 0) {
            OpenFM.logger.error(String.format("AL10 Error: %d: %s", AL10.alGetError(), AL10.alGetString((int)AL10.alGetError())));
            return true;
        }
        return false;
    }

    public boolean play() throws JavaLayerException {
        return this.play(Integer.MAX_VALUE);
    }

    public boolean play(int frames) throws JavaLayerException {
        boolean ret = true;
        this.source = BufferUtils.createIntBuffer((int)1);
        AL10.alGenSources((IntBuffer)this.source);
        if (this.alError()) {
            this.close();
            return false;
        }
        AL10.alSourcei((int)this.source.get(0), (int)4103, (int)0);
        AL10.alSourcef((int)this.source.get(0), (int)4099, (float)1.0f);
        AL10.alSourcef((int)this.source.get(0), (int)4106, (float)(this.volume * Minecraft.func_71410_x().field_71474_y.func_186711_a(SoundCategory.RECORDS)));
        if (this.alError()) {
            this.close();
            return false;
        }
        this.playing = true;
        if (this.listener != null) {
            this.listener.playbackStarted(this.createEvent(PlaybackEvent.STARTED));
        }
        while (this.playing && ret) {
            ret = this.decodeFrame();
        }
        if (this.playing) {
            while (AL10.alGetSourcei((int)this.source.get(0), (int)4112) == 4114) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.close();
        return ret;
    }

    private void close() {
        this.playing = false;
        if (this.listener != null) {
            this.listener.playbackFinished(this.createEvent(PlaybackEvent.STOPPED));
        }
        if (this.source != null) {
            AL10.alSourceStop((IntBuffer)this.source);
            AL10.alDeleteSources((IntBuffer)this.source);
            this.source = null;
        }
        if (this.buffer != null) {
            AL10.alDeleteBuffers((IntBuffer)this.buffer);
            this.buffer = null;
        }
        try {
            this.bitstream.close();
        }
        catch (BitstreamException bitstreamException) {
            // empty catch block
        }
    }

    protected boolean decodeFrame() throws JavaLayerException {
        try {
            Header h = this.bitstream.readFrame();
            if (h == null) {
                return false;
            }
            SampleBuffer output = (SampleBuffer)this.decoder.decodeFrame(h, this.bitstream);
            short[] samples = output.getBuffer();
            if (this.buffer == null) {
                this.buffer = BufferUtils.createIntBuffer((int)1);
            } else {
                int processed = AL10.alGetSourcei((int)this.source.get(0), (int)4118);
                if (processed > 0) {
                    AL10.alSourceUnqueueBuffers((int)this.source.get(0), (IntBuffer)this.buffer);
                }
            }
            AL10.alGenBuffers((IntBuffer)this.buffer);
            ShortBuffer data = (ShortBuffer)BufferUtils.createShortBuffer((int)output.getBufferLength()).put(samples, 0, output.getBufferLength()).flip();
            AL10.alBufferData((int)this.buffer.get(0), (int)(output.getChannelCount() > 1 ? 4355 : 4353), (ShortBuffer)data, (int)output.getSampleFrequency());
            AL10.alSourceQueueBuffers((int)this.source.get(0), (IntBuffer)this.buffer);
            int state = AL10.alGetSourcei((int)this.source.get(0), (int)4112);
            if (this.playing && state != 4114) {
                AL10.alSourcePlay((int)this.source.get(0));
            }
            this.bitstream.closeFrame();
        }
        catch (RuntimeException ex) {
            this.close();
            throw new JavaLayerException("Exception decoding audio frame", ex);
        }
        return true;
    }

    protected boolean skipFrame() throws JavaLayerException {
        Header h = this.bitstream.readFrame();
        if (h == null) {
            return false;
        }
        this.bitstream.closeFrame();
        return true;
    }

    public boolean play(int start, int end) throws JavaLayerException {
        boolean ret = true;
        int offset = start;
        while (offset-- > 0 && ret) {
            ret = this.skipFrame();
        }
        return this.play(end - start);
    }

    private PlayBackEvent createEvent(int id) {
        return new PlayBackEvent(this, id, 0);
    }

    public void setPlayBackListener(PlaybackListener listener) {
        this.listener = listener;
    }

    public PlaybackListener getPlayBackListener() {
        return this.listener;
    }

    public void stop() {
        this.playing = false;
        if (this.source != null) {
            AL10.alSourcef((int)this.source.get(0), (int)4106, (float)0.0f);
            AL10.alSourceStop((IntBuffer)this.source);
        }
    }

    public void setVolume(float f) {
        this.volume = f;
        if (this.playing && this.source != null) {
            AL10.alSourcef((int)this.source.get(0), (int)4106, (float)(f * Minecraft.func_71410_x().field_71474_y.func_186711_a(SoundCategory.RECORDS)));
        }
    }

    public float getVolume() {
        return this.volume;
    }
}

