/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.jei;

import com.silvaniastudios.roads.RoadsConfig;
import com.silvaniastudios.roads.blocks.FRBlocks;
import com.silvaniastudios.roads.jei.RoadFactoryWrapper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class RoadFactoryCategory
implements IRecipeCategory<RoadFactoryWrapper> {
    private final IDrawable background;
    private final IDrawable electric_bar;
    private final IDrawable icon;
    private final IDrawableAnimated progressBar;
    private final IDrawable tankCover;
    public static final int width = 162;
    public static final int height = 112;
    private boolean electric = false;
    private String uid;

    public RoadFactoryCategory(IGuiHelper guiHelper, String uid, boolean electric) {
        ResourceLocation guiTexture = new ResourceLocation("furenikusroads:textures/gui/jei_texture_2.png");
        this.background = guiHelper.createDrawable(guiTexture, 0, 0, 162, 112);
        this.electric_bar = guiHelper.createDrawable(guiTexture, 164, 0, 18, 112);
        this.icon = electric ? guiHelper.createDrawableIngredient((Object)new ItemStack((Block)FRBlocks.road_factory_electric)) : guiHelper.createDrawableIngredient((Object)new ItemStack((Block)FRBlocks.road_factory));
        int progressTick = electric ? RoadsConfig.machine.electricRoadFactoryTickRate : RoadsConfig.machine.roadFactoryTickRate;
        this.progressBar = guiHelper.createAnimatedDrawable(guiHelper.createDrawable(guiTexture, 0, 252, 160, 4), progressTick, IDrawableAnimated.StartDirection.LEFT, false);
        this.electric = electric;
        this.uid = uid;
        this.tankCover = guiHelper.createDrawable(guiTexture, 236, 0, 20, 100);
    }

    public String getUid() {
        return this.uid;
    }

    public String getTitle() {
        if (this.electric) {
            return I18n.func_135052_a((String)"roads.gui.electric_road_factory.name", (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)"roads.gui.road_factory.name", (Object[])new Object[0]);
    }

    public String getModName() {
        return "Fureniku's Roads";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        if (this.electric) {
            this.electric_bar.draw(minecraft, 144, 0);
        }
        this.progressBar.draw(minecraft, 1, 107);
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayout recipeLayout, RoadFactoryWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup itemStack = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluidStack = recipeLayout.getFluidStacks();
        itemStack.init(0, true, 26, 12);
        itemStack.init(11, true, 74, 35);
        itemStack.init(4, false, 99, 12);
        fluidStack.init(12, true, 1, 1, 20, 100, 320000, true, this.tankCover);
        itemStack.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        itemStack.set(11, (List)ingredients.getInputs(VanillaTypes.ITEM).get(1));
        fluidStack.set(12, (List)ingredients.getInputs(VanillaTypes.FLUID).get(0));
        itemStack.set(4, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }
}

