/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.jei;

import com.silvaniastudios.roads.RoadsConfig;
import com.silvaniastudios.roads.blocks.FRBlocks;
import com.silvaniastudios.roads.jei.PaintOvenWrapper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class PaintOvenCategory
implements IRecipeCategory<PaintOvenWrapper> {
    private final IDrawable background;
    private final IDrawable electric_bar;
    private final IDrawable icon;
    private final IDrawableAnimated progressBar;
    private final IDrawable tankCover;
    public static final int width = 184;
    public static final int height = 62;
    private boolean electric = false;
    private String uid;

    public PaintOvenCategory(IGuiHelper guiHelper, String uid, boolean electric) {
        ResourceLocation guiTexture = new ResourceLocation("furenikusroads:textures/gui/jei_texture_1.png");
        this.background = guiHelper.createDrawable(guiTexture, 0, 162, 184, 62);
        this.electric_bar = guiHelper.createDrawable(guiTexture, 186, 162, 18, 42);
        this.icon = electric ? guiHelper.createDrawableIngredient((Object)new ItemStack((Block)FRBlocks.paint_oven_electric)) : guiHelper.createDrawableIngredient((Object)new ItemStack((Block)FRBlocks.paint_oven));
        int progressTick = electric ? RoadsConfig.machine.electricPaintOvenTickRate : RoadsConfig.machine.paintOvenTickRate;
        this.progressBar = guiHelper.createAnimatedDrawable(guiHelper.createDrawable(guiTexture, 0, 252, 160, 4), progressTick, IDrawableAnimated.StartDirection.LEFT, false);
        this.electric = electric;
        this.uid = uid;
        this.tankCover = guiHelper.createDrawable(guiTexture, 196, 0, 60, 50);
    }

    public String getUid() {
        return this.uid;
    }

    public String getTitle() {
        if (this.electric) {
            return I18n.func_135052_a((String)"roads.gui.electric_paint_oven.name", (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)"roads.gui.paint_oven.name", (Object[])new Object[0]);
    }

    public String getModName() {
        return "Fureniku's Roads";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        if (this.electric) {
            this.electric_bar.draw(minecraft, 166, 0);
        }
        this.progressBar.draw(minecraft, 1, 57);
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayout recipeLayout, PaintOvenWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiStack = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluidStack = recipeLayout.getFluidStacks();
        guiStack.init(0, true, 72, 17);
        fluidStack.init(3, true, 1, 1, 60, 50, 64000, true, this.tankCover);
        fluidStack.init(4, false, 101, 1, 60, 50, 64000, true, this.tankCover);
        guiStack.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        fluidStack.set(3, (List)ingredients.getInputs(VanillaTypes.FLUID).get(0));
        fluidStack.set(4, (List)ingredients.getOutputs(VanillaTypes.FLUID).get(0));
    }
}

