/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.jei;

import com.silvaniastudios.roads.RoadsConfig;
import com.silvaniastudios.roads.blocks.FRBlocks;
import com.silvaniastudios.roads.blocks.tileentities.recipes.CompactorRecipes;
import com.silvaniastudios.roads.blocks.tileentities.recipes.CrusherRecipes;
import com.silvaniastudios.roads.blocks.tileentities.recipes.FabricatorRecipes;
import com.silvaniastudios.roads.blocks.tileentities.recipes.RecipeRegistry;
import com.silvaniastudios.roads.blocks.tileentities.recipes.RoadFactoryRecipes;
import com.silvaniastudios.roads.blocks.tileentities.recipes.TarDistillerRecipes;
import com.silvaniastudios.roads.fluids.FRFluids;
import com.silvaniastudios.roads.items.FRItems;
import com.silvaniastudios.roads.jei.CompactorCategory;
import com.silvaniastudios.roads.jei.CompactorWrapper;
import com.silvaniastudios.roads.jei.CrusherCategory;
import com.silvaniastudios.roads.jei.CrusherWrapper;
import com.silvaniastudios.roads.jei.FabricatorCategory;
import com.silvaniastudios.roads.jei.FabricatorWrapper;
import com.silvaniastudios.roads.jei.PaintOvenCategory;
import com.silvaniastudios.roads.jei.PaintOvenWrapper;
import com.silvaniastudios.roads.jei.RoadFactoryCategory;
import com.silvaniastudios.roads.jei.RoadFactoryWrapper;
import com.silvaniastudios.roads.jei.TarDistillerCategory;
import com.silvaniastudios.roads.jei.TarDistillerWrapper;
import com.silvaniastudios.roads.jei.TarmacCutterCategory;
import com.silvaniastudios.roads.jei.TarmacCutterWrapper;
import java.util.ArrayList;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

@JEIPlugin
public class FRJEIPlugin
implements IModPlugin {
    public void register(IModRegistry registry) {
        registry.addRecipes(this.roadFactoryRecipes(), "fr_road_factory");
        registry.addRecipes(this.tarDistillerRecipes(), "fr_tar_distiller");
        registry.addRecipes(this.tarmacCutterRecipes(), "fr_tarmac_cutter");
        registry.addRecipes(this.crusherRecipes(), "fr_crusher");
        registry.addRecipes(this.paintOvenRecipes(), "fr_paint_oven");
        registry.addRecipes(this.compactorRecipes(), "fr_compactor");
        registry.addRecipes(this.fabricatorRecipes(), "fr_fabricator");
        registry.addRecipes(this.roadFactoryRecipes(), "fr_electric_road_factory");
        registry.addRecipes(this.tarDistillerRecipes(), "fr_electric_tar_distiller");
        registry.addRecipes(this.tarmacCutterRecipes(), "fr_electric_tarmac_cutter");
        registry.addRecipes(this.crusherRecipes(), "fr_electric_crusher");
        registry.addRecipes(this.paintOvenRecipes(), "fr_electric_paint_oven");
        registry.addRecipes(this.compactorRecipes(), "fr_electric_compactor");
        registry.addRecipes(this.fabricatorRecipes(), "fr_electric_fabricator");
        if (RoadsConfig.general.hideJEIPaints) {
            this.blacklistedIngredients(registry.getJeiHelpers().getIngredientBlacklist());
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new RoadFactoryCategory(registry.getJeiHelpers().getGuiHelper(), "fr_road_factory", false)});
        registry.addRecipeCategories(new IRecipeCategory[]{new TarDistillerCategory(registry.getJeiHelpers().getGuiHelper(), "fr_tar_distiller", false)});
        registry.addRecipeCategories(new IRecipeCategory[]{new TarmacCutterCategory(registry.getJeiHelpers().getGuiHelper(), "fr_tarmac_cutter", false)});
        registry.addRecipeCategories(new IRecipeCategory[]{new CrusherCategory(registry.getJeiHelpers().getGuiHelper(), "fr_crusher", false)});
        registry.addRecipeCategories(new IRecipeCategory[]{new PaintOvenCategory(registry.getJeiHelpers().getGuiHelper(), "fr_paint_oven", false)});
        registry.addRecipeCategories(new IRecipeCategory[]{new CompactorCategory(registry.getJeiHelpers().getGuiHelper(), "fr_compactor", false)});
        registry.addRecipeCategories(new IRecipeCategory[]{new FabricatorCategory(registry.getJeiHelpers().getGuiHelper(), "fr_fabricator", false)});
        registry.addRecipeCategories(new IRecipeCategory[]{new RoadFactoryCategory(registry.getJeiHelpers().getGuiHelper(), "fr_electric_road_factory", true)});
        registry.addRecipeCategories(new IRecipeCategory[]{new TarDistillerCategory(registry.getJeiHelpers().getGuiHelper(), "fr_electric_tar_distiller", true)});
        registry.addRecipeCategories(new IRecipeCategory[]{new TarmacCutterCategory(registry.getJeiHelpers().getGuiHelper(), "fr_electric_tarmac_cutter", true)});
        registry.addRecipeCategories(new IRecipeCategory[]{new CrusherCategory(registry.getJeiHelpers().getGuiHelper(), "fr_electric_crusher", true)});
        registry.addRecipeCategories(new IRecipeCategory[]{new PaintOvenCategory(registry.getJeiHelpers().getGuiHelper(), "fr_electric_paint_oven", true)});
        registry.addRecipeCategories(new IRecipeCategory[]{new CompactorCategory(registry.getJeiHelpers().getGuiHelper(), "fr_electric_compactor", true)});
        registry.addRecipeCategories(new IRecipeCategory[]{new FabricatorCategory(registry.getJeiHelpers().getGuiHelper(), "fr_electric_fabricator", true)});
    }

    private void blacklistedIngredients(IIngredientBlacklist blacklist) {
        for (int i = 0; i < FRBlocks.paintBlockList.size(); ++i) {
            blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)FRBlocks.paintBlockList.get(i), 1));
        }
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)FRBlocks.road_snow));
    }

    private ArrayList<PaintOvenWrapper> paintOvenRecipes() {
        ArrayList<PaintOvenWrapper> recipes = new ArrayList<PaintOvenWrapper>();
        recipes.add(new PaintOvenWrapper(new ItemStack(Items.field_151100_aR, 1, 15), new FluidStack(FluidRegistry.WATER, 1000), new FluidStack((Fluid)FRFluids.white_paint, 1000)));
        recipes.add(new PaintOvenWrapper(new ItemStack(Items.field_151100_aR, 1, 11), new FluidStack(FluidRegistry.WATER, 1000), new FluidStack((Fluid)FRFluids.yellow_paint, 1000)));
        recipes.add(new PaintOvenWrapper(new ItemStack(Items.field_151100_aR, 1, 1), new FluidStack(FluidRegistry.WATER, 1000), new FluidStack((Fluid)FRFluids.red_paint, 1000)));
        return recipes;
    }

    private ArrayList<CompactorWrapper> compactorRecipes() {
        ArrayList<CompactorWrapper> recipes = new ArrayList<CompactorWrapper>();
        for (int i = 0; i < RecipeRegistry.compactorRecipes.size(); ++i) {
            CompactorRecipes cr = RecipeRegistry.compactorRecipes.get(i);
            for (int j = 0; j < 16; ++j) {
                recipes.add(new CompactorWrapper(new ItemStack(cr.getInputStack().func_77973_b(), j + 1), new ItemStack(cr.getOutputStack().func_77973_b(), 1, j)));
            }
        }
        return recipes;
    }

    private ArrayList<FabricatorWrapper> fabricatorRecipes() {
        ArrayList<FabricatorWrapper> recipes = new ArrayList<FabricatorWrapper>();
        for (int i = 0; i < RecipeRegistry.fabricatorRecipes.size(); ++i) {
            FabricatorRecipes fr = RecipeRegistry.fabricatorRecipes.get(i);
            recipes.add(new FabricatorWrapper(fr.getInput1(), fr.getInput2(), fr.getInput3(), fr.getInput4(), fr.getInput5(), fr.getInput6(), fr.getOutput()));
        }
        return recipes;
    }

    private ArrayList<RoadFactoryWrapper> roadFactoryRecipes() {
        ArrayList<RoadFactoryWrapper> recipes = new ArrayList<RoadFactoryWrapper>();
        for (int i = 0; i < RecipeRegistry.roadFactoryRecipes.size(); ++i) {
            RoadFactoryRecipes rfr = RecipeRegistry.roadFactoryRecipes.get(i);
            recipes.add(new RoadFactoryWrapper(rfr.getInputStack(), rfr.getModifier(), rfr.getFluidInputStack(), rfr.getOutputStack()));
        }
        return recipes;
    }

    private ArrayList<TarDistillerWrapper> tarDistillerRecipes() {
        ArrayList<TarDistillerWrapper> recipes = new ArrayList<TarDistillerWrapper>();
        for (int i = 0; i < RecipeRegistry.tarDistillerRecipes.size(); ++i) {
            TarDistillerRecipes tdr = RecipeRegistry.tarDistillerRecipes.get(i);
            recipes.add(new TarDistillerWrapper(tdr.getInputStack(), tdr.getFluidInputStack(), tdr.getOutput1Stack(), tdr.getOutput2Stack(), tdr.getFluidOutput1Stack(), tdr.getFluidOutput2Stack()));
        }
        return recipes;
    }

    private ArrayList<TarmacCutterWrapper> tarmacCutterRecipes() {
        int i;
        ArrayList<TarmacCutterWrapper> recipes = new ArrayList<TarmacCutterWrapper>();
        for (i = 0; i < 15; ++i) {
            this.addCutterRecipes(recipes, i, 1);
        }
        for (i = 0; i < 14; ++i) {
            this.addCutterRecipes(recipes, i, 2);
        }
        for (i = 0; i < 12; ++i) {
            this.addCutterRecipes(recipes, i, 4);
        }
        for (i = 0; i < 8; ++i) {
            this.addCutterRecipes(recipes, i, 8);
        }
        return recipes;
    }

    private void addCutterRecipes(ArrayList<TarmacCutterWrapper> recipes, int i, int bladeSize) {
        recipes.add(new TarmacCutterWrapper(new ItemStack((Block)FRBlocks.road_block_standard, 1, i + bladeSize), new ItemStack((Block)FRBlocks.road_block_standard, 1, i), new ItemStack((Item)FRItems.tarmac_fragment_standard, bladeSize)));
        recipes.add(new TarmacCutterWrapper(new ItemStack((Block)FRBlocks.road_block_concrete_1, 1, i + bladeSize), new ItemStack((Block)FRBlocks.road_block_concrete_1, 1, i), new ItemStack((Item)FRItems.tarmac_fragment_concrete_1, bladeSize)));
        recipes.add(new TarmacCutterWrapper(new ItemStack((Block)FRBlocks.road_block_concrete_2, 1, i + bladeSize), new ItemStack((Block)FRBlocks.road_block_concrete_2, 1, i), new ItemStack((Item)FRItems.tarmac_fragment_concrete_2, bladeSize)));
        recipes.add(new TarmacCutterWrapper(new ItemStack((Block)FRBlocks.road_block_light, 1, i + bladeSize), new ItemStack((Block)FRBlocks.road_block_light, 1, i), new ItemStack((Item)FRItems.tarmac_fragment_light, bladeSize)));
        recipes.add(new TarmacCutterWrapper(new ItemStack((Block)FRBlocks.road_block_fine, 1, i + bladeSize), new ItemStack((Block)FRBlocks.road_block_fine, 1, i), new ItemStack((Item)FRItems.tarmac_fragment_fine, bladeSize)));
        recipes.add(new TarmacCutterWrapper(new ItemStack((Block)FRBlocks.road_block_dark, 1, i + bladeSize), new ItemStack((Block)FRBlocks.road_block_dark, 1, i), new ItemStack((Item)FRItems.tarmac_fragment_dark, bladeSize)));
        recipes.add(new TarmacCutterWrapper(new ItemStack((Block)FRBlocks.road_block_pale, 1, i + bladeSize), new ItemStack((Block)FRBlocks.road_block_pale, 1, i), new ItemStack((Item)FRItems.tarmac_fragment_pale, bladeSize)));
        recipes.add(new TarmacCutterWrapper(new ItemStack((Block)FRBlocks.road_block_red, 1, i + bladeSize), new ItemStack((Block)FRBlocks.road_block_red, 1, i), new ItemStack((Item)FRItems.tarmac_fragment_red, bladeSize)));
        recipes.add(new TarmacCutterWrapper(new ItemStack((Block)FRBlocks.road_block_blue, 1, i + bladeSize), new ItemStack((Block)FRBlocks.road_block_blue, 1, i), new ItemStack((Item)FRItems.tarmac_fragment_blue, bladeSize)));
        recipes.add(new TarmacCutterWrapper(new ItemStack((Block)FRBlocks.road_block_white, 1, i + bladeSize), new ItemStack((Block)FRBlocks.road_block_white, 1, i), new ItemStack((Item)FRItems.tarmac_fragment_white, bladeSize)));
        recipes.add(new TarmacCutterWrapper(new ItemStack((Block)FRBlocks.road_block_yellow, 1, i + bladeSize), new ItemStack((Block)FRBlocks.road_block_yellow, 1, i), new ItemStack((Item)FRItems.tarmac_fragment_yellow, bladeSize)));
        recipes.add(new TarmacCutterWrapper(new ItemStack((Block)FRBlocks.road_block_green, 1, i + bladeSize), new ItemStack((Block)FRBlocks.road_block_green, 1, i), new ItemStack((Item)FRItems.tarmac_fragment_green, bladeSize)));
        recipes.add(new TarmacCutterWrapper(new ItemStack((Block)FRBlocks.road_block_muddy, 1, i + bladeSize), new ItemStack((Block)FRBlocks.road_block_muddy, 1, i), new ItemStack((Item)FRItems.tarmac_fragment_muddy, bladeSize)));
        recipes.add(new TarmacCutterWrapper(new ItemStack((Block)FRBlocks.road_block_muddy_dried, 1, i + bladeSize), new ItemStack((Block)FRBlocks.road_block_muddy_dried, 1, i), new ItemStack((Item)FRItems.tarmac_fragment_muddy, bladeSize)));
        recipes.add(new TarmacCutterWrapper(new ItemStack((Block)FRBlocks.road_block_stone, 1, i + bladeSize), new ItemStack((Block)FRBlocks.road_block_stone, 1, i), new ItemStack((Item)FRItems.tarmac_fragment_stone, bladeSize)));
        recipes.add(new TarmacCutterWrapper(new ItemStack((Block)FRBlocks.road_block_grass, 1, i + bladeSize), new ItemStack((Block)FRBlocks.road_block_grass, 1, i), new ItemStack((Item)FRItems.tarmac_fragment_grass, bladeSize)));
        recipes.add(new TarmacCutterWrapper(new ItemStack((Block)FRBlocks.road_block_dirt, 1, i + bladeSize), new ItemStack((Block)FRBlocks.road_block_dirt, 1, i), new ItemStack((Item)FRItems.tarmac_fragment_dirt, bladeSize)));
        recipes.add(new TarmacCutterWrapper(new ItemStack((Block)FRBlocks.road_block_gravel, 1, i + bladeSize), new ItemStack((Block)FRBlocks.road_block_gravel, 1, i), new ItemStack((Item)FRItems.tarmac_fragment_gravel, bladeSize)));
        recipes.add(new TarmacCutterWrapper(new ItemStack((Block)FRBlocks.road_block_sand, 1, i + bladeSize), new ItemStack((Block)FRBlocks.road_block_sand, 1, i), new ItemStack((Item)FRItems.tarmac_fragment_sand, bladeSize)));
    }

    private ArrayList<CrusherWrapper> crusherRecipes() {
        ArrayList<CrusherWrapper> recipes = new ArrayList<CrusherWrapper>();
        for (int i = 0; i < RecipeRegistry.crusherRecipes.size(); ++i) {
            CrusherRecipes cr = RecipeRegistry.crusherRecipes.get(i);
            recipes.add(new CrusherWrapper(cr.getInputStack(), cr.getOutputStack()));
        }
        return recipes;
    }
}

