/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.client.render;

import java.awt.Color;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;

public class Quad {
    private Vec3d vec1;
    private Vec3d vec2;
    private Vec3d vec3;
    private Vec3d vec4;
    float u1;
    float u2;
    float u3;
    float u4;
    float v1;
    float v2;
    float v3;
    float v4;
    boolean flipU = false;
    boolean flipV = false;
    TextureAtlasSprite sprite;
    protected VertexFormat format;

    public Quad(Vec3d vec1, float u1, float v1, Vec3d vec2, float u2, float v2, Vec3d vec3, float u3, float v3, Vec3d vec4, float u4, float v4, TextureAtlasSprite sprite, VertexFormat format) {
        this.vec1 = vec1;
        this.vec2 = vec2;
        this.vec3 = vec3;
        this.vec4 = vec4;
        this.format = format;
        this.u1 = u1;
        this.u2 = u2;
        this.u3 = u3;
        this.u4 = u4;
        this.v1 = v1;
        this.v2 = v2;
        this.v3 = v3;
        this.v4 = v4;
        this.sprite = sprite;
    }

    public Quad(Vec3d vec1, Vec3d vec2, Vec3d vec3, Vec3d vec4, TextureAtlasSprite sprite, VertexFormat format) {
        this(vec1, (float)vec1.field_72450_a * 16.0f, (float)vec1.field_72449_c * 16.0f, vec2, (float)vec2.field_72450_a * 16.0f, (float)vec2.field_72449_c * 16.0f, vec3, (float)vec3.field_72450_a * 16.0f, (float)vec3.field_72449_c * 16.0f, vec4, (float)vec4.field_72450_a * 16.0f, (float)vec4.field_72449_c * 16.0f, sprite, format);
    }

    public void updateUVs() {
        if (this.flipU) {
            this.u1 = 16.0f - (float)this.vec1.field_72450_a * 16.0f;
            this.u2 = 16.0f - (float)this.vec2.field_72450_a * 16.0f;
            this.u3 = 16.0f - (float)this.vec3.field_72450_a * 16.0f;
            this.u4 = 16.0f - (float)this.vec4.field_72450_a * 16.0f;
        } else {
            this.u1 = (float)this.vec1.field_72450_a * 16.0f;
            this.u2 = (float)this.vec2.field_72450_a * 16.0f;
            this.u3 = (float)this.vec3.field_72450_a * 16.0f;
            this.u4 = (float)this.vec4.field_72450_a * 16.0f;
        }
        if (this.flipV) {
            this.v1 = 16.0f - (float)this.vec1.field_72449_c * 16.0f;
            this.v2 = 16.0f - (float)this.vec2.field_72449_c * 16.0f;
            this.v3 = 16.0f - (float)this.vec3.field_72449_c * 16.0f;
            this.v4 = 16.0f - (float)this.vec4.field_72449_c * 16.0f;
        } else {
            this.v1 = (float)this.vec1.field_72449_c * 16.0f;
            this.v2 = (float)this.vec2.field_72449_c * 16.0f;
            this.v3 = (float)this.vec3.field_72449_c * 16.0f;
            this.v4 = (float)this.vec4.field_72449_c * 16.0f;
        }
    }

    public void setFlipU(boolean flip) {
        this.flipU = flip;
    }

    public void setFlipV(boolean flip) {
        this.flipV = flip;
    }

    public BakedQuad createQuad(int col) {
        Vec3d normal = this.vec3.func_178788_d(this.vec2).func_72431_c(this.vec1.func_178788_d(this.vec2)).func_72432_b();
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(this.format);
        builder.setTexture(this.sprite);
        this.putVertex(builder, normal, this.vec1.field_72450_a, this.vec1.field_72448_b, this.vec1.field_72449_c, this.u1, this.v1, this.sprite, col);
        this.putVertex(builder, normal, this.vec2.field_72450_a, this.vec2.field_72448_b, this.vec2.field_72449_c, this.u2, this.v2, this.sprite, col);
        this.putVertex(builder, normal, this.vec3.field_72450_a, this.vec3.field_72448_b, this.vec3.field_72449_c, this.u3, this.v3, this.sprite, col);
        this.putVertex(builder, normal, this.vec4.field_72450_a, this.vec4.field_72448_b, this.vec4.field_72449_c, this.u4, this.v4, this.sprite, col);
        return builder.build();
    }

    public BakedQuad createUnnormalizedQuad(int col) {
        Vec3d normal = new Vec3d(1.0, 1.0, 1.0);
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(this.format);
        builder.setTexture(this.sprite);
        this.putVertex(builder, normal, this.vec1.field_72450_a, this.vec1.field_72448_b, this.vec1.field_72449_c, this.u1, this.v1, this.sprite, col);
        this.putVertex(builder, normal, this.vec2.field_72450_a, this.vec2.field_72448_b, this.vec2.field_72449_c, this.u2, this.v2, this.sprite, col);
        this.putVertex(builder, normal, this.vec3.field_72450_a, this.vec3.field_72448_b, this.vec3.field_72449_c, this.u3, this.v3, this.sprite, col);
        this.putVertex(builder, normal, this.vec4.field_72450_a, this.vec4.field_72448_b, this.vec4.field_72449_c, this.u4, this.v4, this.sprite, col);
        return builder.build();
    }

    protected void putVertex(UnpackedBakedQuad.Builder builder, Vec3d normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite, int col) {
        block6: for (int e = 0; e < this.format.func_177345_h(); ++e) {
            switch (this.format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    builder.put(e, new float[]{(float)x, (float)y, (float)z, 1.0f});
                    continue block6;
                }
                case COLOR: {
                    if (col == 0) {
                        builder.put(e, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
                        continue block6;
                    }
                    Color color = new Color(col);
                    builder.put(e, new float[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f});
                    continue block6;
                }
                case UV: {
                    if (this.format.func_177348_c(e).func_177369_e() == 0) {
                        u = sprite.func_94214_a((double)u);
                        v = sprite.func_94207_b((double)v);
                        builder.put(e, new float[]{u, v, 0.0f, 1.0f});
                        continue block6;
                    }
                }
                case NORMAL: {
                    builder.put(e, new float[]{(float)normal.field_72450_a, (float)normal.field_72448_b, (float)normal.field_72449_c, 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    public static Quad rotateQuadX(Quad quadIn, int rot) {
        quadIn.vec1 = Quad.dotProductX(quadIn.vec1, rot);
        quadIn.vec2 = Quad.dotProductX(quadIn.vec2, rot);
        quadIn.vec3 = Quad.dotProductX(quadIn.vec3, rot);
        quadIn.vec4 = Quad.dotProductX(quadIn.vec4, rot);
        return quadIn;
    }

    public static Quad rotateQuadY(Quad quadIn, int rot) {
        quadIn.vec1 = Quad.dotProductY(quadIn.vec1, rot);
        quadIn.vec2 = Quad.dotProductY(quadIn.vec2, rot);
        quadIn.vec3 = Quad.dotProductY(quadIn.vec3, rot);
        quadIn.vec4 = Quad.dotProductY(quadIn.vec4, rot);
        return quadIn;
    }

    public static Quad rotateQuadZ(Quad quadIn, int rot) {
        quadIn.vec1 = Quad.dotProductZ(quadIn.vec1, rot);
        quadIn.vec2 = Quad.dotProductZ(quadIn.vec2, rot);
        quadIn.vec3 = Quad.dotProductZ(quadIn.vec3, rot);
        quadIn.vec4 = Quad.dotProductZ(quadIn.vec4, rot);
        return quadIn;
    }

    public static void printVector(Vec3d vec) {
        System.out.printf("X: %s, Y: %s, Z: %s\n", vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public static Vec3d dotProductX(Vec3d vec, int rot) {
        vec = vec.func_178787_e(new Vec3d(-0.5, -0.5, -0.5));
        double cos = Math.cos(Math.toRadians(rot));
        double sin = Math.sin(Math.toRadians(rot));
        double vecY = cos * vec.field_72448_b + -sin * vec.field_72449_c;
        double vecZ = sin * vec.field_72448_b + cos * vec.field_72449_c;
        return new Vec3d(vec.field_72450_a + 0.5, vecY + 0.5, vecZ + 0.5);
    }

    public static Vec3d dotProductY(Vec3d vec, int rot) {
        vec = vec.func_178787_e(new Vec3d(-0.5, -0.5, -0.5));
        double cos = Math.cos(Math.toRadians(rot));
        double sin = Math.sin(Math.toRadians(rot));
        double vecX = cos * vec.field_72450_a + sin * vec.field_72449_c;
        double vecZ = -sin * vec.field_72450_a + cos * vec.field_72449_c;
        return new Vec3d(vecX + 0.5, vec.field_72448_b + 0.5, vecZ + 0.5);
    }

    public static Vec3d dotProductZ(Vec3d vec, int rot) {
        vec = vec.func_178787_e(new Vec3d(-0.5, -0.5, -0.5));
        double cos = Math.cos(Math.toRadians(rot));
        double sin = Math.sin(Math.toRadians(rot));
        double vecX = cos * vec.field_72450_a + -sin * vec.field_72448_b;
        double vecY = sin * vec.field_72450_a + cos * vec.field_72448_b;
        return new Vec3d(vecX + 0.5, vecY + 0.5, vec.field_72449_c + 0.5);
    }
}

