/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.client.model.paint.loaders.customs;

import com.silvaniastudios.roads.blocks.diagonal.ShapeLibrary;
import com.silvaniastudios.roads.blocks.enums.EnumRotatable;
import com.silvaniastudios.roads.blocks.paint.PaintBlockBase;
import com.silvaniastudios.roads.blocks.paint.customs.CustomPaintWallBlock;
import com.silvaniastudios.roads.blocks.paint.customs.ICustomBlock;
import com.silvaniastudios.roads.client.model.paint.PaintBakedModelBase;
import com.silvaniastudios.roads.client.render.Quad;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.IModelState;

class CustomWallBakedModel
extends PaintBakedModelBase {
    public CustomWallBakedModel(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        super(state, format, bakedTextureGetter);
        this.populateSprites();
    }

    @Override
    protected List<BakedQuad> packQuads(IBlockState state) {
        int yRot;
        int xRot;
        boolean[][] grid;
        TextureAtlasSprite tex;
        if (state != null) {
            int colId = ((PaintBlockBase)state.func_177230_c()).getColour().getId();
            tex = this.sprites[colId];
            EnumRotatable rotState = (EnumRotatable)((Object)state.func_177229_b(CustomPaintWallBlock.ROTATE_ID));
            int meta = state.func_177230_c().func_176201_c(state);
            grid = meta <= 7 ? ((ICustomBlock)state.func_177230_c()).getGrid(0).getGrid() : ((ICustomBlock)state.func_177230_c()).getGrid(1).getGrid();
            xRot = 0;
            yRot = 45;
            switch (rotState) {
                case FLAT_NORTH: 
                case FLAT_NORTH_2: {
                    yRot = 0;
                    break;
                }
                case FLAT_EAST: 
                case FLAT_EAST_2: {
                    yRot = 270;
                    break;
                }
                case FLAT_SOUTH: 
                case FLAT_SOUTH_2: {
                    yRot = 180;
                    break;
                }
                case FLAT_WEST: 
                case FLAT_WEST_2: {
                    yRot = 90;
                    break;
                }
                case FACE_NORTH: 
                case FACE_NORTH_2: {
                    xRot = 90;
                    yRot = 0;
                    break;
                }
                case FACE_EAST: 
                case FACE_EAST_2: {
                    xRot = 90;
                    yRot = 270;
                    break;
                }
                case FACE_SOUTH: 
                case FACE_SOUTH_2: {
                    xRot = 90;
                    yRot = 180;
                    break;
                }
                case FACE_WEST: 
                case FACE_WEST_2: {
                    xRot = 90;
                    yRot = 90;
                }
            }
        } else {
            return this.handleItemRendering();
        }
        List<Quad> rawQuads = ShapeLibrary.shapeFromGrid(grid, 0.015625f, tex, this.format, false);
        List<BakedQuad> quads = this.shapeBuilder(rawQuads, new ArrayList<BakedQuad>(), xRot, yRot);
        return quads;
    }

    @Override
    protected List<BakedQuad> shapeBuilder(List<Quad> rawQuads, List<BakedQuad> quads, int rotX, int rotY) {
        int i;
        for (i = 0; i < rawQuads.size(); ++i) {
            if (rawQuads.get(i) == null) continue;
            Quad.rotateQuadX(rawQuads.get(i), rotX);
            rawQuads.set(i, Quad.rotateQuadY(rawQuads.get(i), rotY));
        }
        if (rawQuads.get(0) != null) {
            rawQuads.get(0).updateUVs();
        }
        if (rawQuads.get(1) != null) {
            rawQuads.get(1).setFlipV(true);
            rawQuads.get(1).updateUVs();
        }
        for (i = 0; i < rawQuads.size(); ++i) {
            if (rawQuads.get(i) == null) continue;
            BakedQuad baked = rawQuads.get(i).createQuad(0);
            quads.add(baked);
        }
        return quads;
    }
}

