/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.client.model.paint;

import com.silvaniastudios.roads.client.model.paint.PaintBakedModelBase;
import com.silvaniastudios.roads.client.render.Quad;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.model.IModelState;

public class PaintLineBakedModelBase
extends PaintBakedModelBase {
    public PaintLineBakedModelBase(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        super(state, format, bakedTextureGetter);
    }

    protected List<BakedQuad> shapeBuilder(List<Quad> rawQuads, List<BakedQuad> quads, int col) {
        return this.shapeBuilder(rawQuads, quads, col, 0);
    }

    @Override
    protected List<BakedQuad> shapeBuilder(List<Quad> rawQuads, List<BakedQuad> quads, int col, int rotation) {
        int i;
        if (rotation != 0) {
            for (i = 0; i < rawQuads.size(); ++i) {
                if (rawQuads.get(i) == null) continue;
                rawQuads.set(i, Quad.rotateQuadY(rawQuads.get(i), rotation));
            }
        }
        for (i = 0; i < rawQuads.size(); ++i) {
            if (rawQuads.get(i) == null) continue;
            BakedQuad baked = rawQuads.get(i).createQuad(col);
            quads.add(baked);
        }
        return quads;
    }

    public static List<Quad> shapeLine(VertexFormat format, TextureAtlasSprite sprite, float x1, float z1, float x2, float z2, float hSW, float hSE, float hNE, float hNW) {
        ArrayList<Quad> quads = new ArrayList<Quad>();
        float xMin = Math.min(x1, x2);
        float xMax = Math.max(x1, x2);
        float zMin = Math.min(z1, z2);
        float zMax = Math.max(z1, z2);
        float deltaHeightNWS = Math.abs(hNW - hSW);
        float deltaHeightNES = Math.abs(hNE - hSE);
        float deltaHeightENW = Math.abs(hNW - hNE);
        float deltaHeightESW = Math.abs(hSW - hSE);
        float heightSW = 0.0f;
        float heightSE = 0.0f;
        float heightNW = 0.0f;
        float heightNE = 0.0f;
        if (x1 > x2) {
            heightSW = Math.max(hSW, hSE) - x1 * deltaHeightESW + (1.0f - zMax) * deltaHeightNWS;
            heightSE = Math.max(hSW, hSE) - x2 * deltaHeightESW + (1.0f - zMax) * deltaHeightNES;
            heightNW = Math.max(hNW, hNE) - x1 * deltaHeightENW - zMin * deltaHeightNWS;
            heightNE = Math.max(hNW, hNE) - x2 * deltaHeightENW - zMin * deltaHeightNES;
        } else {
            heightSW = Math.max(hSW, hSE) - x2 * deltaHeightESW + (1.0f - zMax) * deltaHeightNWS;
            heightSE = Math.max(hSW, hSE) - x1 * deltaHeightESW + (1.0f - zMax) * deltaHeightNES;
            heightNW = Math.max(hNW, hNE) - x2 * deltaHeightENW - zMin * deltaHeightNWS;
            heightNE = Math.max(hNW, hNE) - x1 * deltaHeightENW - zMin * deltaHeightNES;
        }
        Quad north = new Quad(new Vec3d((double)xMax, (double)heightNE, (double)zMin), xMin * 16.0f, 16.0f, new Vec3d((double)xMin, (double)heightNW, (double)zMin), xMax * 16.0f, 16.0f, new Vec3d((double)xMin, (double)heightNW + 0.015625, (double)zMin), xMax * 16.0f, 15.75f, new Vec3d((double)xMax, (double)heightNE + 0.015625, (double)zMin), xMin * 16.0f, 15.75f, sprite, format);
        Quad east = new Quad(new Vec3d((double)xMax, (double)heightSE, (double)zMax), zMin * 16.0f, 16.0f, new Vec3d((double)xMax, (double)heightNE, (double)zMin), zMax * 16.0f, 16.0f, new Vec3d((double)xMax, (double)heightNE + 0.015625, (double)zMin), zMax * 16.0f, 15.75f, new Vec3d((double)xMax, (double)heightSE + 0.015625, (double)zMax), zMin * 16.0f, 15.75f, sprite, format);
        Quad south = new Quad(new Vec3d((double)xMin, (double)heightSW, (double)zMax), xMax * 16.0f, 15.75f, new Vec3d((double)xMax, (double)heightSE, (double)zMax), xMin * 16.0f, 15.75f, new Vec3d((double)xMax, (double)heightSE + 0.015625, (double)zMax), xMin * 16.0f, 16.0f, new Vec3d((double)xMin, (double)heightSW + 0.015625, (double)zMax), xMax * 16.0f, 16.0f, sprite, format);
        Quad west = new Quad(new Vec3d((double)xMin, (double)heightNW, (double)zMin), zMax * 16.0f, 15.75f, new Vec3d((double)xMin, (double)heightSW, (double)zMax), zMin * 16.0f, 15.75f, new Vec3d((double)xMin, (double)heightSW + 0.015625, (double)zMax), zMin * 16.0f, 16.0f, new Vec3d((double)xMin, (double)heightNW + 0.015625, (double)zMin), zMax * 16.0f, 16.0f, sprite, format);
        Quad top = new Quad(new Vec3d((double)x1, (double)heightSW + 0.015625, (double)z2), new Vec3d((double)x2, (double)heightSE + 0.015625, (double)z2), new Vec3d((double)x2, (double)heightNE + 0.015625, (double)z1), new Vec3d((double)x1, (double)heightNW + 0.015625, (double)z1), sprite, format);
        quads.add(top);
        quads.add(north);
        quads.add(east);
        quads.add(south);
        quads.add(west);
        return quads;
    }
}

