/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.client.gui;

import com.silvaniastudios.roads.RoadsConfig;
import com.silvaniastudios.roads.blocks.tileentities.paintoven.PaintOvenContainer;
import com.silvaniastudios.roads.blocks.tileentities.paintoven.PaintOvenElectricEntity;
import com.silvaniastudios.roads.blocks.tileentities.paintoven.PaintOvenEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidTank;

public class GuiPaintOven
extends GuiContainer {
    private static final ResourceLocation guiTextures = new ResourceLocation("furenikusroads:textures/gui/paint_oven.png");
    private PaintOvenEntity tileEntity;
    private boolean electric;

    public GuiPaintOven(PaintOvenEntity tileEntity, PaintOvenContainer container, boolean electric) {
        super((Container)container);
        this.field_146999_f = 196;
        this.field_147000_g = 156;
        this.tileEntity = tileEntity;
        this.electric = electric;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int left = (this.field_146294_l - this.field_146999_f) / 2;
        int top = (this.field_146295_m - this.field_147000_g) / 2;
        this.drawTooltip(2, left, top, mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(guiTextures);
        int left = (this.field_146294_l - this.field_146999_f) / 2;
        int top = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(left, top, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.electric) {
            this.func_73729_b(left + this.field_146999_f - 23, top, 196, 0, 23, 56);
        }
        this.drawFluid(left + 8, top + 8, this.tileEntity.water);
        this.drawFluid(left + 108, top + 8, this.tileEntity.paint);
        this.drawFuel(left, top);
        this.drawProgress(left, top);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    private void drawFluid(int left, int top, FluidTank fluid) {
        if (fluid.getFluidAmount() > 0) {
            int fillPercent = this.getPercentage(fluid.getFluidAmount(), 64000) / 2;
            this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            TextureAtlasSprite waterTexture = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getFluid().getFluid().getStill(fluid.getFluid()).toString());
            for (int i = 0; i < 3; ++i) {
                this.drawFluidQuad(left, top + i * 16, 16, 16, waterTexture);
                this.drawFluidQuad(left + 16, top + i * 16, 16, 16, waterTexture);
                this.drawFluidQuad(left + 32, top + i * 16, 16, 16, waterTexture);
                this.drawFluidQuad(left + 48, top + i * 16, 12, 16, waterTexture);
            }
            this.drawFluidQuad(left, top + 48, 16, 2, waterTexture);
            this.drawFluidQuad(left + 16, top + 48, 16, 2, waterTexture);
            this.drawFluidQuad(left + 32, top + 48, 16, 2, waterTexture);
            this.drawFluidQuad(left + 48, top + 48, 12, 2, waterTexture);
            this.field_146297_k.func_110434_K().func_110577_a(guiTextures);
            this.func_73729_b(left, top, 8, 8, 60, 50 - fillPercent);
        }
        this.func_73729_b(left, top, 196, 206, 60, 50);
    }

    private void drawFluidQuad(int x, int y, int width, int height, TextureAtlasSprite texture) {
        float minU = texture.func_94214_a(0.0);
        float minV = texture.func_94207_b(0.0);
        float maxU = texture.func_94214_a((double)width);
        float maxV = texture.func_94207_b((double)height);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b((double)x, (double)(y + height), (double)this.field_73735_i).func_187315_a((double)minU, (double)maxV).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_187315_a((double)maxU, (double)maxV).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)y, (double)this.field_73735_i).func_187315_a((double)maxU, (double)minV).func_181675_d();
        worldrenderer.func_181662_b((double)x, (double)y, (double)this.field_73735_i).func_187315_a((double)minU, (double)minV).func_181675_d();
        tessellator.func_78381_a();
    }

    private void drawFuel(int left, int top) {
        if (this.electric) {
            PaintOvenElectricEntity poee = (PaintOvenElectricEntity)this.tileEntity;
            int p = this.getPercentage(poee.energy.getEnergyStored(), poee.energy.getMaxEnergyStored());
            int x = Math.round((float)p / 2.5f);
            if (p == 100) {
                x = 42;
            }
            this.func_73729_b(left + 175, top + 7 + (42 - x), 242, 42 - x, 14, x);
        } else {
            int p = this.getPercentage(this.tileEntity.fuel_remaining, this.tileEntity.last_fuel_cap);
            int x = Math.round((float)p / 7.0f);
            this.func_73729_b(left + 175, top + 13 + (14 - x), 228, 14 - x, 14, x);
        }
    }

    private void drawProgress(int left, int top) {
        int p = this.getPercentage(this.tileEntity.timerCount, this.electric ? RoadsConfig.machine.electricPaintOvenTickRate : RoadsConfig.machine.paintOvenTickRate);
        int x = Math.round((float)p * 1.6f);
        this.func_73729_b(left + 8, top + 64, 0, 252, x, 4);
    }

    private void drawTooltip(int col, int left, int top, int mouseX, int mouseY) {
        if (mouseX >= left + 8 && mouseX <= left + 68 && mouseY >= top + 8 && mouseY <= top + 58) {
            this.func_146279_a(this.tileEntity.water.getFluidAmount() + "/" + 64000, mouseX - left, mouseY - top + 15);
        }
        if (mouseX >= left + 108 && mouseX <= left + 168 && mouseY >= top + 8 && mouseY <= top + 58) {
            this.func_146279_a(this.tileEntity.paint.getFluidAmount() + "/" + 64000, mouseX - left, mouseY - top + 15);
        }
        if (this.electric) {
            PaintOvenElectricEntity pfee = (PaintOvenElectricEntity)this.tileEntity;
            if (mouseX >= left + 175 && mouseX <= left + 189 && mouseY >= top + 7 && mouseY <= top + 49) {
                this.func_146279_a(pfee.energy.getEnergyStored() + "/" + pfee.energy.getMaxEnergyStored(), mouseX - left, mouseY - top + 15);
            }
        } else if (mouseX >= left + 175 && mouseX <= left + 189 && mouseY >= top + 13 && mouseY <= top + 27) {
            this.func_146279_a(this.tileEntity.fuel_remaining + "/" + this.tileEntity.last_fuel_cap, mouseX - left, mouseY - top + 15);
        }
        if (RoadsConfig.general.guiGuide) {
            if (mouseX >= left + 80 && mouseX <= left + 96 && mouseY >= top + 25 && mouseY <= top + 41 && this.tileEntity.inventory.getStackInSlot(0).func_190916_E() == 0) {
                this.func_146279_a(I18n.func_135052_a((String)"roads.gui.paint_oven.dye_slot", (Object[])new Object[0]), mouseX - left, mouseY - top + 15);
            }
            if (mouseX >= left + 174 && mouseX <= left + 190 && mouseY >= top + 32 && mouseY <= top + 48 && !this.electric && this.tileEntity.inventory.getStackInSlot(1).func_190916_E() == 0) {
                this.func_146279_a(I18n.func_135052_a((String)"roads.gui.fuelSlot", (Object[])new Object[0]), mouseX - left, mouseY - top + 15);
            }
        }
    }

    private int getPercentage(int num, int max) {
        float x = (float)num / (float)max;
        int y = Math.round(x * 100.0f);
        if (y > 100) {
            return 100;
        }
        return y;
    }
}

