/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.client;

import com.silvaniastudios.roads.blocks.BlockBase;
import com.silvaniastudios.roads.blocks.decorative.CurbBlock;
import com.silvaniastudios.roads.blocks.diagonal.RoadBlockDiagonal;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BoundingBoxDraw {
    @SubscribeEvent
    public static void drawBlockHighlight(DrawBlockHighlightEvent event) {
        BlockPos pos = event.getTarget().func_178782_a();
        EntityPlayer player = event.getPlayer();
        World world = player.field_70170_p;
        if (event.getTarget().field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockBase block;
            IBlockState state = world.func_180495_p(pos);
            double d3 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
            double d4 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
            double d5 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
            if (state.func_177230_c() instanceof RoadBlockDiagonal) {
                block = (RoadBlockDiagonal)state.func_177230_c();
                AxisAlignedBB box = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                BoundingBoxDraw.drawHalfBox(pos, ((RoadBlockDiagonal)block).getLeftVecs(world, state, pos), ((RoadBlockDiagonal)block).getRightVecs(world, state, pos), 0.0f, 0.0f, 0.0f, 0.4f, d3, d4, d5);
                box.func_186662_g((double)0.002f).func_72317_d(d3, d4, d5);
            }
            if (state.func_177230_c() instanceof CurbBlock) {
                block = (CurbBlock)state.func_177230_c();
                BoundingBoxDraw.drawNormalBox(pos, ((CurbBlock)block).getVecs(world, state, pos), 0.0f, 0.0f, 0.0f, 0.4f, d3, d4, d5);
            }
        }
    }

    public static void drawNormalBox(BlockPos pos, Vec3d[] vecs, float r, float g, float b, float a, double pX, double pY, double pZ) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        BoundingBoxDraw.draw(vecs, buffer, r, g, b, a, pos, pX, pY, pZ);
        tessellator.func_78381_a();
    }

    public static void drawHalfBox(BlockPos pos, Vec3d[] vecsLeft, Vec3d[] vecsRight, float r, float g, float b, float a, double pX, double pY, double pZ) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        BoundingBoxDraw.draw(vecsLeft, buffer, r, g, b, a, pos, pX, pY, pZ);
        BoundingBoxDraw.draw(vecsRight, buffer, r, g, b, a, pos, pX, pY, pZ);
        tessellator.func_78381_a();
    }

    public static void draw(Vec3d[] vecs, BufferBuilder buffer, float r, float g, float b, float a, BlockPos pos, double pX, double pY, double pZ) {
        for (int i = 0; i < vecs.length; ++i) {
            Vec3d vec = BoundingBoxDraw.offsetVector(BoundingBoxDraw.offsetVector(vecs[i], pos), -pX, -pY, -pZ);
            double x = vec.field_72450_a;
            double y = vec.field_72448_b;
            double z = vec.field_72449_c;
            if (i == 0) {
                buffer.func_181662_b(x, y, z).func_181666_a(r, g, b, 0.0f).func_181675_d();
            }
            buffer.func_181662_b(x, y, z).func_181666_a(r, g, b, a).func_181675_d();
            if (i != vecs.length) continue;
            buffer.func_181662_b(x, y, z).func_181666_a(r, g, b, 0.0f).func_181675_d();
        }
    }

    static Vec3d offsetVector(Vec3d vec, BlockPos pos) {
        return BoundingBoxDraw.offsetVector(vec, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    static Vec3d offsetVector(Vec3d vec, double x, double y, double z) {
        return new Vec3d(vec.field_72450_a + x, vec.field_72448_b + y, vec.field_72449_c + z);
    }

    public static Vec3d[] getRotatedVecs(Vec3d[] vecsIn, int rot, Vec3d offset) {
        Vec3d[] vecs = new Vec3d[vecsIn.length];
        for (int i = 0; i < vecsIn.length; ++i) {
            Vec3d offsetVec = new Vec3d(vecsIn[i].field_72450_a + 0.5, vecsIn[i].field_72448_b + 0.5, vecsIn[i].field_72449_c + 0.5).func_178785_b((float)Math.toRadians(rot));
            vecs[i] = new Vec3d(offsetVec.field_72450_a - 0.5 + offset.field_72450_a, offsetVec.field_72448_b - 0.5, offsetVec.field_72449_c - 0.5 + offset.field_72449_c);
        }
        return vecs;
    }
}

