/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.tileentities.paintfiller.hopper;

import com.silvaniastudios.roads.blocks.tileentities.RoadTileEntity;
import com.silvaniastudios.roads.blocks.tileentities.paintfiller.PaintFillerEntity;
import com.silvaniastudios.roads.blocks.tileentities.paintfiller.hopper.PaintFillerHopperBlock;
import com.silvaniastudios.roads.blocks.tileentities.paintfiller.hopper.PaintFillerHopperStackHandler;
import com.silvaniastudios.roads.fluids.FRFluids;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class PaintFillerHopperEntity
extends RoadTileEntity
implements ITickable,
ICapabilityProvider {
    private int up;
    private int north;
    private int east;
    private int south;
    private int west;
    private boolean is_output;
    public static final int FILLER_TANK_CAP = 32000;
    public ItemStackHandler inventory = new ItemStackHandler(5){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot == 0 && PaintFillerHopperEntity.this.isDye(stack, "dyeWhite") || slot == 1 && PaintFillerHopperEntity.this.isDye(stack, "dyeYellow") || slot == 2 && PaintFillerHopperEntity.this.isDye(stack, "dyeRed");
        }
    };
    public FluidTank white_paint = new FluidTank(32000){

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid.getFluid() == FRFluids.white_paint;
        }
    };
    public FluidTank yellow_paint = new FluidTank(32000){

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid.getFluid() == FRFluids.yellow_paint;
        }
    };
    public FluidTank red_paint = new FluidTank(32000){

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid.getFluid() == FRFluids.red_paint;
        }
    };
    public PaintFillerHopperStackHandler interactable_inv = new PaintFillerHopperStackHandler(this.inventory, this.hasCapability(CapabilityEnergy.ENERGY, null));
    int lastWhite = 0;
    int lastYellow = 0;
    int lastRed = 0;

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.getIOFromSide(facing) == PaintFillerHopperBlock.EnumIO.item) {
            return true;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (this.getIOFromSide(facing) == PaintFillerHopperBlock.EnumIO.white || this.getIOFromSide(facing) == PaintFillerHopperBlock.EnumIO.yellow || this.getIOFromSide(facing) == PaintFillerHopperBlock.EnumIO.red)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.getIOFromSide(facing) == PaintFillerHopperBlock.EnumIO.item) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.interactable_inv);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (this.getIOFromSide(facing) == PaintFillerHopperBlock.EnumIO.white) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.white_paint);
            }
            if (this.getIOFromSide(facing) == PaintFillerHopperBlock.EnumIO.yellow) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.yellow_paint);
            }
            if (this.getIOFromSide(facing) == PaintFillerHopperBlock.EnumIO.red) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.red_paint);
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public void updateSide(EnumFacing facing, EntityPlayer player) {
        int id = 0;
        if (facing == EnumFacing.UP) {
            if (this.up < 4) {
                ++this.up;
                id = this.up;
            } else {
                this.up = 0;
            }
        }
        if (facing == EnumFacing.NORTH) {
            if (this.north < 4) {
                ++this.north;
                id = this.north;
            } else {
                this.north = 0;
            }
        }
        if (facing == EnumFacing.EAST) {
            if (this.east < 4) {
                ++this.east;
                id = this.east;
            } else {
                this.east = 0;
            }
        }
        if (facing == EnumFacing.SOUTH) {
            if (this.south < 4) {
                ++this.south;
                id = this.south;
            } else {
                this.south = 0;
            }
        }
        if (facing == EnumFacing.WEST) {
            if (this.west < 4) {
                ++this.west;
                id = this.west;
            } else {
                this.west = 0;
            }
        }
        if (player.field_70170_p.field_72995_K) {
            switch (id) {
                case 0: {
                    player.func_145747_a((ITextComponent)new TextComponentString("Transfer port closed"));
                    break;
                }
                case 1: {
                    player.func_145747_a((ITextComponent)new TextComponentString("Transfer port set to White Paint"));
                    break;
                }
                case 2: {
                    player.func_145747_a((ITextComponent)new TextComponentString("Transfer port set to Yellow Paint"));
                    break;
                }
                case 3: {
                    player.func_145747_a((ITextComponent)new TextComponentString("Transfer port set to Red Paint"));
                    break;
                }
                case 4: {
                    player.func_145747_a((ITextComponent)new TextComponentString("Transfer port set to Items"));
                }
            }
        }
        this.sendUpdates();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(EnumFacing.DOWN)) instanceof PaintFillerEntity) {
                PaintFillerEntity te = (PaintFillerEntity)this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(EnumFacing.DOWN));
                int amt = 50;
                if (this.is_output) {
                    if (te.white_paint.getFluidAmount() + amt <= 32000 && this.white_paint.getFluidAmount() >= amt) {
                        te.white_paint.fill(this.white_paint.drain(50, true), true);
                    }
                    if (te.yellow_paint.getFluidAmount() + amt <= 32000 && this.yellow_paint.getFluidAmount() >= amt) {
                        te.yellow_paint.fill(this.yellow_paint.drain(50, true), true);
                    }
                    if (te.red_paint.getFluidAmount() + amt <= 32000 && this.red_paint.getFluidAmount() >= amt) {
                        te.red_paint.fill(this.red_paint.drain(50, true), true);
                    }
                    this.inventory.setStackInSlot(0, te.inventory.insertItem(0, this.inventory.getStackInSlot(0), false));
                    this.inventory.setStackInSlot(1, te.inventory.insertItem(2, this.inventory.getStackInSlot(1), false));
                    this.inventory.setStackInSlot(2, te.inventory.insertItem(3, this.inventory.getStackInSlot(2), false));
                } else {
                    if (this.white_paint.getFluidAmount() + amt <= 32000 && te.white_paint.getFluidAmount() >= amt) {
                        this.white_paint.fill(te.white_paint.drain(50, true), true);
                    }
                    if (this.yellow_paint.getFluidAmount() + amt <= 32000 && te.yellow_paint.getFluidAmount() >= amt) {
                        this.yellow_paint.fill(te.yellow_paint.drain(50, true), true);
                    }
                    if (this.red_paint.getFluidAmount() + amt <= 32000 && te.red_paint.getFluidAmount() >= amt) {
                        this.red_paint.fill(te.red_paint.drain(50, true), true);
                    }
                    te.inventory.setStackInSlot(0, te.inventory.insertItem(0, te.inventory.getStackInSlot(0), false));
                    te.inventory.setStackInSlot(2, te.inventory.insertItem(1, te.inventory.getStackInSlot(2), false));
                    te.inventory.setStackInSlot(3, te.inventory.insertItem(2, te.inventory.getStackInSlot(3), false));
                }
            }
            if (this.lastWhite != this.white_paint.getFluidAmount() || this.lastYellow != this.yellow_paint.getFluidAmount() || this.lastRed != this.red_paint.getFluidAmount()) {
                this.lastWhite = this.white_paint.getFluidAmount();
                this.lastYellow = this.yellow_paint.getFluidAmount();
                this.lastRed = this.red_paint.getFluidAmount();
                this.sendUpdates();
            }
        }
    }

    public int getSideUp() {
        return this.up;
    }

    public int getSideNorth() {
        return this.north;
    }

    public int getSideEast() {
        return this.east;
    }

    public int getSideSouth() {
        return this.south;
    }

    public int getSideWest() {
        return this.west;
    }

    public boolean getOutput() {
        return this.is_output;
    }

    public void toggleOutputMode(EntityPlayer player) {
        boolean bl = this.is_output = !this.is_output;
        if (player.field_70170_p.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentString("Output mode: " + this.is_output));
        }
        this.sendUpdates();
    }

    public PaintFillerHopperBlock.EnumIO getIOFromSide(EnumFacing facing) {
        int dir = 4;
        if (facing == EnumFacing.UP) {
            dir = this.up;
        }
        if (facing == EnumFacing.NORTH) {
            dir = this.north;
        }
        if (facing == EnumFacing.EAST) {
            dir = this.east;
        }
        if (facing == EnumFacing.SOUTH) {
            dir = this.south;
        }
        if (facing == EnumFacing.WEST) {
            dir = this.west;
        }
        return PaintFillerHopperBlock.EnumIO.byId(dir);
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("items")) {
            this.inventory.deserializeNBT((NBTTagCompound)nbt.func_74781_a("items"));
        }
        if (nbt.func_74764_b("paint_white")) {
            this.white_paint.readFromNBT((NBTTagCompound)nbt.func_74781_a("paint_white"));
        }
        if (nbt.func_74764_b("paint_yellow")) {
            this.yellow_paint.readFromNBT((NBTTagCompound)nbt.func_74781_a("paint_yellow"));
        }
        if (nbt.func_74764_b("paint_red")) {
            this.red_paint.readFromNBT((NBTTagCompound)nbt.func_74781_a("paint_red"));
        }
        this.up = nbt.func_74762_e("up");
        this.north = nbt.func_74762_e("north");
        this.east = nbt.func_74762_e("east");
        this.south = nbt.func_74762_e("south");
        this.west = nbt.func_74762_e("west");
        this.is_output = nbt.func_74767_n("is_output");
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("paint_white", (NBTBase)this.white_paint.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("paint_yellow", (NBTBase)this.yellow_paint.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("paint_red", (NBTBase)this.red_paint.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("items", (NBTBase)this.inventory.serializeNBT());
        nbt.func_74768_a("up", this.up);
        nbt.func_74768_a("north", this.north);
        nbt.func_74768_a("east", this.east);
        nbt.func_74768_a("south", this.south);
        nbt.func_74768_a("west", this.west);
        nbt.func_74757_a("is_output", this.is_output);
        return nbt;
    }
}

