/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.tileentities.paintfiller;

import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.RoadsConfig;
import com.silvaniastudios.roads.blocks.tileentities.RoadTileEntity;
import com.silvaniastudios.roads.blocks.tileentities.paintfiller.PaintFillerContainer;
import com.silvaniastudios.roads.blocks.tileentities.paintfiller.PaintFillerStackHandler;
import com.silvaniastudios.roads.fluids.FRFluids;
import com.silvaniastudios.roads.items.PaintGun;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class PaintFillerEntity
extends RoadTileEntity
implements ITickable,
ICapabilityProvider {
    public boolean has_gun = false;
    public int gun_white = 0;
    public int gun_yellow = 0;
    public int gun_red = 0;
    public int timerCount = 0;
    public static final int FILLER_TANK_CAP = 32000;
    public static final int GUN_TANK_CAP = 32000;
    public ItemStackHandler inventory = new ItemStackHandler(5){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }

        protected void onContentsChanged(int slot) {
            PaintFillerEntity.this.func_70296_d();
        }
    };
    public FluidTank white_paint = new FluidTank(32000){

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid.getFluid() == FRFluids.white_paint;
        }
    };
    public FluidTank yellow_paint = new FluidTank(32000){

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid.getFluid() == FRFluids.yellow_paint;
        }
    };
    public FluidTank red_paint = new FluidTank(32000){

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid.getFluid() == FRFluids.red_paint;
        }
    };
    public PaintFillerStackHandler interactable_inv = new PaintFillerStackHandler(this.inventory, this.hasCapability(CapabilityEnergy.ENERGY, null));
    int lastWhite = 0;
    int lastYellow = 0;
    int lastRed = 0;

    public boolean hasFastRenderer() {
        return true;
    }

    public Container createContainer(EntityPlayer player) {
        return new PaintFillerContainer(player.field_71071_by, this, false);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.getCapability(capability, facing) != null;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.interactable_inv);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        if (this.fuel_remaining > 0) {
            --this.fuel_remaining;
        } else if (this.fuel_remaining <= 0) {
            if (!this.inventory.getStackInSlot(4).func_190926_b()) {
                this.last_fuel_cap = this.fuel_remaining = TileEntityFurnace.func_145952_a((ItemStack)this.inventory.getStackInSlot(4));
                if (this.inventory.getStackInSlot(4).func_77973_b() == Items.field_151129_at) {
                    this.inventory.setStackInSlot(4, new ItemStack(Items.field_151133_ar));
                } else {
                    this.inventory.extractItem(4, 1, false);
                }
                this.sendUpdates();
            } else {
                this.timerCount = 0;
            }
        }
        if (this.timerCount < RoadsConfig.machine.fillerTickRate && this.fuel_remaining > 0) {
            this.timerCount = this.shouldTick() ? ++this.timerCount : 0;
        } else {
            if (this.fuel_remaining > 0) {
                this.process();
            }
            this.timerCount = 0;
        }
        if (!(this.field_145850_b.field_72995_K || this.lastWhite == this.white_paint.getFluidAmount() && this.lastYellow == this.yellow_paint.getFluidAmount() && this.lastRed == this.red_paint.getFluidAmount())) {
            this.lastWhite = this.white_paint.getFluidAmount();
            this.lastYellow = this.yellow_paint.getFluidAmount();
            this.lastRed = this.red_paint.getFluidAmount();
            this.sendUpdates();
        }
    }

    public void process() {
        FurenikusRoads.debug(2, "Paint Filler at" + this.formatPosition(this.field_174879_c) + "processing");
        if (!this.field_145850_b.field_72995_K) {
            int paintPerDye = RoadsConfig.machine.fillerPaintPerDye;
            boolean hasChanges = false;
            if (!(this.inventory.getStackInSlot(0).func_190926_b() && this.inventory.getStackInSlot(2).func_190926_b() && this.inventory.getStackInSlot(3).func_190926_b())) {
                if (this.isDye(this.inventory.getStackInSlot(0), "dyeWhite") && this.white_paint.getFluidAmount() + paintPerDye <= this.white_paint.getCapacity()) {
                    FurenikusRoads.debug(2, "Paint Filler: Create white paint");
                    this.inventory.extractItem(0, 1, false);
                    this.white_paint.fill(new FluidStack((Fluid)FRFluids.white_paint, paintPerDye), true);
                    hasChanges = true;
                }
                if (this.isDye(this.inventory.getStackInSlot(2), "dyeYellow") && this.yellow_paint.getFluidAmount() + paintPerDye <= this.yellow_paint.getCapacity()) {
                    FurenikusRoads.debug(2, "Paint Filler: Create yellow paint");
                    this.inventory.extractItem(2, 1, false);
                    this.yellow_paint.fill(new FluidStack((Fluid)FRFluids.yellow_paint, paintPerDye), true);
                    hasChanges = true;
                }
                if (this.isDye(this.inventory.getStackInSlot(3), "dyeRed") && this.red_paint.getFluidAmount() + paintPerDye <= this.red_paint.getCapacity()) {
                    FurenikusRoads.debug(2, "Paint Filler: Create red paint");
                    this.inventory.extractItem(3, 1, false);
                    this.red_paint.fill(new FluidStack((Fluid)FRFluids.red_paint, paintPerDye), true);
                    hasChanges = true;
                }
            }
            if (this.getGun().func_77973_b() instanceof PaintGun) {
                NBTTagCompound nbt;
                if (!this.has_gun) {
                    hasChanges = true;
                }
                this.has_gun = true;
                if (!this.getGun().func_77942_o()) {
                    nbt = new NBTTagCompound();
                    nbt.func_74768_a("white_paint", 0);
                    nbt.func_74768_a("yellow_paint", 0);
                    nbt.func_74768_a("red_paint", 0);
                    this.getGun().func_77982_d(nbt);
                } else {
                    nbt = this.getGun().func_77978_p();
                }
                this.gun_white = nbt.func_74762_e("white_paint");
                this.gun_yellow = nbt.func_74762_e("yellow_paint");
                this.gun_red = nbt.func_74762_e("red_paint");
                this.fillGun(nbt);
            } else {
                if (this.has_gun) {
                    hasChanges = true;
                }
                this.has_gun = false;
                this.gun_white = 0;
                this.gun_yellow = 0;
                this.gun_red = 0;
            }
            if (hasChanges) {
                this.sendUpdates();
            }
        }
    }

    public boolean shouldTick() {
        int paintPerDye = RoadsConfig.machine.fillerPaintPerDye;
        if (!(this.inventory.getStackInSlot(0).func_190926_b() && this.inventory.getStackInSlot(2).func_190926_b() && this.inventory.getStackInSlot(3).func_190926_b() || this.fuel_remaining <= 0 && !this.hasCapability(CapabilityEnergy.ENERGY, null))) {
            if (this.isDye(this.inventory.getStackInSlot(0), "dyeWhite") && this.white_paint.getFluidAmount() + paintPerDye <= this.white_paint.getCapacity()) {
                return true;
            }
            if (this.isDye(this.inventory.getStackInSlot(2), "dyeYellow") && this.yellow_paint.getFluidAmount() + paintPerDye <= this.yellow_paint.getCapacity()) {
                return true;
            }
            if (this.isDye(this.inventory.getStackInSlot(3), "dyeRed") && this.red_paint.getFluidAmount() + paintPerDye <= this.red_paint.getCapacity()) {
                return true;
            }
        }
        if (this.getGun().func_77973_b() instanceof PaintGun) {
            NBTTagCompound nbt = this.getGun().func_77978_p();
            if (!(this.getGun().func_77942_o() || this.white_paint.getFluidAmount() <= 0 && this.white_paint.getFluidAmount() <= 0 && this.white_paint.getFluidAmount() <= 0)) {
                return true;
            }
            if (!this.getGun().func_77942_o()) {
                nbt = new NBTTagCompound();
                nbt.func_74768_a("white_paint", 0);
                nbt.func_74768_a("yellow_paint", 0);
                nbt.func_74768_a("red_paint", 0);
                this.getGun().func_77982_d(nbt);
                if (!this.field_145850_b.field_72995_K) {
                    this.sendUpdates();
                }
                return true;
            }
            if (this.white_paint.getFluidAmount() > 0 && nbt.func_74762_e("white_paint") < 32000) {
                return true;
            }
            if (this.yellow_paint.getFluidAmount() > 0 && nbt.func_74762_e("yellow_paint") < 32000) {
                return true;
            }
            if (this.red_paint.getFluidAmount() > 0 && nbt.func_74762_e("red_paint") < 32000) {
                return true;
            }
        }
        return false;
    }

    public void fillGun(NBTTagCompound nbt) {
        ItemStack stack = this.getGun();
        if (stack.func_77973_b() instanceof PaintGun) {
            FluidStack drained;
            int fillRate = 1000;
            boolean hasChanges = false;
            if (this.white_paint.getFluidAmount() > 0) {
                drained = null;
                drained = this.white_paint.getFluidAmount() >= fillRate && this.gun_white <= 32000 - fillRate ? this.white_paint.drain(new FluidStack((Fluid)FRFluids.white_paint, fillRate), true) : (this.white_paint.getFluidAmount() <= 32000 - this.gun_white ? this.white_paint.drain(new FluidStack((Fluid)FRFluids.white_paint, this.red_paint.getFluidAmount()), true) : this.white_paint.drain(new FluidStack((Fluid)FRFluids.white_paint, 32000 - this.gun_white), true));
                if (drained != null) {
                    hasChanges = true;
                    this.gun_white += drained.amount;
                }
            }
            if (this.yellow_paint.getFluidAmount() > 0) {
                drained = null;
                drained = this.yellow_paint.getFluidAmount() >= fillRate && this.gun_yellow <= 32000 - fillRate ? this.yellow_paint.drain(new FluidStack((Fluid)FRFluids.yellow_paint, fillRate), true) : (this.yellow_paint.getFluidAmount() <= 32000 - this.gun_yellow ? this.yellow_paint.drain(new FluidStack((Fluid)FRFluids.yellow_paint, this.yellow_paint.getFluidAmount()), true) : this.yellow_paint.drain(new FluidStack((Fluid)FRFluids.yellow_paint, 32000 - this.gun_yellow), true));
                if (drained != null) {
                    hasChanges = true;
                    this.gun_yellow += drained.amount;
                }
            }
            if (this.red_paint.getFluidAmount() > 0) {
                drained = null;
                drained = this.red_paint.getFluidAmount() >= fillRate && this.gun_red <= 32000 - fillRate ? this.red_paint.drain(new FluidStack((Fluid)FRFluids.red_paint, fillRate), true) : (this.red_paint.getFluidAmount() <= 32000 - this.gun_red ? this.red_paint.drain(new FluidStack((Fluid)FRFluids.red_paint, this.red_paint.getFluidAmount()), true) : this.red_paint.drain(new FluidStack((Fluid)FRFluids.red_paint, 32000 - this.gun_red), true));
                if (drained != null) {
                    hasChanges = true;
                    this.gun_red += drained.amount;
                }
            }
            if (hasChanges) {
                nbt.func_74768_a("white_paint", this.gun_white);
                nbt.func_74768_a("yellow_paint", this.gun_yellow);
                nbt.func_74768_a("red_paint", this.gun_red);
                this.sendUpdates();
            }
        }
    }

    public ItemStack getGun() {
        return this.inventory.getStackInSlot(1);
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        this.has_gun = nbt.func_74767_n("has_gun");
        this.fuel_remaining = nbt.func_74762_e("fuel");
        this.last_fuel_cap = nbt.func_74762_e("fuel_last_used");
        this.gun_white = nbt.func_74762_e("gun_white");
        this.gun_yellow = nbt.func_74762_e("gun_yellow");
        this.gun_red = nbt.func_74762_e("gun_red");
        if (this.gun_white > 32000) {
            this.gun_white = 32000;
        }
        if (this.gun_yellow > 32000) {
            this.gun_yellow = 32000;
        }
        if (this.gun_red > 32000) {
            this.gun_red = 32000;
        }
        if (nbt.func_74764_b("items")) {
            this.inventory.deserializeNBT((NBTTagCompound)nbt.func_74781_a("items"));
        }
        if (nbt.func_74764_b("paint_white")) {
            this.white_paint.readFromNBT((NBTTagCompound)nbt.func_74781_a("paint_white"));
        }
        if (nbt.func_74764_b("paint_yellow")) {
            this.yellow_paint.readFromNBT((NBTTagCompound)nbt.func_74781_a("paint_yellow"));
        }
        if (nbt.func_74764_b("paint_red")) {
            this.red_paint.readFromNBT((NBTTagCompound)nbt.func_74781_a("paint_red"));
        }
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("has_gun", this.has_gun);
        nbt.func_74768_a("fuel", this.fuel_remaining);
        nbt.func_74768_a("fuel_last_used", this.last_fuel_cap);
        nbt.func_74782_a("paint_white", (NBTBase)this.white_paint.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("paint_yellow", (NBTBase)this.yellow_paint.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("paint_red", (NBTBase)this.red_paint.writeToNBT(new NBTTagCompound()));
        nbt.func_74768_a("gun_white", this.gun_white);
        nbt.func_74768_a("gun_yellow", this.gun_yellow);
        nbt.func_74768_a("gun_red", this.gun_red);
        nbt.func_74782_a("items", (NBTBase)this.inventory.serializeNBT());
        return nbt;
    }
}

