/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.tileentities.distiller;

import com.silvaniastudios.roads.blocks.tileentities.RoadTEBlock;
import com.silvaniastudios.roads.blocks.tileentities.distiller.TarDistillerElectricEntity;
import com.silvaniastudios.roads.blocks.tileentities.distiller.TarDistillerEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public class TarDistillerBlock
extends RoadTEBlock {
    public static final PropertyBool FLUID_LEFT = PropertyBool.func_177716_a((String)"fluid_left");
    public static final PropertyBool FLUID_RIGHT = PropertyBool.func_177716_a((String)"fluid_right");
    public static final PropertyBool FLUID_TOP = PropertyBool.func_177716_a((String)"fluid_top");
    public static final PropertyBool FURNACE_ACTIVE = PropertyBool.func_177716_a((String)"furnace_active");

    public TarDistillerBlock(String name, boolean electric) {
        super(name, electric, 2);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)ROTATION, (Comparable)((Object)RoadTEBlock.EnumRotation.north)).func_177226_a((IProperty)FLUID_LEFT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)FLUID_RIGHT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)FLUID_TOP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)FURNACE_ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"roads.gui.tar_distiller.tooltip_1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"roads.gui.tar_distiller.tooltip_2", (Object[])new Object[0]));
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack held = player.func_184586_b(EnumHand.MAIN_HAND);
        if (world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TarDistillerEntity) {
            TarDistillerEntity te = (TarDistillerEntity)world.func_175625_s(pos);
            if (held.func_77973_b() == Items.field_151133_ar) {
                if (te.fluidOutput1.getFluidAmount() >= 1000) {
                    if (!player.func_184812_l_()) {
                        if (held.func_190916_E() > 1) {
                            held.func_190920_e(held.func_190916_E() - 1);
                        } else {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                        }
                    }
                    te.fluidOutput1.drain(1000, true);
                    te.sendUpdates();
                    ItemStack fluidBucket = FluidUtil.getFilledBucket((FluidStack)te.fluidOutput1.getFluid());
                    if (fluidBucket != null) {
                        player.func_191521_c(fluidBucket);
                    }
                    return true;
                }
                if (te.fluidOutput2.getFluidAmount() >= 1000) {
                    if (!player.func_184812_l_()) {
                        if (held.func_190916_E() > 1) {
                            held.func_190920_e(held.func_190916_E() - 1);
                        } else {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                        }
                    }
                    te.fluidOutput2.drain(1000, true);
                    te.sendUpdates();
                    player.func_191521_c(FluidUtil.getFilledBucket((FluidStack)te.fluidOutput2.getFluid()));
                    return true;
                }
                if (te.fluidInput.getFluidAmount() >= 1000) {
                    if (!player.func_184812_l_()) {
                        if (held.func_190916_E() > 1) {
                            held.func_190920_e(held.func_190916_E() - 1);
                        } else {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                        }
                    }
                    player.func_191521_c(FluidUtil.getFilledBucket((FluidStack)te.fluidInput.getFluid()));
                    te.fluidInput.drain(1000, true);
                    te.sendUpdates();
                    return true;
                }
            }
            if (held.func_77973_b().func_77658_a().compareTo("item.forge.bucketFilled") == 0) {
                FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)held);
                if (te.fluidInput.getFluidAmount() + 1000 <= 64000) {
                    if (te.fluidInput.getFluidAmount() > 0 && te.fluidInput.getFluid().getFluid() == fluidStack.getFluid() || te.fluidInput.getFluidAmount() == 0) {
                        if (!player.func_184812_l_()) {
                            if (held.func_190916_E() > 1) {
                                held.func_190920_e(held.func_190916_E() - 1);
                            } else {
                                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                            }
                            player.func_191521_c(new ItemStack(Items.field_151133_ar));
                        }
                        if (te.fluidInput.getFluidAmount() > 0) {
                            te.fluidInput.fill(fluidStack, true);
                        } else {
                            te.fluidInput.setFluid(fluidStack);
                        }
                    }
                    te.sendUpdates();
                    return true;
                }
            }
            if (held.func_77973_b() == Items.field_151131_as && te.fluidInput.getFluidAmount() + 1000 <= 64000) {
                if (te.fluidInput.getFluidAmount() > 0 && te.fluidInput.getFluid().getFluid() == FluidRegistry.WATER) {
                    te.fluidInput.fill(new FluidStack(FluidRegistry.WATER, 1000), true);
                } else {
                    te.fluidInput.setFluid(new FluidStack(FluidRegistry.WATER, 1000));
                }
                if (!player.func_184812_l_()) {
                    if (held.func_190916_E() > 1) {
                        held.func_190920_e(held.func_190916_E() - 1);
                    } else {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                    }
                    player.func_191521_c(new ItemStack(Items.field_151133_ar));
                }
                te.sendUpdates();
                return true;
            }
        }
        return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        if (this.electric) {
            return new TarDistillerElectricEntity();
        }
        return new TarDistillerEntity();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing left = EnumFacing.WEST;
        EnumFacing right = EnumFacing.EAST;
        if (this.func_176201_c(state) == 1) {
            left = EnumFacing.NORTH;
            right = EnumFacing.SOUTH;
        }
        if (this.func_176201_c(state) == 2) {
            left = EnumFacing.EAST;
            right = EnumFacing.WEST;
        }
        if (this.func_176201_c(state) == 3) {
            left = EnumFacing.SOUTH;
            right = EnumFacing.NORTH;
        }
        boolean fluid_left = this.fluidLeft(world, pos, left, right);
        boolean fluid_right = this.fluidRight(world, pos, left, right);
        boolean fluid_top = this.fluidTop(world, pos);
        return state.func_177226_a((IProperty)FURNACE_ACTIVE, (Comparable)Boolean.valueOf(this.isFurnaceEnabled(state, world, pos))).func_177226_a((IProperty)FLUID_LEFT, (Comparable)Boolean.valueOf(fluid_left)).func_177226_a((IProperty)FLUID_RIGHT, (Comparable)Boolean.valueOf(fluid_right)).func_177226_a((IProperty)FLUID_TOP, (Comparable)Boolean.valueOf(fluid_top)).func_177226_a((IProperty)BASE_PLATE, (Comparable)Boolean.valueOf(this.hasBasePlate(world, pos)));
    }

    private boolean fluidLeft(IBlockAccess world, BlockPos pos, EnumFacing left, EnumFacing right) {
        TileEntity e;
        return world.func_175625_s(pos.func_177972_a(left)) != null && (e = world.func_175625_s(pos.func_177972_a(left))).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, right);
    }

    private boolean fluidRight(IBlockAccess world, BlockPos pos, EnumFacing left, EnumFacing right) {
        TileEntity e;
        return world.func_175625_s(pos.func_177972_a(right)) != null && (e = world.func_175625_s(pos.func_177972_a(right))).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, left);
    }

    private boolean fluidTop(IBlockAccess world, BlockPos pos) {
        TileEntity e;
        return world.func_175625_s(pos.func_177972_a(EnumFacing.UP)) != null && ((e = world.func_175625_s(pos.func_177972_a(EnumFacing.UP))).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN) || e.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        double top;
        EnumFacing left = EnumFacing.WEST;
        EnumFacing right = EnumFacing.EAST;
        int meta = this.func_176201_c(state);
        if (meta == 1) {
            left = EnumFacing.NORTH;
            right = EnumFacing.SOUTH;
        }
        if (meta == 2) {
            left = EnumFacing.EAST;
            right = EnumFacing.WEST;
        }
        if (meta == 3) {
            left = EnumFacing.SOUTH;
            right = EnumFacing.NORTH;
        }
        boolean fluid_left = this.fluidLeft(world, pos, left, right);
        boolean fluid_right = this.fluidRight(world, pos, left, right);
        boolean fluid_top = this.fluidTop(world, pos);
        double d = top = fluid_top ? 1.0 : 0.9375;
        if (meta == 0) {
            double l = fluid_left ? 0.0 : 0.0625;
            double r = fluid_right ? 1.0 : 0.9375;
            return new AxisAlignedBB(l, 0.0, 0.0625, r, top, 0.9375);
        }
        if (meta == 1) {
            double l = fluid_left ? 0.0 : 0.0625;
            double r = fluid_right ? 1.0 : 0.9375;
            return new AxisAlignedBB(0.0625, 0.0, l, 0.9375, top, r);
        }
        if (meta == 2) {
            double l = fluid_right ? 0.0 : 0.0625;
            double r = fluid_left ? 1.0 : 0.9375;
            return new AxisAlignedBB(l, 0.0, 0.0625, r, top, 0.9375);
        }
        if (meta == 3) {
            double l = fluid_right ? 0.0 : 0.0625;
            double r = fluid_left ? 1.0 : 0.9375;
            return new AxisAlignedBB(0.0625, 0.0, l, 0.9375, top, r);
        }
        return new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, top, 0.9375);
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.func_185496_a(state, world, pos);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FLUID_LEFT, FLUID_RIGHT, FLUID_TOP, ROTATION, FURNACE_ACTIVE, BASE_PLATE});
    }
}

