/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.tileentities.compactor;

import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.RoadsConfig;
import com.silvaniastudios.roads.blocks.tileentities.RoadTileEntity;
import com.silvaniastudios.roads.blocks.tileentities.compactor.CompactorContainer;
import com.silvaniastudios.roads.blocks.tileentities.compactor.CompactorStackHandler;
import com.silvaniastudios.roads.blocks.tileentities.recipes.CompactorRecipes;
import com.silvaniastudios.roads.blocks.tileentities.recipes.RecipeRegistry;
import com.silvaniastudios.roads.items.ItemFragment;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class CompactorEntity
extends RoadTileEntity
implements ITickable,
ICapabilityProvider {
    public int timerCount = 0;
    public int road_size = 15;
    public ItemStackHandler inventory = new ItemStackHandler(3){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot == 0 && stack.func_77973_b() instanceof ItemFragment;
        }
    };
    public CompactorStackHandler interactable_inv = new CompactorStackHandler(this.inventory, this.hasCapability(CapabilityEnergy.ENERGY, null));

    public Container createContainer(EntityPlayer player) {
        return new CompactorContainer(player.field_71071_by, this, false);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.getCapability(capability, facing) != null;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing != null) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.interactable_inv);
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        if (this.fuel_remaining > 0) {
            --this.fuel_remaining;
        } else if (this.fuel_remaining <= 0) {
            if (!this.inventory.getStackInSlot(2).func_190926_b()) {
                this.last_fuel_cap = this.fuel_remaining = TileEntityFurnace.func_145952_a((ItemStack)this.inventory.getStackInSlot(2));
                if (this.inventory.getStackInSlot(2).func_77973_b() == Items.field_151129_at) {
                    this.inventory.setStackInSlot(2, new ItemStack(Items.field_151133_ar));
                } else {
                    this.inventory.extractItem(2, 1, false);
                }
                this.sendUpdates();
            } else {
                this.timerCount = 0;
            }
        }
        if (this.timerCount < RoadsConfig.machine.compactorTickRate && this.fuel_remaining > 0) {
            this.timerCount = this.shouldTick() ? ++this.timerCount : 0;
        } else {
            if (this.fuel_remaining > 0) {
                this.process();
            }
            this.timerCount = 0;
        }
    }

    public void process() {
        ItemStack recipeOut;
        ItemStack out;
        ItemStack in;
        if (!(this.field_145850_b.field_72995_K || (in = this.inventory.getStackInSlot(0)).func_190916_E() <= this.road_size || (out = this.inventory.getStackInSlot(1)) != ItemStack.field_190927_a && out.func_190916_E() >= out.func_77976_d() || (recipeOut = this.getRecipeResult()).func_190916_E() <= 0 || out != ItemStack.field_190927_a && (out.func_77973_b() != recipeOut.func_77973_b() || out.func_190916_E() >= out.func_77976_d()))) {
            this.inventory.extractItem(0, this.road_size + 1, false);
            this.inventory.insertItem(1, recipeOut, false);
            FurenikusRoads.debug(2, "Compactor at" + this.formatPosition(this.field_174879_c) + "processing");
            this.sendUpdates();
        }
    }

    public boolean shouldTick() {
        ItemStack out;
        ItemStack in = this.inventory.getStackInSlot(0);
        return in.func_190916_E() > this.road_size && ((out = this.inventory.getStackInSlot(1)).func_190916_E() == 0 || out.func_77973_b() == this.getRecipeResult().func_77973_b() && out.func_190916_E() < out.func_77976_d());
    }

    public ItemStack getRecipeResult() {
        for (int i = 0; i < RecipeRegistry.compactorRecipes.size(); ++i) {
            CompactorRecipes recipe = RecipeRegistry.compactorRecipes.get(i);
            ItemStack out = recipe.getCraftingResult(this.inventory, this.road_size);
            if (out.func_190916_E() <= 0 || this.inventory.insertItem(1, out, true).func_190916_E() != 0) continue;
            return out;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        this.fuel_remaining = nbt.func_74762_e("fuel");
        this.last_fuel_cap = nbt.func_74762_e("fuel_last_used");
        this.road_size = nbt.func_74762_e("road_size");
        if (nbt.func_74764_b("items")) {
            this.inventory.deserializeNBT((NBTTagCompound)nbt.func_74781_a("items"));
        }
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("fuel", this.fuel_remaining);
        nbt.func_74768_a("fuel_last_used", this.last_fuel_cap);
        nbt.func_74768_a("road_size", this.road_size);
        nbt.func_74782_a("items", (NBTBase)this.inventory.serializeNBT());
        return nbt;
    }
}

