/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.tileentities;

import com.google.common.collect.ImmutableList;
import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.blocks.tileentities.RoadTileEntity;
import com.silvaniastudios.roads.items.ItemWrench;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class RoadTEBlock
extends Block {
    protected String name;
    public static final PropertyEnum<EnumRotation> ROTATION = PropertyEnum.func_177709_a((String)"rotation", EnumRotation.class);
    public static final PropertyBool FURNACE_ACTIVE = PropertyBool.func_177716_a((String)"furnace_active");
    public static final PropertyBool BASE_PLATE = PropertyBool.func_177716_a((String)"base_plate");
    private int guiId = 0;
    protected boolean electric;

    public RoadTEBlock(String name, boolean electric, int guiId) {
        super(Material.field_151573_f);
        this.name = name;
        this.func_149663_c("furenikusroads." + name);
        this.setRegistryName(name);
        this.func_149647_a(FurenikusRoads.tab_tools);
        this.func_149711_c(2.5f);
        this.setHarvestLevel("pickaxe", 1);
        this.guiId = guiId;
        this.electric = electric;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        if (placer.func_174811_aO() == EnumFacing.NORTH) {
            return this.func_176223_P().func_177226_a(ROTATION, (Comparable)((Object)EnumRotation.north));
        }
        if (placer.func_174811_aO() == EnumFacing.EAST) {
            return this.func_176223_P().func_177226_a(ROTATION, (Comparable)((Object)EnumRotation.east));
        }
        if (placer.func_174811_aO() == EnumFacing.SOUTH) {
            return this.func_176223_P().func_177226_a(ROTATION, (Comparable)((Object)EnumRotation.south));
        }
        if (placer.func_174811_aO() == EnumFacing.WEST) {
            return this.func_176223_P().func_177226_a(ROTATION, (Comparable)((Object)EnumRotation.west));
        }
        return super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null) {
            IItemHandler cap = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            for (int i = 0; i < cap.getSlots(); ++i) {
                ItemStack stack = cap.getStackInSlot(i);
                if (stack == ItemStack.field_190927_a) continue;
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
            }
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_184586_b(hand).func_77973_b() instanceof ItemWrench) {
            ItemWrench wrench = (ItemWrench)player.func_184586_b(hand).func_77973_b();
            int mode = wrench.getMode(player.func_184586_b(hand));
            if (mode == 0) {
                if (((EnumRotation)((Object)state.func_177229_b(ROTATION))).equals((Object)EnumRotation.north)) {
                    world.func_175656_a(pos, state.func_177226_a(ROTATION, (Comparable)((Object)EnumRotation.east)));
                }
                if (((EnumRotation)((Object)state.func_177229_b(ROTATION))).equals((Object)EnumRotation.east)) {
                    world.func_175656_a(pos, state.func_177226_a(ROTATION, (Comparable)((Object)EnumRotation.south)));
                }
                if (((EnumRotation)((Object)state.func_177229_b(ROTATION))).equals((Object)EnumRotation.south)) {
                    world.func_175656_a(pos, state.func_177226_a(ROTATION, (Comparable)((Object)EnumRotation.west)));
                }
                if (((EnumRotation)((Object)state.func_177229_b(ROTATION))).equals((Object)EnumRotation.west)) {
                    world.func_175656_a(pos, state.func_177226_a(ROTATION, (Comparable)((Object)EnumRotation.north)));
                }
            }
            if (mode == 1 && world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof RoadTileEntity) {
                RoadTileEntity te = (RoadTileEntity)world.func_175625_s(pos);
                te.hasBasePlate = !te.hasBasePlate;
                te.sendUpdates();
            }
        } else {
            this.openGui(world, pos, player);
        }
        return true;
    }

    public void openGui(World world, BlockPos pos, EntityPlayer player) {
        TileEntity te = world.func_175625_s(pos);
        if (!world.field_72995_K && te != null && te instanceof RoadTileEntity) {
            player.openGui((Object)FurenikusRoads.instance, this.guiId + (this.electric ? 5 : 0), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    public boolean isElectric() {
        return this.electric;
    }

    public boolean hasBasePlate(IBlockAccess world, BlockPos pos) {
        if (world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof RoadTileEntity) {
            RoadTileEntity te = (RoadTileEntity)world.func_175625_s(pos);
            return te.hasBasePlate;
        }
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public int func_176201_c(IBlockState state) {
        if (((EnumRotation)((Object)state.func_177229_b(ROTATION))).equals((Object)EnumRotation.north)) {
            return 0;
        }
        if (((EnumRotation)((Object)state.func_177229_b(ROTATION))).equals((Object)EnumRotation.east)) {
            return 1;
        }
        if (((EnumRotation)((Object)state.func_177229_b(ROTATION))).equals((Object)EnumRotation.south)) {
            return 2;
        }
        if (((EnumRotation)((Object)state.func_177229_b(ROTATION))).equals((Object)EnumRotation.west)) {
            return 3;
        }
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        if (meta == 0) {
            return this.func_176223_P().func_177226_a(ROTATION, (Comparable)((Object)EnumRotation.north));
        }
        if (meta == 1) {
            return this.func_176223_P().func_177226_a(ROTATION, (Comparable)((Object)EnumRotation.east));
        }
        if (meta == 2) {
            return this.func_176223_P().func_177226_a(ROTATION, (Comparable)((Object)EnumRotation.south));
        }
        return this.func_176223_P().func_177226_a(ROTATION, (Comparable)((Object)EnumRotation.west));
    }

    public void registerItemModel(Item itemBlock) {
        FurenikusRoads.proxy.registerItemRenderer(itemBlock, 0, this.name);
    }

    public Item createItemBlock() {
        return (Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName());
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        DefaultStateMapper b = new DefaultStateMapper();
        BlockStateContainer bsc = this.func_176194_O();
        ImmutableList values = bsc.func_177619_a();
        for (IBlockState state : values) {
            ModelResourceLocation mrl = new ModelResourceLocation(state.func_177230_c().getRegistryName(), b.func_178131_a((Map)state.func_177228_b()));
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)state.func_177230_c()), (int)this.func_176201_c(state), (ModelResourceLocation)mrl);
        }
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isFurnaceEnabled(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof RoadTileEntity) {
            RoadTileEntity tileEntity = (RoadTileEntity)te;
            if (tileEntity.fuel_remaining > 0) {
                return true;
            }
        }
        return false;
    }

    public static enum EnumRotation implements IStringSerializable
    {
        north("north"),
        east("east"),
        south("south"),
        west("west");

        private final String name;

        private EnumRotation(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static EnumRotation byMeta(int meta) {
            if (meta == 0) {
                return north;
            }
            if (meta == 1) {
                return east;
            }
            if (meta == 2) {
                return south;
            }
            return west;
        }
    }
}

