/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.paint;

import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.blocks.FRBlocks;
import com.silvaniastudios.roads.blocks.PaintColour;
import com.silvaniastudios.roads.blocks.enums.IMetaBlockName;
import com.silvaniastudios.roads.blocks.paint.JunctionFilterLinePaintBlock;
import com.silvaniastudios.roads.blocks.paint.PaintBlockBase;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ChevronPaintBlock
extends PaintBlockBase
implements IMetaBlockName {
    public static final PropertyEnum<EnumType> META_ID = PropertyEnum.func_177709_a((String)"rotation", EnumType.class);
    public static final PropertyEnum<EnumJunctionConnections> TYPE = PropertyEnum.func_177709_a((String)"connect", EnumJunctionConnections.class);
    public static final PropertyBool EDGE = PropertyBool.func_177716_a((String)"edge");
    public static final PropertyBool HIDE = PropertyBool.func_177716_a((String)"hide");

    public ChevronPaintBlock(String name, EnumJunctionConnections type, boolean aType, String category, int[] coreMetas, boolean dynamic, PaintColour colour) {
        super(name, category, coreMetas, dynamic, colour);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(META_ID, (Comparable)((Object)EnumType.NORTH)).func_177226_a(TYPE, (Comparable)((Object)type)).func_177226_a((IProperty)EDGE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)HIDE, (Comparable)Boolean.valueOf(false)));
        if (!aType) {
            this.func_149647_a(null);
        } else {
            this.func_149647_a(FurenikusRoads.tab_paint_junction);
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        int i;
        IBlockState stateNorth = world.func_180495_p(pos.func_177972_a(EnumFacing.NORTH));
        IBlockState stateEast = world.func_180495_p(pos.func_177972_a(EnumFacing.EAST));
        IBlockState stateSouth = world.func_180495_p(pos.func_177972_a(EnumFacing.SOUTH));
        IBlockState stateWest = world.func_180495_p(pos.func_177972_a(EnumFacing.WEST));
        IBlockState stateLeft = null;
        IBlockState stateRight = null;
        IBlockState stateUp = null;
        IBlockState stateDown = null;
        int rot = 0;
        if (placer.func_174811_aO().equals((Object)EnumFacing.NORTH)) {
            stateLeft = stateWest;
            stateRight = stateEast;
            stateUp = stateNorth;
            stateDown = stateSouth;
            rot = 0;
        }
        if (placer.func_174811_aO().equals((Object)EnumFacing.EAST)) {
            stateLeft = stateNorth;
            stateRight = stateSouth;
            stateUp = stateEast;
            stateDown = stateWest;
            rot = 1;
        }
        if (placer.func_174811_aO().equals((Object)EnumFacing.SOUTH)) {
            stateLeft = stateEast;
            stateRight = stateWest;
            stateUp = stateSouth;
            stateDown = stateNorth;
            rot = 2;
        }
        if (placer.func_174811_aO().equals((Object)EnumFacing.WEST)) {
            stateLeft = stateSouth;
            stateRight = stateNorth;
            stateUp = stateWest;
            stateDown = stateEast;
            rot = 3;
        }
        ArrayList<ChevronPaintBlock> chevronALeft = new ArrayList<ChevronPaintBlock>();
        ArrayList<ChevronPaintBlock> chevronARight = new ArrayList<ChevronPaintBlock>();
        ArrayList<ChevronPaintBlock> chevronBLeft = new ArrayList<ChevronPaintBlock>();
        ArrayList<ChevronPaintBlock> chevronBRight = new ArrayList<ChevronPaintBlock>();
        for (i = 0; i < FRBlocks.col.size(); ++i) {
            chevronALeft.add((ChevronPaintBlock)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("furenikusroads", FRBlocks.col.get(i).getName() + "_chevron_left_a")));
            chevronALeft.add((ChevronPaintBlock)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("furenikusroads", FRBlocks.col.get(i).getName() + "_chevron_left_a_thin")));
            chevronARight.add((ChevronPaintBlock)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("furenikusroads", FRBlocks.col.get(i).getName() + "_chevron_right_a")));
            chevronARight.add((ChevronPaintBlock)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("furenikusroads", FRBlocks.col.get(i).getName() + "_chevron_right_a_thin")));
            chevronBLeft.add((ChevronPaintBlock)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("furenikusroads", FRBlocks.col.get(i).getName() + "_chevron_left_b")));
            chevronBLeft.add((ChevronPaintBlock)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("furenikusroads", FRBlocks.col.get(i).getName() + "_chevron_left_b_thin")));
            chevronBRight.add((ChevronPaintBlock)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("furenikusroads", FRBlocks.col.get(i).getName() + "_chevron_right_b")));
            chevronBRight.add((ChevronPaintBlock)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("furenikusroads", FRBlocks.col.get(i).getName() + "_chevron_right_b_thin")));
        }
        for (i = 0; i < chevronALeft.size(); ++i) {
            if ((chevronALeft.contains(this) || chevronBLeft.contains(this)) && !(stateLeft.func_177230_c() instanceof ChevronPaintBlock)) {
                if (chevronARight.contains(stateRight.func_177230_c())) {
                    return ((ChevronPaintBlock)chevronALeft.get(chevronARight.indexOf(stateRight.func_177230_c()))).func_176223_P().func_177226_a(META_ID, (Comparable)((Object)EnumType.byId(rot)));
                }
                if (chevronBRight.contains(stateRight.func_177230_c())) {
                    return ((ChevronPaintBlock)chevronBLeft.get(chevronBRight.indexOf(stateRight.func_177230_c()))).func_176223_P().func_177226_a(META_ID, (Comparable)((Object)EnumType.byId(rot)));
                }
            }
            if ((chevronARight.contains(this) || chevronBRight.contains(this)) && !(stateRight.func_177230_c() instanceof ChevronPaintBlock)) {
                if (chevronALeft.contains(stateLeft.func_177230_c())) {
                    return ((ChevronPaintBlock)chevronARight.get(chevronALeft.indexOf(stateLeft.func_177230_c()))).func_176223_P().func_177226_a(META_ID, (Comparable)((Object)EnumType.byId(rot)));
                }
                if (chevronBLeft.contains(stateLeft.func_177230_c())) {
                    return ((ChevronPaintBlock)chevronBRight.get(chevronBLeft.indexOf(stateLeft.func_177230_c()))).func_176223_P().func_177226_a(META_ID, (Comparable)((Object)EnumType.byId(rot)));
                }
            }
            if (this.equals(chevronALeft.get(i)) || this.equals(chevronBLeft.get(i))) {
                if (stateLeft.func_177230_c().equals(chevronALeft.get(i)) || stateRight.func_177230_c().equals(chevronALeft.get(i))) {
                    return ((ChevronPaintBlock)chevronBLeft.get(i)).func_176223_P().func_177226_a(META_ID, (Comparable)((Object)EnumType.byId(rot)));
                }
                if (stateLeft.func_177230_c().equals(chevronBLeft.get(i)) || stateRight.func_177230_c().equals(chevronBLeft.get(i))) {
                    return ((ChevronPaintBlock)chevronALeft.get(i)).func_176223_P().func_177226_a(META_ID, (Comparable)((Object)EnumType.byId(rot)));
                }
                if (stateUp.func_177230_c().equals(chevronALeft.get(i)) || stateDown.func_177230_c().equals(chevronALeft.get(i))) {
                    return ((ChevronPaintBlock)chevronALeft.get(i)).func_176223_P().func_177226_a(META_ID, (Comparable)((Object)EnumType.byId(rot)));
                }
                if (stateUp.func_177230_c().equals(chevronBLeft.get(i)) || stateDown.func_177230_c().equals(chevronBLeft.get(i))) {
                    return ((ChevronPaintBlock)chevronBLeft.get(i)).func_176223_P().func_177226_a(META_ID, (Comparable)((Object)EnumType.byId(rot)));
                }
            }
            if (!this.equals(chevronARight.get(i)) && !this.equals(chevronBRight.get(i))) continue;
            if (stateLeft.func_177230_c().equals(chevronARight.get(i)) || stateRight.func_177230_c().equals(chevronARight.get(i))) {
                return ((ChevronPaintBlock)chevronBRight.get(i)).func_176223_P().func_177226_a(META_ID, (Comparable)((Object)EnumType.byId(rot)));
            }
            if (stateLeft.func_177230_c().equals(chevronBRight.get(i)) || stateRight.func_177230_c().equals(chevronBRight.get(i))) {
                return ((ChevronPaintBlock)chevronARight.get(i)).func_176223_P().func_177226_a(META_ID, (Comparable)((Object)EnumType.byId(rot)));
            }
            if (stateUp.func_177230_c().equals(chevronARight.get(i)) || stateDown.func_177230_c().equals(chevronARight.get(i))) {
                return ((ChevronPaintBlock)chevronARight.get(i)).func_176223_P().func_177226_a(META_ID, (Comparable)((Object)EnumType.byId(rot)));
            }
            if (!stateUp.func_177230_c().equals(chevronBRight.get(i)) && !stateDown.func_177230_c().equals(chevronBRight.get(i))) continue;
            return ((ChevronPaintBlock)chevronBRight.get(i)).func_176223_P().func_177226_a(META_ID, (Comparable)((Object)EnumType.byId(rot)));
        }
        return this.func_176223_P().func_177226_a(META_ID, (Comparable)((Object)EnumType.byId(rot)));
    }

    public int placeMeta(int meta, IBlockState state) {
        if (state.func_177230_c() instanceof ChevronPaintBlock) {
            int sideMeta = state.func_177230_c().func_176201_c(state);
            if (sideMeta > 3) {
                return meta;
            }
            return meta + 4;
        }
        return meta;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, 0));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(META_ID))).getId();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(META_ID, (Comparable)((Object)EnumType.byId(meta)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{META_ID, TYPE, EDGE, HIDE});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)EDGE, (Comparable)Boolean.valueOf(this.connectToLine(state, worldIn, pos))).func_177226_a((IProperty)HIDE, (Comparable)Boolean.valueOf(this.shouldHide(state, worldIn, pos)));
    }

    private boolean shouldHide(IBlockState state, IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos.func_177972_a(EnumFacing.UP)).func_177230_c() instanceof JunctionFilterLinePaintBlock || world.func_180495_p(pos.func_177972_a(EnumFacing.DOWN)).func_177230_c() instanceof JunctionFilterLinePaintBlock;
    }

    private boolean connectToLine(IBlockState state, IBlockAccess world, BlockPos pos) {
        int meta = this.func_176201_c(state);
        if (meta == 0) {
            return this.isBottomSection(world.func_180495_p(pos.func_177976_e())) || this.isBottomSection(world.func_180495_p(pos.func_177974_f()));
        }
        if (meta == 1) {
            return this.isBottomSection(world.func_180495_p(pos.func_177978_c())) || this.isBottomSection(world.func_180495_p(pos.func_177968_d()));
        }
        if (meta == 2) {
            return this.isBottomSection(world.func_180495_p(pos.func_177974_f())) || this.isBottomSection(world.func_180495_p(pos.func_177976_e()));
        }
        if (meta == 3) {
            return this.isBottomSection(world.func_180495_p(pos.func_177968_d())) || this.isBottomSection(world.func_180495_p(pos.func_177978_c()));
        }
        return false;
    }

    private boolean isBottomSection(IBlockState state) {
        JunctionFilterLinePaintBlock block;
        int meta;
        return state.func_177230_c() instanceof JunctionFilterLinePaintBlock && ((meta = (block = (JunctionFilterLinePaintBlock)state.func_177230_c()).func_176201_c(state)) == 3 || meta == 7 || meta == 11 || meta == 15);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public String getSpecialName(ItemStack stack) {
        return stack.func_77952_i() + "";
    }

    public static enum EnumJunctionConnections implements IStringSerializable
    {
        NONE(0, "none"),
        CHEVRON_A(1, "chevron_a"),
        CHEVRON_B(2, "chevron_b"),
        CHEVRON_THIN_A(3, "chevron_thin_a"),
        CHEVRON_THIN_B(4, "chevron_thin_b");

        private static final EnumJunctionConnections[] ID_LOOKUP;
        private final int id;
        private final String name;

        private EnumJunctionConnections(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public static EnumJunctionConnections byId(int id) {
            if (id < 0 || id >= ID_LOOKUP.length) {
                id = 0;
            }
            return ID_LOOKUP[id];
        }

        static {
            ID_LOOKUP = new EnumJunctionConnections[EnumJunctionConnections.values().length];
            EnumJunctionConnections[] enumJunctionConnectionsArray = EnumJunctionConnections.values();
            int n = enumJunctionConnectionsArray.length;
            for (int i = 0; i < n; ++i) {
                EnumJunctionConnections type;
                EnumJunctionConnections.ID_LOOKUP[type.getId()] = type = enumJunctionConnectionsArray[i];
            }
        }
    }

    public static enum EnumType implements IStringSerializable
    {
        NORTH(0, "north"),
        EAST(1, "east"),
        SOUTH(2, "south"),
        WEST(3, "west");

        private static final EnumType[] ID_LOOKUP;
        private final int id;
        private final String name;

        private EnumType(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public static EnumType byId(int id) {
            if (id < 0 || id >= ID_LOOKUP.length) {
                id = 0;
            }
            return ID_LOOKUP[id];
        }

        static {
            ID_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType type;
                EnumType.ID_LOOKUP[type.getId()] = type = enumTypeArray[i];
            }
        }
    }
}

